/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.Dbms;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.editor.SqlColors;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.sql.psi.impl.lexer.SqlStringTokenLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSyntaxHighlighter
extends SyntaxHighlighterBase {
    private final SqlLanguageDialect myDialect;
    private final Project myProject;
    private final VirtualFile myFile;

    public SqlSyntaxHighlighter(@Nullable SqlLanguageDialect dialect, @Nullable Project project) {
        this(dialect, project, null);
    }

    public SqlSyntaxHighlighter(@Nullable SqlLanguageDialect dialect, @Nullable Project project, @Nullable VirtualFile file) {
        this.myDialect = dialect;
        this.myProject = project;
        this.myFile = file;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)(this.myDialect != null ? this.myDialect : SqlLanguage.INSTANCE));
        Language hostLanguage = SqlPreprocessingLexer.getHostLanguage((PsiElement)this.findInjectionHost());
        MyLayeredLexer myLayeredLexer = new MyLayeredLexer(SqlPreprocessingLexer.withPreprocessingIfNeeded(this.myProject, definition, hostLanguage), this.myDialect == null ? Dbms.UNKNOWN : this.myDialect.getDbms());
        if (myLayeredLexer == null) {
            SqlSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return myLayeredLexer;
    }

    @Nullable
    protected PsiLanguageInjectionHost findInjectionHost() {
        return InjectedLanguageUtil.findInjectionHost((VirtualFile)this.myFile);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public SqlLanguageDialect getDialect() {
        return this.myDialect;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType == SqlTokens.BAD_CHARACTER || tokenType == SqlTokens.SQL_UNCLOSED_TOKEN) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_BAD_CHARACTER);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        if (SqlTokens.COMMENT_TOKENS.contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_COMMENT);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlCommonTokens.SQL_SEMICOLON) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_SEMICOLON);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(3);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlCommonTokens.SQL_COMMA) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_COMMA);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(4);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_PERIOD) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_DOT);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(5);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_STRING_TOKEN || tokenType == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN || tokenType == SqlTokens.SQL_CUSTOM_LQUOTE || tokenType == SqlTokens.SQL_CUSTOM_RQUOTE) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_STRING);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(6);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_LEFT_PAREN || tokenType == SqlTokens.SQL_RIGHT_PAREN) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_PARENS);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(7);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_LEFT_BRACKET || tokenType == SqlTokens.SQL_RIGHT_BRACKET) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_BRACKETS);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(8);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_LEFT_BRACE || tokenType == SqlTokens.SQL_RIGHT_BRACE) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_BRACES);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(9);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_INTEGER_TOKEN || tokenType == SqlTokens.SQL_FLOAT_TOKEN) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_NUMBER);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(10);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_EXTERNAL_PARAM || tokenType == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX || tokenType == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE || tokenType == SqlTokens.SQL_CUSTOM_PARAM_RQUOTE) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_PARAMETER);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(11);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_KEYWORD_TOKEN || tokenType instanceof SqlKeywordTokenType) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_KEYWORD);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(12);
            }
            return textAttributesKeyArray;
        }
        if (tokenType == SqlTokens.SQL_RAW_INPUT) {
            TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack((TextAttributesKey)SqlColors.SQL_EXTERNAL_TOOL);
            if (textAttributesKeyArray == null) {
                SqlSyntaxHighlighter.$$$reportNull$$$0(13);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = SqlSyntaxHighlighter.pack(null);
        if (textAttributesKeyArray == null) {
            SqlSyntaxHighlighter.$$$reportNull$$$0(14);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/editor/SqlSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    protected static class MyLayeredLexer
    extends LayeredLexer {
        public MyLayeredLexer(Lexer lexer, Dbms dbms) {
            super(lexer);
            this.registerSelfStoppingLayer((Lexer)new SqlStringTokenLexer(dbms), new IElementType[]{SqlTokens.SQL_STRING_TOKEN}, IElementType.EMPTY_ARRAY);
        }

        @Nullable
        public IElementType getTokenType() {
            IElementType type = super.getTokenType();
            return type instanceof SqlKeywordTokenType && type.getIndex() < 0 ? SqlTokens.SQL_KEYWORD_TOKEN : type;
        }
    }
}

