/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.database.Dbms;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.FunctionUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/editor/SqlRecursiveCallLineMakerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getIcon", "Ljavax/swing/Icon;", "getLineMarkerInfo", "element", "getName", "", "isRecursiveCall", "", "refExpr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "SqlRecursiveCallMarkerInfo", "intellij.database.sql.impl"})
public final class SqlRecursiveCallLineMakerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return "Recursive call";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.RecursiveMethod;
        if (icon == null) {
            Intrinsics.throwNpe();
        }
        return icon;
    }

    @Nullable
    public LineMarkerInfo<PsiElement> getLineMarkerInfo(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo<PsiElement>> result2) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        for (PsiElement element2 : elements) {
            SqlReferenceExpression refExpr;
            ProgressManager.checkCanceled();
            PsiElement psiElement = element2.getParent();
            if (!(psiElement instanceof SqlIdentifier)) {
                psiElement = null;
            }
            SqlIdentifier sqlIdentifier = (SqlIdentifier)psiElement;
            Object object = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
            if (!(object instanceof SqlReferenceExpression)) {
                object = null;
            }
            if ((SqlReferenceExpression)object == null) {
                continue;
            }
            if (!this.isRecursiveCall(refExpr)) continue;
            Collection<LineMarkerInfo<PsiElement>> collection = result2;
            SqlRecursiveCallMarkerInfo sqlRecursiveCallMarkerInfo = new SqlRecursiveCallMarkerInfo(element2);
            boolean bl = false;
            collection.add(sqlRecursiveCallMarkerInfo);
        }
    }

    private final boolean isRecursiveCall(SqlReferenceExpression refExpr) {
        ResolveResult[] resolveResultArray = refExpr.multiResolve(false);
        int n = resolveResultArray.length;
        for (int j = 0; j < n; ++j) {
            PsiElement target2;
            block13: {
                block12: {
                    ResolveResult result2;
                    ResolveResult resolveResult = result2 = resolveResultArray[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolveResult, (String)"result");
                    if (resolveResult.getElement() == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)target2, (String)"result.element ?: continue");
                    if (!(target2 instanceof SqlRoutineDefinition)) break block12;
                    PsiElement psiElement = refExpr.getParent();
                    if (!(psiElement instanceof SqlFunctionCallExpression)) {
                        psiElement = null;
                    }
                    SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement;
                    if (Intrinsics.areEqual((Object)(sqlFunctionCallExpression != null ? sqlFunctionCallExpression.getNameElement() : null), (Object)refExpr)) break block13;
                }
                if (!(target2 instanceof SqlAsExpression)) continue;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)target2, (PsiElement)((PsiElement)refExpr), (boolean)true)) {
                return true;
            }
            PsiFile psiFile = refExpr.getContainingFile();
            if (!(psiFile instanceof SqlCodeFragment)) {
                psiFile = null;
            }
            SqlCodeFragment sqlCodeFragment = (SqlCodeFragment)psiFile;
            if (sqlCodeFragment == null) {
                return false;
            }
            SqlCodeFragment file = sqlCodeFragment;
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
            Dbms dbms = sqlLanguageDialectEx.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"SqlImplUtil.getSqlDialectSafe(file).dbms");
            if (!dbms.isSnowflake()) {
                return false;
            }
            if (Intrinsics.areEqual((Object)file.getElementType(), (Object)SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION) ^ true) {
                return false;
            }
            PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
            if (psiLanguageInjectionHost == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiLanguageInjectionHost, (String)"InjectedLanguageManager.\u2026ost(file) ?: return false");
            PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
            return PsiTreeUtil.isAncestor((PsiElement)target2, (PsiElement)((PsiElement)injectionHost), (boolean)true);
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/editor/SqlRecursiveCallLineMakerProvider$SqlRecursiveCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "name", "(Lcom/intellij/psi/PsiElement;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "intellij.database.sql.impl"})
    private static final class SqlRecursiveCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        @Nullable
        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this, (LineMarkerInfo)this){
                final /* synthetic */ SqlRecursiveCallMarkerInfo this$0;

                @Nullable
                public AnAction getClickAction() {
                    return null;
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            };
        }

        public SqlRecursiveCallMarkerInfo(@NotNull PsiElement name2) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            super(name2, name2.getTextRange(), AllIcons.Gutter.RecursiveMethod, FunctionUtil.constant((Object)"Recursive call"), null, GutterIconRenderer.Alignment.RIGHT);
        }
    }
}

