/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.dialects.mysql.dataFlow.MysqlErrorSpecHelper;
import com.intellij.sql.dialects.mysql.psi.MysqlDelimiterStatementImpl;
import com.intellij.sql.dialects.mysql.psi.MysqlShowStatementImpl;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractFunctionHelper;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlDialectBase
extends SqlLanguageDialectEx {
    public MysqlDialectBase(String id) {
        super(id);
    }

    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, "Geometry", "geometry", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "JSON", "json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Point", "point", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Curve", "curve", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "LineString", "linestring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Line", "line", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "LinearRing", "linearring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Surface", "surface", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "Polygon", "polygon", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "GeometryCollection", "geometrycollection", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiPoint", "multipoint", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiCurve", "multicurve", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiLineString", "Multilinestring", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiSurface", "multisurface", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, "MultiPolygon", "multipolygon", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MysqlDialectBase.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        MysqlShowStatementImpl showStatement;
        Pair<IElementType, IElementType> type;
        ReservedEntity.Typed[] cols2;
        if (element2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            MysqlDialectBase.$$$reportNull$$$0(2);
        }
        if (!MysqlDialectBase.processReservedEntitiesWithTypeDual(name2, element2, resolve, processor)) {
            return false;
        }
        SqlStatement stmt = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class);
        if (stmt instanceof MysqlShowStatementImpl && (cols2 = LazyData.RE_SHOW_COLUMNS_BY_TYPE.get(type = (showStatement = (MysqlShowStatementImpl)stmt).getShowType())) != null) {
            for (ReservedEntity.Typed col : cols2) {
                if (MysqlDialectBase.processReservedEntitiesWithTypeSimple(col, col.type, name2, element2, resolve, processor, true, false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name2, element2, resolve, processor);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = MysqlDialectBase.getDefaultNamespace(dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                MysqlDialectBase.$$$reportNull$$$0(3);
            }
            return treePattern;
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, false);
        if (treePattern == null) {
            MysqlDialectBase.$$$reportNull$$$0(4);
        }
        return treePattern;
    }

    @Override
    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column2) {
        if (column2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(5);
        }
        if (super.isAutoIncrementColumn(column2)) {
            return true;
        }
        String type = column2.getDataType().getSpecification();
        return StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"serial");
    }

    @Override
    @NotNull
    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            MysqlDialectBase.$$$reportNull$$$0(6);
        }
        String result2 = null;
        if (offset > 0) {
            for (MysqlDelimiterStatementImpl delimiter : SqlImplUtil.iterateStatementsBackward((PsiFile)file, offset).filter(MysqlDelimiterStatementImpl.class)) {
                if (delimiter.getDelimiter() == null) continue;
                result2 = delimiter.getDelimiter();
                break;
            }
        }
        if (result2 == null) {
            String string = super.getDelimiterAt(file, offset);
            if (string == null) {
                MysqlDialectBase.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            MysqlDialectBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new MysqlExtractVariableHelper();
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return MysqlExtractFunctionHelper.INSTANCE;
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(9);
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element2) {
        if (element2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(10);
        }
        return element2 == SqlCompositeElementTypes.SQL_STRING_LITERAL || element2 == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element2 == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            MysqlDialectBase.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            MysqlDialectBase.$$$reportNull$$$0(12);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "decimal";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "tinyint";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "binary";
            }
            case ARRAY: {
                return "binary";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(13);
        }
        name2 = super.getNormalizedTypeName(name2);
        name2 = StringUtil.trimStart((String)name2, (String)"national ");
        name2 = StringUtil.trimEnd((String)name2, (String)" zerofill");
        name2 = StringUtil.trimEnd((String)name2, (String)" signed");
        if ((name2 = StringUtil.trimEnd((String)name2, (String)" unsigned")).equals("nchar varying")) {
            if ("varchar" == null) {
                MysqlDialectBase.$$$reportNull$$$0(14);
            }
            return "varchar";
        }
        if (name2.equals("nvarchar")) {
            if ("varchar" == null) {
                MysqlDialectBase.$$$reportNull$$$0(15);
            }
            return "varchar";
        }
        if (name2.equals("nchar")) {
            if ("char" == null) {
                MysqlDialectBase.$$$reportNull$$$0(16);
            }
            return "char";
        }
        if (name2.equals("character varying")) {
            if ("varchar" == null) {
                MysqlDialectBase.$$$reportNull$$$0(17);
            }
            return "varchar";
        }
        if (name2.equals("char varying")) {
            if ("varchar" == null) {
                MysqlDialectBase.$$$reportNull$$$0(18);
            }
            return "varchar";
        }
        if (name2.equals("character")) {
            if ("char" == null) {
                MysqlDialectBase.$$$reportNull$$$0(19);
            }
            return "char";
        }
        if (name2.equals("long")) {
            if ("mediumtext" == null) {
                MysqlDialectBase.$$$reportNull$$$0(20);
            }
            return "mediumtext";
        }
        if (name2.equals("integer")) {
            if ("int" == null) {
                MysqlDialectBase.$$$reportNull$$$0(21);
            }
            return "int";
        }
        if (name2.equals("boolean")) {
            if ("tinyint" == null) {
                MysqlDialectBase.$$$reportNull$$$0(22);
            }
            return "tinyint";
        }
        if (name2.equals("bool")) {
            if ("tinyint" == null) {
                MysqlDialectBase.$$$reportNull$$$0(23);
            }
            return "tinyint";
        }
        if (name2.equals("dec")) {
            if ("decimal" == null) {
                MysqlDialectBase.$$$reportNull$$$0(24);
            }
            return "decimal";
        }
        if (name2.equals("numeric")) {
            if ("decimal" == null) {
                MysqlDialectBase.$$$reportNull$$$0(25);
            }
            return "decimal";
        }
        if (name2.equals("fixed")) {
            if ("decimal" == null) {
                MysqlDialectBase.$$$reportNull$$$0(26);
            }
            return "decimal";
        }
        if (name2.equals("double precision")) {
            if ("double" == null) {
                MysqlDialectBase.$$$reportNull$$$0(27);
            }
            return "double";
        }
        if (name2.equals("real")) {
            if ("double" == null) {
                MysqlDialectBase.$$$reportNull$$$0(28);
            }
            return "double";
        }
        String string = name2;
        if (string == null) {
            MysqlDialectBase.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiReference ref) {
        if (processor == null) {
            MysqlDialectBase.$$$reportNull$$$0(30);
        }
        if (state2 == null) {
            MysqlDialectBase.$$$reportNull$$$0(31);
        }
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(32);
        }
        if (processor.isExpected(MysqlElementTypes.Extra.USER_VARIABLE)) {
            SqlFileImpl sqlFile;
            PsiFile file = ref.getElement().getContainingFile();
            if (file != null) {
                file = (PsiFile)ObjectUtils.chooseNotNull((Object)file.getOriginalFile(), (Object)file);
            }
            if ((sqlFile = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)file, SqlFileImpl.class))) != null) {
                for (SqlReferenceExpression expression : MysqlDialectBase.getGlobalVariables(sqlFile)) {
                    if (processor.execute((PsiElement)expression, state2)) continue;
                    return false;
                }
            }
            if (processor.referenceName != null && !processor.isExpected(SqlDbElementType.ANY)) {
                return false;
            }
        }
        return super.processUnqualifiedResolve(processor, state2, ref);
    }

    @Override
    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        MysqlErrorSpecHelper mysqlErrorSpecHelper = MysqlErrorSpecHelper.INSTANCE;
        if (mysqlErrorSpecHelper == null) {
            MysqlDialectBase.$$$reportNull$$$0(33);
        }
        return mysqlErrorSpecHelper;
    }

    @NotNull
    public static List<SqlReferenceExpression> getGlobalVariables(@NotNull SqlFile file) {
        if (file == null) {
            MysqlDialectBase.$$$reportNull$$$0(34);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(MysqlDialectBase.calcGlobalVariables((SqlFileImpl)file), (Object[])new Object[]{file}));
        if (list == null) {
            MysqlDialectBase.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    private static List<SqlReferenceExpression> calcGlobalVariables(SqlFileImpl file) {
        SqlLanguageDialectEx language = file.getSqlLanguage();
        if (!language.getDbms().isMysql() || file.getStub() != null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                MysqlDialectBase.$$$reportNull$$$0(36);
            }
            return list;
        }
        HashMap<String, Pair> gradedVariables = new HashMap<String, Pair>();
        for (SqlReferenceExpression ref : SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlReferenceExpression.class)) {
            String prefix;
            if (ref.getReferenceElementType() != MysqlElementTypes.Extra.MYSQL_USER_VARIABLE_REFERENCE) continue;
            SqlIdentifier identifier = ref.getIdentifier();
            String string = prefix = identifier == null ? null : identifier.getNamePrefix();
            if (!language.isVariablePrefix(prefix)) continue;
            int grade = MysqlDialectBase.getVariableReferenceGrade(ref);
            String name2 = ref.getName();
            Pair old = (Pair)gradedVariables.get(name2);
            if (old != null && grade >= (Integer)old.second) continue;
            gradedVariables.put(name2, Pair.create((Object)ref, (Object)grade));
        }
        List list = ContainerUtil.map2List(gradedVariables.values(), val -> (SqlReferenceExpression)val.first);
        if (list == null) {
            MysqlDialectBase.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static int getVariableReferenceGrade(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            MysqlDialectBase.$$$reportNull$$$0(38);
        }
        int grade = 0;
        boolean insideRoutine = PsiTreeUtil.getParentOfType((PsiElement)ref, SqlCreateProcedureStatement.class) != null;
        SqlSetAssignment assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlSetAssignment.class);
        if (assignment != null && assignment.getLValue() == ref) {
            return insideRoutine ? grade + 1 : grade;
        }
        grade += 2;
        SqlBinaryExpression expr = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlBinaryExpression.class);
        if (expr != null && expr.getLOperand() == ref && (expr.getOpSign() == SqlCommonTokens.SQL_OP_ASSIGN || expr.getOpSign() == SqlCommonTokens.SQL_OP_EQ)) {
            return insideRoutine ? grade + 1 : grade;
        }
        return insideRoutine ? grade + 1 : (grade += 2);
    }

    static /* synthetic */ SqlType access$200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$300(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$600(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$700(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$800(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$900(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$1000(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$1100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$1200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$1300(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$1400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$1500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$1600(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$1700(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$1800(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$1900(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$2000(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$2100(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$2200(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$2300(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$2400(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$2500(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$2600(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$2700(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$2800(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$2900(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$3000(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$3100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$3200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$3300(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$3400(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$3500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$3600(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$3700(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$3800(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$3900(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$4000(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$4100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$4200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$4300(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$4400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$4500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$4600(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$4700(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$4800(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$4900(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$5000(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$5100(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$5200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$5300(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$5400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$5500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$5600(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$5700(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$5800(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$5900(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$6000(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$6100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$6200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$6300(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$6400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$6500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$6600(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$6700(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$6800(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$6900(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7000(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7300(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7600(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7700(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7800(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$7900(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$8000(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$8100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$8200(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$8300(MysqlDialectBase x0) {
        return x0.dateTimeType();
    }

    static /* synthetic */ SqlType access$8400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$8500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$8600(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$8700(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$8800(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$8900(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9000(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9300(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9600(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9700(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9800(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$9900(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10000(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10300(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10400(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10500(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10600(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$10700(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10800(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$10900(MysqlDialectBase x0) {
        return x0.integerType();
    }

    static /* synthetic */ SqlType access$11000(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$11100(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$11200(MysqlDialectBase x0) {
        return x0.stringType();
    }

    static /* synthetic */ SqlType access$11300(MysqlDialectBase x0) {
        return x0.integerType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/MysqlDialectBase";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/MysqlDialectBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelimiterAt";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalVariables";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "calcGlobalVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalVariables";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getVariableReferenceGrade";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final MysqlDialectBase INSTANCE = MysqlDialect.INSTANCE;
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.MYSQL_DELIMITER_TOKEN})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_GT, SqlCommonTokens.SQL_OP_CONCAT, SqlCommonKeywords.SQL_AND, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_OR, SqlCommonKeywords.SQL_IS, SqlCommonKeywords.SQL_LIKE, SqlCommonKeywords.SQL_COLLATE, SqlCommonKeywords.SQL_IN, SqlCommonTokens.SQL_OP_LOGICAL_AND, SqlCommonTokens.SQL_OP_BITWISE_AND, SqlCommonTokens.SQL_OP_INVERT, SqlCommonTokens.SQL_OP_BITWISE_OR, SqlCommonTokens.SQL_OP_LOGICAL_OR, SqlCommonTokens.SQL_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_NULLSAFE_EQ, SqlCommonTokens.SQL_OP_LEFT_SHIFT, SqlCommonTokens.SQL_OP_RIGHT_SHIFT, SqlCommonTokens.SQL_OP_MODULO, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_NOT2, SqlCommonTokens.SQL_OP_ASSIGN, MysqlReservedKeywords.MYSQL_REGEXP, MysqlReservedKeywords.MYSQL_RLIKE, MysqlOptionalKeywords.MYSQL_SOUNDS, MysqlReservedKeywords.MYSQL_DIV, MysqlReservedKeywords.MYSQL_MOD, MysqlReservedKeywords.MYSQL_XOR, MysqlReservedKeywords.MYSQL_BINARY});
        static final Map<Pair<IElementType, IElementType>, ReservedEntity.Typed[]> RE_SHOW_COLUMNS_BY_TYPE = ContainerUtil.immutableMapBuilder().put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_CHARACTER, null), (Object)LazyData.cols(LazyData.col("Charset", MysqlDialectBase.access$11000(INSTANCE)), LazyData.col("Description", MysqlDialectBase.access$11100(INSTANCE)), LazyData.col("Default collation", MysqlDialectBase.access$11200(INSTANCE)), LazyData.col("Maxlen", MysqlDialectBase.access$11300(INSTANCE)))).put(LazyData.type((IElementType)SqlCommonKeywords.SQL_COLLATION, null), (Object)LazyData.cols(LazyData.col("Collation", MysqlDialectBase.access$10400(INSTANCE)), LazyData.col("Charset", MysqlDialectBase.access$10500(INSTANCE)), LazyData.col("Id", MysqlDialectBase.access$10600(INSTANCE)), LazyData.col("Default", MysqlDialectBase.access$10700(INSTANCE)), LazyData.col("Compiled", MysqlDialectBase.access$10800(INSTANCE)), LazyData.col("Sortlen", MysqlDialectBase.access$10900(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_COLUMNS, null), (Object)LazyData.cols(LazyData.col("Field", MysqlDialectBase.access$9900(INSTANCE)), LazyData.col("Type", MysqlDialectBase.access$10000(INSTANCE)), LazyData.col("Null", MysqlDialectBase.access$10100(INSTANCE)), LazyData.col("Default", MysqlDialectBase.access$10200(INSTANCE)), LazyData.col("Extra", MysqlDialectBase.access$10300(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_FULL, MysqlTypes.MYSQL_COLUMNS), (Object)LazyData.cols(LazyData.col("Field", MysqlDialectBase.access$9000(INSTANCE)), LazyData.col("Type", MysqlDialectBase.access$9100(INSTANCE)), LazyData.col("Collation", MysqlDialectBase.access$9200(INSTANCE)), LazyData.col("Null", MysqlDialectBase.access$9300(INSTANCE)), LazyData.col("Key", MysqlDialectBase.access$9400(INSTANCE)), LazyData.col("Default", MysqlDialectBase.access$9500(INSTANCE)), LazyData.col("Extra", MysqlDialectBase.access$9600(INSTANCE)), LazyData.col("Privileges", MysqlDialectBase.access$9700(INSTANCE)), LazyData.col("Comment", MysqlDialectBase.access$9800(INSTANCE)))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_DATABASES, null), (Object)LazyData.cols(LazyData.col("database", MysqlDialectBase.access$8900(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_EVENTS, null), (Object)LazyData.cols(LazyData.col("Db", MysqlDialectBase.access$7400(INSTANCE)), LazyData.col("Name", MysqlDialectBase.access$7500(INSTANCE)), LazyData.col("Definer", MysqlDialectBase.access$7600(INSTANCE)), LazyData.col("Time Zone", MysqlDialectBase.access$7700(INSTANCE)), LazyData.col("Type", MysqlDialectBase.access$7800(INSTANCE)), LazyData.col("Execute At", MysqlDialectBase.access$7900(INSTANCE)), LazyData.col("Interval Value", MysqlDialectBase.access$8000(INSTANCE)), LazyData.col("Interval Field", MysqlDialectBase.access$8100(INSTANCE)), LazyData.col("Starts", MysqlDialectBase.access$8200(INSTANCE)), LazyData.col("Ends", MysqlDialectBase.access$8300(INSTANCE)), LazyData.col("Status", MysqlDialectBase.access$8400(INSTANCE)), LazyData.col("Originator", MysqlDialectBase.access$8500(INSTANCE)), LazyData.col("character_set_client", MysqlDialectBase.access$8600(INSTANCE)), LazyData.col("collation_connection", MysqlDialectBase.access$8700(INSTANCE)), LazyData.col("Database Collation", MysqlDialectBase.access$8800(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_FUNCTION, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", MysqlDialectBase.access$6300(INSTANCE)), LazyData.col("Name", MysqlDialectBase.access$6400(INSTANCE)), LazyData.col("Type", MysqlDialectBase.access$6500(INSTANCE)), LazyData.col("Definer", MysqlDialectBase.access$6600(INSTANCE)), LazyData.col("Modified", MysqlDialectBase.access$6700(INSTANCE)), LazyData.col("Created", MysqlDialectBase.access$6800(INSTANCE)), LazyData.col("Security_type", MysqlDialectBase.access$6900(INSTANCE)), LazyData.col("Comment", MysqlDialectBase.access$7000(INSTANCE)), LazyData.col("character_set_client", MysqlDialectBase.access$7100(INSTANCE)), LazyData.col("collation_connection", MysqlDialectBase.access$7200(INSTANCE)), LazyData.col("Database Collation", MysqlDialectBase.access$7300(INSTANCE)))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_INDEX, null), (Object)LazyData.cols(LazyData.col("Table", MysqlDialectBase.access$5000(INSTANCE)), LazyData.col("Non_unique", MysqlDialectBase.access$5100(INSTANCE)), LazyData.col("Key_name", MysqlDialectBase.access$5200(INSTANCE)), LazyData.col("Seq_in_index", MysqlDialectBase.access$5300(INSTANCE)), LazyData.col("Column_name", MysqlDialectBase.access$5400(INSTANCE)), LazyData.col("Collation", MysqlDialectBase.access$5500(INSTANCE)), LazyData.col("Cardinality", MysqlDialectBase.access$5600(INSTANCE)), LazyData.col("Sub_part", MysqlDialectBase.access$5700(INSTANCE)), LazyData.col("Packed", MysqlDialectBase.access$5800(INSTANCE)), LazyData.col("Null", MysqlDialectBase.access$5900(INSTANCE)), LazyData.col("Index_type", MysqlDialectBase.access$6000(INSTANCE)), LazyData.col("Comment", MysqlDialectBase.access$6100(INSTANCE)), LazyData.col("Index_comment", MysqlDialectBase.access$6200(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_OPEN, MysqlTypes.MYSQL_TABLES), (Object)LazyData.cols(LazyData.col("Database", MysqlDialectBase.access$4600(INSTANCE)), LazyData.col("Table", MysqlDialectBase.access$4700(INSTANCE)), LazyData.col("In_use", MysqlDialectBase.access$4800(INSTANCE)), LazyData.col("Name_locked", MysqlDialectBase.access$4900(INSTANCE)))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_PROCEDURE, MysqlTypes.MYSQL_STATUS), (Object)LazyData.cols(LazyData.col("Db", MysqlDialectBase.access$3500(INSTANCE)), LazyData.col("Name", MysqlDialectBase.access$3600(INSTANCE)), LazyData.col("Type", MysqlDialectBase.access$3700(INSTANCE)), LazyData.col("Definer", MysqlDialectBase.access$3800(INSTANCE)), LazyData.col("Modified", MysqlDialectBase.access$3900(INSTANCE)), LazyData.col("Created", MysqlDialectBase.access$4000(INSTANCE)), LazyData.col("Security_type", MysqlDialectBase.access$4100(INSTANCE)), LazyData.col("Comment", MysqlDialectBase.access$4200(INSTANCE)), LazyData.col("character_set_client", MysqlDialectBase.access$4300(INSTANCE)), LazyData.col("collation_connection", MysqlDialectBase.access$4400(INSTANCE)), LazyData.col("Database Collation", MysqlDialectBase.access$4500(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_STATUS, null), (Object)LazyData.cols(LazyData.col("Variable_name", MysqlDialectBase.access$3300(INSTANCE)), LazyData.col("Value", MysqlDialectBase.access$3400(INSTANCE)))).put(LazyData.type((IElementType)MysqlReservedKeywords.MYSQL_TABLE, null), (Object)LazyData.cols(LazyData.col("Name", MysqlDialectBase.access$1500(INSTANCE)), LazyData.col("Engine", MysqlDialectBase.access$1600(INSTANCE)), LazyData.col("Version", MysqlDialectBase.access$1700(INSTANCE)), LazyData.col("Row_format", MysqlDialectBase.access$1800(INSTANCE)), LazyData.col("Rows", MysqlDialectBase.access$1900(INSTANCE)), LazyData.col("Avg_row_length", MysqlDialectBase.access$2000(INSTANCE)), LazyData.col("Data_length", MysqlDialectBase.access$2100(INSTANCE)), LazyData.col("Max_data_length", MysqlDialectBase.access$2200(INSTANCE)), LazyData.col("Index_length", MysqlDialectBase.access$2300(INSTANCE)), LazyData.col("Data_free", MysqlDialectBase.access$2400(INSTANCE)), LazyData.col("Auto_increment", MysqlDialectBase.access$2500(INSTANCE)), LazyData.col("Create_time", MysqlDialectBase.access$2600(INSTANCE)), LazyData.col("Update_time", MysqlDialectBase.access$2700(INSTANCE)), LazyData.col("Check_time", MysqlDialectBase.access$2800(INSTANCE)), LazyData.col("Collation", MysqlDialectBase.access$2900(INSTANCE)), LazyData.col("Checksum", MysqlDialectBase.access$3000(INSTANCE)), LazyData.col("Create_options", MysqlDialectBase.access$3100(INSTANCE)), LazyData.col("Comment", MysqlDialectBase.access$3200(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_TRIGGERS, null), (Object)LazyData.cols(LazyData.col("Trigger", MysqlDialectBase.access$400(INSTANCE)), LazyData.col("Event", MysqlDialectBase.access$500(INSTANCE)), LazyData.col("Table", MysqlDialectBase.access$600(INSTANCE)), LazyData.col("Statement", MysqlDialectBase.access$700(INSTANCE)), LazyData.col("Timing", MysqlDialectBase.access$800(INSTANCE)), LazyData.col("Created", MysqlDialectBase.access$900(INSTANCE)), LazyData.col("sql_mode", MysqlDialectBase.access$1000(INSTANCE)), LazyData.col("Definer", MysqlDialectBase.access$1100(INSTANCE)), LazyData.col("character_set_client", MysqlDialectBase.access$1200(INSTANCE)), LazyData.col("collation_connection", MysqlDialectBase.access$1300(INSTANCE)), LazyData.col("Database Collation", MysqlDialectBase.access$1400(INSTANCE)))).put(LazyData.type(MysqlTypes.MYSQL_VARIABLES, null), (Object)LazyData.cols(LazyData.col("Variable_name", MysqlDialectBase.access$200(INSTANCE)), LazyData.col("Value", MysqlDialectBase.access$300(INSTANCE)))).build();
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{SqlCommonKeywords.SQL_LOOP}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{SqlCommonKeywords.SQL_IF}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlTypes.MYSQL_DO, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end while", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_WHILE}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT, SqlCompositeElementTypes.SQL_REPEAT_LOOP_STATEMENT}, "", "until  end repeat", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlCommonKeywords.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT}).opt(new IElementType[]{SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlCommonTokens.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build())));
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Collections.singletonList(ObjectKind.TRIGGER);

        LazyData() {
        }

        private static ReservedEntity.Typed[] cols(ReservedEntity.Typed ... entities) {
            return entities;
        }

        private static ReservedEntity.Typed col(@NotNull String name2, @NotNull SqlType type) {
            if (name2 == null) {
                LazyData.$$$reportNull$$$0(0);
            }
            if (type == null) {
                LazyData.$$$reportNull$$$0(1);
            }
            return new ReservedEntity.Typed(name2, ObjectKind.COLUMN, type);
        }

        private static Pair<IElementType, IElementType> type(IElementType f, IElementType s) {
            return Pair.create((Object)f, (Object)s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/dialects/mysql/MysqlDialectBase$LazyData";
            objectArray[2] = "col";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

