/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SidePanelItem<Represented, RepConfigurable extends Configurable> {
    private static final String ELEMENT = "element";
    private Place myPlace;
    private final Represented myRepresented;
    private RepConfigurable myConfigurable;
    private JComponent myComponent;
    private JComponent myResetComponent;
    private Boolean myModifiedCache;
    protected DatabaseConfigEditorImpl myEditor;
    private DataSourceProblem myDataSourceProblem;

    SidePanelItem(@NotNull DatabaseConfigEditorImpl editor, @NotNull Represented represented) {
        if (editor == null) {
            SidePanelItem.$$$reportNull$$$0(0);
        }
        if (represented == null) {
            SidePanelItem.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myRepresented = represented;
    }

    private static Place createPlaceFor(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            SidePanelItem.$$$reportNull$$$0(2);
        }
        return SidePanelItem.setItem(new Place(), item);
    }

    @NotNull
    public static Place setItem(@NotNull Place place, @Nullable SidePanelItem<?, ?> item) {
        if (place == null) {
            SidePanelItem.$$$reportNull$$$0(3);
        }
        Place place2 = place.putPath(ELEMENT, item);
        if (place2 == null) {
            SidePanelItem.$$$reportNull$$$0(4);
        }
        return place2;
    }

    @Nullable
    public static SidePanelItem<?, ?> getItem(@Nullable Place place) {
        return place == null ? null : (SidePanelItem)place.getPath(ELEMENT);
    }

    @Nullable
    public static <R> R getObject(@Nullable SidePanelItem<R, ?> item) {
        return item == null ? null : (R)item.getObject();
    }

    @NotNull
    public JComponent getResetComponent() {
        if (this.myResetComponent == null) {
            this.myResetComponent = new SwingActionLink((Action)new AbstractAction("Reset"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SidePanelItem.this.reset();
                }
            });
        }
        JComponent jComponent = this.myResetComponent;
        if (jComponent == null) {
            SidePanelItem.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    protected void preReset() {
    }

    protected void reset() {
        if (this.getConfigurable() != null) {
            this.preReset();
            this.getConfigurable().reset();
        }
        this.resetModifiedCache();
    }

    protected boolean isResetEnabled() {
        return this.isModified();
    }

    public void updateResetComponent() {
        if (this.myResetComponent != null) {
            this.myResetComponent.setVisible(this.isResetEnabled());
        }
    }

    @Nullable
    public Place getPlace() {
        return this.myPlace;
    }

    @NotNull
    public Place createPlace() {
        if (this.myPlace == null) {
            this.myPlace = SidePanelItem.createPlaceFor(this);
        }
        Place place = this.myPlace;
        if (place == null) {
            SidePanelItem.$$$reportNull$$$0(6);
        }
        return place;
    }

    @NotNull
    public Represented getObject() {
        Represented Represented = this.myRepresented;
        if (Represented == null) {
            SidePanelItem.$$$reportNull$$$0(7);
        }
        return Represented;
    }

    @Nullable
    public RepConfigurable getConfigurable() {
        return this.myConfigurable;
    }

    @Nullable
    public JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public RepConfigurable createConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = this.createConfigurableImpl();
            this.myComponent = this.myConfigurable.createComponent();
            if (this.myConfigurable instanceof AbstractDatabaseConfigurable) {
                ((AbstractDatabaseConfigurable)this.myConfigurable).init();
            } else {
                this.myConfigurable.reset();
            }
            this.updateResetComponent();
        }
        RepConfigurable RepConfigurable = this.myConfigurable;
        if (RepConfigurable == null) {
            SidePanelItem.$$$reportNull$$$0(8);
        }
        return RepConfigurable;
    }

    @NotNull
    public abstract RepConfigurable createConfigurableImpl();

    public void removeConfigurable() {
        if (this.myConfigurable == null) {
            return;
        }
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
        this.myComponent = null;
    }

    public void resetModifiedCache() {
        this.myModifiedCache = null;
        this.updateResetComponent();
    }

    public boolean isModified() {
        if (this.myConfigurable == null) {
            return false;
        }
        if (this.myModifiedCache == null) {
            this.myModifiedCache = this.myConfigurable.isModified();
        }
        return this.myModifiedCache;
    }

    public abstract boolean accept(@NotNull ItemsVisitor var1);

    public abstract String getName();

    public DataSourceProblem getDataSourceProblem() {
        return this.myDataSourceProblem;
    }

    public void setDataSourceProblem(DataSourceProblem dataSourceProblem) {
        this.myDataSourceProblem = dataSourceProblem;
    }

    public abstract void apply() throws ConfigurationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "represented";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/SidePanelItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setItem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResetComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setItem";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ItemsVisitor
    implements Processor<SidePanelItem<?, ?>> {
        ItemsVisitor() {
        }

        boolean visit(DataSourceItem dataSourceItem) {
            return true;
        }

        boolean visit(DriverItem driverItem) {
            return true;
        }

        boolean visit(ErrorsItem errorItem) {
            return true;
        }

        public boolean process(SidePanelItem item) {
            return item.accept(this);
        }
    }

    static class ErrorsItem
    extends SidePanelItem<DataSourceErrorsConfigurable, DataSourceErrorsConfigurable> {
        ErrorsItem(@NotNull DatabaseConfigEditorImpl editor, @NotNull DataSourceErrorsConfigurable source) {
            if (editor == null) {
                ErrorsItem.$$$reportNull$$$0(0);
            }
            if (source == null) {
                ErrorsItem.$$$reportNull$$$0(1);
            }
            super(editor, source);
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor2) {
            if (visitor2 == null) {
                ErrorsItem.$$$reportNull$$$0(2);
            }
            return visitor2.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? "Problems" : ((DataSourceErrorsConfigurable)this.getConfigurable()).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
        }

        @Override
        @NotNull
        public DataSourceErrorsConfigurable createConfigurableImpl() {
            DataSourceErrorsConfigurable dataSourceErrorsConfigurable = (DataSourceErrorsConfigurable)this.getObject();
            if (dataSourceErrorsConfigurable == null) {
                ErrorsItem.$$$reportNull$$$0(3);
            }
            return dataSourceErrorsConfigurable;
        }

        @Override
        public void removeConfigurable() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/SidePanelItem$ErrorsItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem$ErrorsItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfigurableImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DriverItem
    extends SidePanelItem<DatabaseDriver, DatabaseDriverConfigurable>
    implements DataSourceProblemsProvider {
        DriverItem(@NotNull DatabaseConfigEditorImpl editor, @NotNull DatabaseDriver source) {
            if (editor == null) {
                DriverItem.$$$reportNull$$$0(0);
            }
            if (source == null) {
                DriverItem.$$$reportNull$$$0(1);
            }
            super(editor, source);
        }

        @Override
        protected void reset() {
            super.reset();
            if (this.getConfigurable() != null) {
                this.myEditor.updateDriverDependants(((DatabaseDriverConfigurable)this.getConfigurable()).getTempDriver());
            }
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor2) {
            if (visitor2 == null) {
                DriverItem.$$$reportNull$$$0(2);
            }
            return visitor2.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? ((DatabaseDriver)this.getObject()).getName() : ((DatabaseDriverConfigurable)this.getConfigurable()).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
            if (this.getConfigurable() != null) {
                ((DatabaseDriverConfigurable)this.getConfigurable()).apply();
            } else if (this.isNew()) {
                DatabaseDriverManager.getInstance().updateDriver((DatabaseDriver)this.getObject());
            }
        }

        private boolean isNew() {
            return !DatabaseDriverManager.getInstance().getDrivers().contains(this.getObject());
        }

        @Override
        @NotNull
        public DatabaseDriverConfigurable createConfigurableImpl() {
            DatabaseDriverConfigurable databaseDriverConfigurable = new DatabaseDriverConfigurable(this.myEditor.getSettings().facade.getProject(), (DatabaseDriverImpl)this.getObject(), this.myEditor);
            if (databaseDriverConfigurable == null) {
                DriverItem.$$$reportNull$$$0(3);
            }
            return databaseDriverConfigurable;
        }

        @Override
        public Set<DataSourceProblem> getErrors() {
            DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)this.getConfigurable();
            return DatabaseConfigValidator.getProblems(configurable == null ? this.getObject() : configurable.getTempDriver(), this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/SidePanelItem$DriverItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem$DriverItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfigurableImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DataSourceItem
    extends SidePanelItem<DbDataSourceImpl, AbstractDataSourceConfigurable<?, ?>>
    implements DataSourceProblemsProvider {
        final DataSourceManager<DasDataSource> dbManager;

        DataSourceItem(@NotNull DatabaseConfigEditorImpl editor, @NotNull DbDataSourceImpl dataSource) {
            if (editor == null) {
                DataSourceItem.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                DataSourceItem.$$$reportNull$$$0(1);
            }
            super(editor, dataSource);
            this.dbManager = editor.getSettings().facade.getDataSourceManager((DbDataSource)dataSource);
        }

        @Override
        protected void preReset() {
            LocalDataSource localDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)((DbDataSourceImpl)((Object)this.getObject())).getDelegate(), LocalDataSource.class);
            if (localDataSource != null) {
                this.myEditor.resurrectDriver(localDataSource.getDatabaseDriver());
            }
        }

        @Nullable
        public LocalDataSource extractActualLocalDataSource() {
            LocalDataSource actual = this.getConfigurable() == null ? null : (LocalDataSource)ObjectUtils.tryCast(((AbstractDataSourceConfigurable)this.getConfigurable()).getTempDataSource(), LocalDataSource.class);
            return actual == null ? (LocalDataSource)ObjectUtils.tryCast((Object)((DbDataSourceImpl)((Object)this.getObject())).getDelegate(), LocalDataSource.class) : actual;
        }

        @Override
        public boolean accept(@NotNull ItemsVisitor visitor2) {
            if (visitor2 == null) {
                DataSourceItem.$$$reportNull$$$0(2);
            }
            return visitor2.visit(this);
        }

        @Override
        public String getName() {
            return this.getConfigurable() == null ? ((DbDataSourceImpl)((Object)this.getObject())).getName() : ((AbstractDataSourceConfigurable)this.getConfigurable()).getDisplayName();
        }

        @Override
        public void apply() throws ConfigurationException {
            if (this.getConfigurable() != null) {
                ((AbstractDataSourceConfigurable)this.getConfigurable()).apply();
            } else if (!this.dbManager.getDataSources().contains(this.getObject())) {
                this.dbManager.addDataSource((DasDataSource)((DbDataSourceImpl)((Object)this.getObject())).getDelegate());
            }
            ((DbDataSourceImpl)((Object)this.getObject())).clearCaches();
        }

        public boolean isGlobal() {
            DataSourceConfigurable configurable = (DataSourceConfigurable)ObjectUtils.tryCast(this.getConfigurable(), DataSourceConfigurable.class);
            if (configurable != null) {
                return configurable.isGlobal();
            }
            LocalDataSource localDataSource = this.extractActualLocalDataSource();
            return localDataSource != null && localDataSource.isGlobal();
        }

        public boolean isImported() {
            LocalDataSource localDataSource = this.extractActualLocalDataSource();
            return localDataSource != null && localDataSource.isImported();
        }

        @Override
        @NotNull
        public AbstractDataSourceConfigurable<?, ?> createConfigurableImpl() {
            AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)this.dbManager.createDataSourceEditor((DasDataSource)((DbDataSourceImpl)((Object)this.getObject())).getDelegate());
            configurable.setController(this.myEditor);
            AbstractDataSourceConfigurable abstractDataSourceConfigurable = configurable;
            if (abstractDataSourceConfigurable == null) {
                DataSourceItem.$$$reportNull$$$0(3);
            }
            return abstractDataSourceConfigurable;
        }

        @Override
        public Set<DataSourceProblem> getErrors() {
            AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)this.getConfigurable();
            return DatabaseConfigValidator.getProblems(configurable == null ? ((DbDataSourceImpl)((Object)this.getObject())).getDelegate() : configurable.getTempDataSource(), this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/SidePanelItem$DataSourceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/SidePanelItem$DataSourceItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfigurableImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

