/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.actions.FullTextSearchAction;
import com.intellij.database.fulltextsearch.FtsUtilKt;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.fulltextsearch.FullTextSearchOptionsStorage;
import com.intellij.database.fulltextsearch.SearchableTargetsSearchResult;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.ui.FullTextSearchForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.fields.IntegerField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JComponent;
import org.apache.commons.lang.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullTextSearchDialog
extends DialogWrapper {
    private static final int DURING_VALIDATION_CHECK_AT_MOST = 5000;
    private final Project myProject;
    private final FullTextSearchForm myForm;
    private SearchableTargetsSearchResult myHasSearchableTargetsCache;
    private boolean validationStarted;

    public FullTextSearchDialog(@NotNull Project project, @NotNull FullTextSearchOptions options, @NotNull Collection<DbElement> targets2) {
        if (project == null) {
            FullTextSearchDialog.$$$reportNull$$$0(0);
        }
        if (options == null) {
            FullTextSearchDialog.$$$reportNull$$$0(1);
        }
        if (targets2 == null) {
            FullTextSearchDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myHasSearchableTargetsCache = null;
        this.validationStarted = false;
        this.myProject = project;
        this.myForm = new FullTextSearchForm(project);
        this.myForm.apply(options, targets2);
        this.myForm.getSearchScopeCombobox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1 || !FullTextSearchDialog.this.validationStarted) {
                    return;
                }
                FullTextSearchDialog.this.myHasSearchableTargetsCache = FullTextSearchDialog.this.hasSuitableTables();
            }
        });
        this.setTitle("Full-text Search");
        this.init();
    }

    @NotNull
    private SearchableTargetsSearchResult hasSuitableTables() {
        SearchableTargetsSearchResult searchableTargetsSearchResult = FtsUtilKt.tryFindSearchableTargets(this.myForm.getTargets(), 5000, this.myForm.getOptions());
        if (searchableTargetsSearchResult == null) {
            FullTextSearchDialog.$$$reportNull$$$0(3);
        }
        return searchableTargetsSearchResult;
    }

    @NotNull
    protected String getHelpId() {
        if ("Full_text_search_for_databases" == null) {
            FullTextSearchDialog.$$$reportNull$$$0(4);
        }
        return "Full_text_search_for_databases";
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.validationStarted = true;
        FullTextSearchOptions options = this.myForm.getOptions();
        if (options.getText().isEmpty()) {
            return new ValidationInfo("Text should not be empty", (JComponent)this.myForm.getSearchText());
        }
        if (options.getSearchScope() == FullTextSearchOptions.SearchScope.NUMERIC_COLUMNS && !NumberUtils.isNumber((String)options.getText())) {
            String scopeName = StringUtil.toLowerCase((String)FullTextSearchOptions.SearchScope.NUMERIC_COLUMNS.getName());
            return new ValidationInfo(String.format("Field must contain a number because search is performed in %s", scopeName), (JComponent)this.myForm.getSearchText());
        }
        IntegerField limit = this.myForm.getMaximumHitsCount();
        int min = limit.getMinValue();
        int max = limit.getMaxValue();
        if (limit.getValue().compareTo(min) < 0 || limit.getValue().compareTo(max) > 0) {
            return new ValidationInfo(String.format("Number should be in [%d, %d]", min, max), (JComponent)limit);
        }
        if (this.myHasSearchableTargetsCache == null) {
            this.myHasSearchableTargetsCache = this.hasSuitableTables();
        }
        if (this.myHasSearchableTargetsCache == SearchableTargetsSearchResult.NOT_FOUND) {
            return new ValidationInfo("No results found, try another search option", this.myForm.getSearchScopeCombobox());
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myForm.myPanel;
    }

    protected void doOKAction() {
        if (!this.isOKActionEnabled()) {
            return;
        }
        FullTextSearchOptionsStorage.store(this.myForm.getOptions());
        FullTextSearchAction.Companion.search(this.myProject, this.myForm.getOptions(), this.myForm.getTargets(), null);
        super.doOKAction();
    }

    public void doCancelAction() {
        FullTextSearchOptionsStorage.store(this.myForm.getOptions());
        super.doCancelAction();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getSearchText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/FullTextSearchDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/FullTextSearchDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "hasSuitableTables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

