/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicDataSourceManager<T extends DasDataSource>
extends DataSourceManager<T> {
    protected final Project myProject;
    private final Set<T> myDataSources;
    private final DataSourceManager.Listener myPublisher;

    protected BasicDataSourceManager(@NotNull Project project, @NotNull List<T> dataSources2) {
        if (project == null) {
            BasicDataSourceManager.$$$reportNull$$$0(0);
        }
        if (dataSources2 == null) {
            BasicDataSourceManager.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDataSources = Collections.synchronizedSet(new LinkedHashSet<T>(dataSources2));
        this.myPublisher = (DataSourceManager.Listener)this.myProject.getMessageBus().syncPublisher(TOPIC);
    }

    @Nullable
    public abstract DatabaseDialectEx getDatabaseDialect(@NotNull T var1);

    @Nullable
    public abstract SqlLanguageDialect getSqlDialect(@NotNull T var1);

    protected void resetElementMap(@NotNull List<? extends T> sources) {
        if (sources == null) {
            BasicDataSourceManager.$$$reportNull$$$0(2);
        }
        HashSet<T> oldSources = new HashSet<T>(this.myDataSources);
        HashSet<T> newSources = new HashSet<T>(sources);
        for (DasDataSource source : oldSources) {
            if (newSources.contains(source)) continue;
            this.detachDataSource(source);
        }
        for (DasDataSource source : newSources) {
            if (!this.myDataSources.contains(source)) {
                this.attachDataSource(source);
                continue;
            }
            this.updateDataSource(source);
        }
    }

    protected void updateDataSource(T source) {
        this.myPublisher.dataSourceChanged((DataSourceManager)this, source);
    }

    protected void attachDataSource(@NotNull T source) {
        if (source == null) {
            BasicDataSourceManager.$$$reportNull$$$0(3);
        }
        this.myDataSources.add(source);
        this.myPublisher.dataSourceAdded((DataSourceManager)this, source);
    }

    protected void detachDataSource(@NotNull T source) {
        if (source == null) {
            BasicDataSourceManager.$$$reportNull$$$0(4);
        }
        if (this.myDataSources.remove(source)) {
            this.myPublisher.dataSourceRemoved((DataSourceManager)this, source);
        }
    }

    @NotNull
    public List<T> getDataSources() {
        ArrayList<T> arrayList = new ArrayList<T>(this.myDataSources);
        if (arrayList == null) {
            BasicDataSourceManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public boolean containsDataSource(@NotNull T element2) {
        if (element2 == null) {
            BasicDataSourceManager.$$$reportNull$$$0(6);
        }
        return this.myDataSources.contains(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/BasicDataSourceManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/BasicDataSourceManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetElementMap";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "attachDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detachDataSource";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

