/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J>\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/vertica/VertPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "cannotCastToVarchar", "", "", "formatTypes", "Lcom/intellij/database/data/types/LogicalType;", "getFormatTypes", "()Ljava/util/Set;", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "type", "Lcom/intellij/database/data/types/OperandType;", "version", "Lcom/intellij/database/util/Version;", "likePredicate", "likeType", "Lcom/intellij/database/data/types/domain/LikeOpType;", "matchCase", "", "canCastToText", "intellij.database.dialects.vertica"})
public final class VertPredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<LogicalType> formatTypes;
    private final Set<String> cannotCastToVarchar;

    @Override
    @NotNull
    protected Set<LogicalType> getFormatTypes() {
        return this.formatTypes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull OperandType type, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        String string = column2.getDataType().typeName;
        switch (string.hashCode()) {
            case 1231714172: {
                if (!string.equals("geography")) break;
                return null;
            }
            case 1846020210: {
                if (!string.equals("geometry")) break;
                return null;
            }
        }
        PredicatesHelper.PredicateProducer predicateProducer = PredicatesUtilKt.defaultEqualsPredicate(column2, value, type, this.getDbms(), version);
        return predicateProducer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull DasColumn column, @Nullable Object value, @NotNull LikeOpType likeType, boolean matchCase, boolean canCastToText, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)likeType, (String)"likeType");
        if (!(value instanceof String)) {
            return null;
        }
        typeSupportsOperation = PredicatesUtilKt.supportsOperation(OperationKt.LIKE_OPERATION, column, this.getDbms(), version);
        if (!canCastToText || PredicatesUtilKt.supportsOperation(OperationKt.EQUALS_TO_NUMBER_OPERATION, column, this.getDbms(), version)) ** GOTO lbl-1000
        v0 = column.getDataType().typeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"column.dataType.typeName");
        var9_8 = v0;
        var11_9 = this.cannotCastToVarchar;
        var10_10 = false;
        v1 = var9_8;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v2 = v1.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(this as java.lang.String).toLowerCase()");
        var12_12 = v2;
        if (!var11_9.contains(var12_12)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = canCast = false;
        }
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        likeWord = matchCase != false || DbImplUtil.getJdbcHelper(this.getDbms()).supportsIlike() == false ? "LIKE" : "ILIKE";
        v4 = likeType.getDecorator().decorate(StringUtil.notNullize((String)((String)value)), this.getDbms());
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"likeType.decorator.decor\u2026.notNullize(value), dbms)");
        literal = v4;
        return new PredicatesHelper.PredicateProducer(typeSupportsOperation, column, likeWord, literal){
            final /* synthetic */ boolean $typeSupportsOperation;
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                if (!this.$typeSupportsOperation) {
                    builder.keyword("CAST").symbol("(").identifier((DasObject)this.$column).space().keyword("AS").space().type("VARCHAR").symbol(")");
                } else {
                    builder.identifier((DasObject)this.$column);
                }
                builder.space().keyword(this.$likeWord).space().literal(this.$literal);
            }
            {
                this.$typeSupportsOperation = bl;
                this.$column = dasColumn;
                this.$likeWord = string;
                this.$literal = string2;
            }
        };
    }

    public VertPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
        this.formatTypes = SetsKt.setOf((Object[])new LogicalType[]{LogicalType.TIME_WITH_TIMEZONE, LogicalType.TIMESTAMP_WITH_TIMEZONE, LogicalType.TIMESTAMP, LogicalType.TIME, LogicalType.DATE, LogicalType.UUID, LogicalType.BOOLEAN});
        this.cannotCastToVarchar = SetsKt.setOf((Object[])new String[]{"long varbinary", "long varchar", "geometry", "geography"});
    }
}

