/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/sqlite/SqlitePredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "formatTypes", "", "Lcom/intellij/database/data/types/LogicalType;", "getFormatTypes", "()Ljava/util/Set;", "ftsModules", "", "ftsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "version", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.sqlite"})
public final class SqlitePredicatesHelper
extends BasePredicatesHelper {
    private final Set<String> ftsModules;
    @NotNull
    private final Set<LogicalType> formatTypes;

    @Override
    @NotNull
    protected Set<LogicalType> getFormatTypes() {
        return this.formatTypes;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull DasColumn column2, @Nullable Object value, @Nullable Version version) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        if (!(value instanceof String)) {
            return null;
        }
        DasTable dasTable = column2.getTable();
        if (!(dasTable instanceof SqliteVirtualTable)) {
            dasTable = null;
        }
        SqliteVirtualTable sqliteVirtualTable = (SqliteVirtualTable)dasTable;
        if (sqliteVirtualTable == null) {
            return null;
        }
        SqliteVirtualTable table = sqliteVirtualTable;
        Iterable iterable = this.ftsModules;
        String string2 = table.getModule();
        if (string2 != null) {
            String string3 = string2;
            Iterable iterable2 = iterable;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
            String string6 = string5;
            iterable = iterable2;
            string = string6;
        } else {
            string = null;
        }
        if (!CollectionsKt.contains((Iterable)iterable, string)) {
            return null;
        }
        String string7 = DbImplUtil.StringLiteralDecorator.MATCHES.decorate((String)value, Dbms.SQLITE);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"DbImplUtil.StringLiteral\u2026orate(value, Dbms.SQLITE)");
        String literal = string7;
        return new PredicatesHelper.PredicateProducer(column2, literal){
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                builder.identifier((DasObject)this.$column).space().keyword("MATCH").space().plain(this.$literal);
            }
            {
                this.$column = dasColumn;
                this.$literal = string;
            }
        };
    }

    public SqlitePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
        this.ftsModules = SetsKt.setOf((Object[])new String[]{"FTS4", "FTS5"});
        this.formatTypes = SetsKt.emptySet();
    }
}

