/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.util.ThreeState;
import java.sql.ResultSet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseExecutionEnvironmentHelper;", "Lcom/intellij/database/dialects/base/BaseExecutionEnvironmentHelper;", "()V", "getSslState", "Lcom/intellij/util/ThreeState;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "getTimeZoneManager", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "PgBaseTimeZoneManager", "intellij.database.dialects.postgresbase"})
public class PgBaseExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @Nullable
    public ThreeState getSslState(@NotNull DatabaseConnection connection2) {
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        if (Intrinsics.areEqual((Object)connection2.getDbms(), (Object)Dbms.COCKROACH) || !connection2.getVersion().isOrGreater(new int[]{9, 5})) {
            return null;
        }
        ExecutionMode executionMode = StandardExecutionMode.QUERY;
        String string = "select ssl from pg_stat_ssl where pid = pg_backend_pid()";
        SimpleSmartStatement simpleSmartStatement = SmartStatements.Companion.poweredBy(connection2).simple();
        boolean $i$f$first = false;
        ResultsProducer.VoidReadyProcessor voidReadyProcessor = new ResultsProducer.VoidReadyProcessor<Boolean>(){

            public Boolean empty() {
                ResultSet rs = null;
                boolean bl = false;
                return null;
            }

            public Boolean results(@NotNull ResultSet resultSet, int index2) {
                Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
                ResultSet rs = resultSet.next() ? resultSet : null;
                boolean bl = false;
                ResultSet resultSet2 = rs;
                return resultSet2 != null ? Boolean.valueOf(resultSet2.getBoolean(1)) : null;
            }

            public Boolean updateCount(int count2, int index2) {
                ResultSet rs = null;
                boolean bl = false;
                return null;
            }
        };
        Either<Object> isSsl = simpleSmartStatement.execute(string, executionMode, voidReadyProcessor);
        Boolean bl = isSsl.rightOr(null);
        return Intrinsics.areEqual((Object)bl, (Object)true) ? ThreeState.YES : (Intrinsics.areEqual((Object)bl, (Object)false) ? ThreeState.NO : ThreeState.UNSURE);
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        return PgBaseTimeZoneManager.INSTANCE;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseExecutionEnvironmentHelper$PgBaseTimeZoneManager;", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "()V", "canChange", "", "changeTimeZone", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "timeZone", "", "intellij.database.dialects.postgresbase"})
    private static final class PgBaseTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        public static final PgBaseTimeZoneManager INSTANCE;

        @Override
        public boolean canChange() {
            return true;
        }

        @Override
        public void changeTimeZone(@NotNull DatabaseConnection connection2, @NotNull String timeZone) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "set timezone = '%s'";
            Object[] objectArray = new Object[]{timeZone};
            BarrenStatement.QuietBarrenStatement<String> quietBarrenStatement = SmartStatements.Companion.poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).barren().quiet();
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            quietBarrenStatement.execute(string3);
        }

        private PgBaseTimeZoneManager() {
        }

        static {
            PgBaseTimeZoneManager pgBaseTimeZoneManager;
            INSTANCE = pgBaseTimeZoneManager = new PgBaseTimeZoneManager();
        }
    }
}

