/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgSequence;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTableColumn;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLocalTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseUtil;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.PgDataTypeSubKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgModelHelper
extends PgGPlumBaseModelHelper {
    public static final PgModelHelper INSTANCE = new PgModelHelper();

    private PgModelHelper() {
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull BasicElement o) {
        PgRole role;
        if (o == null) {
            PgModelHelper.$$$reportNull$$$0(0);
        }
        if (o instanceof PgDefType) {
            PgDefType pgd = (PgDefType)o;
            switch (pgd.getSubKind()) {
                case ENUM: {
                    return AllIcons.Nodes.Enum;
                }
            }
        } else if (o instanceof PgRole && (role = (PgRole)o).isCanLogin()) {
            return DbPresentation.getIcon(ObjectKind.USER);
        }
        return super.getIcon(o);
    }

    @Override
    @Nullable
    public String nodeTriggerSuffix(@NotNull BasicTrigger o) {
        if (o == null) {
            PgModelHelper.$$$reportNull$$$0(1);
        }
        if (o instanceof PgTrigger) {
            String routineName = PgGPlumBaseUtil.getCallRoutineName((PgTrigger)o);
            return " " + DbPresentation.arrow() + " " + routineName;
        }
        return null;
    }

    @Override
    @Nullable
    public String nodeTableSuffix(@NotNull BasicTable delegate) {
        if (delegate == null) {
            PgModelHelper.$$$reportNull$$$0(2);
        }
        if (delegate instanceof PgTable) {
            PgTable pt = (PgTable)delegate;
            boolean hasAncestors = !pt.isPartition() && !pt.getAncestorIds().isEmpty();
            boolean hasSuccessors = !pt.isPartitioned() && !pt.getSuccessorIds().isEmpty();
            String s = "";
            if (hasAncestors) {
                s = " based on (" + ModelFun.namesAsString(this.getAncestors(pt)) + ')';
            }
            if (hasAncestors && hasSuccessors) {
                s = s + " and";
            }
            if (hasSuccessors) {
                s = s + " the base for {" + ModelFun.namesAsString(this.getSuccessors(pt)) + '}';
            }
            if (hasAncestors || hasSuccessors) {
                return " " + s;
            }
        }
        return null;
    }

    @Override
    public void exportApplyColumn(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
        if (helper == null) {
            PgModelHelper.$$$reportNull$$$0(3);
        }
        if (from == null) {
            PgModelHelper.$$$reportNull$$$0(4);
        }
        if (to == null) {
            PgModelHelper.$$$reportNull$$$0(5);
        }
        if (to instanceof PgLocalTableColumn) {
            PgModelHelper.applyPgColumn(from, (PgLocalTableColumn)to);
        } else {
            super.exportApplyColumn(helper, from, to);
        }
    }

    @Override
    public void exportLightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeColumn to, @NotNull BasicTableColumn from) {
        if (helper == null) {
            PgModelHelper.$$$reportNull$$$0(6);
        }
        if (to == null) {
            PgModelHelper.$$$reportNull$$$0(7);
        }
        if (from == null) {
            PgModelHelper.$$$reportNull$$$0(8);
        }
        if (from instanceof PgLocalTableColumn) {
            PgLocalTableColumn col = (PgLocalTableColumn)from;
            if (col.getSequenceName() != null || col.isIdentityColumn()) {
                to.flags.add(DeColumn.Flag.AUTO_INC);
            }
            helper.export(col.getSequence(), false);
        }
    }

    @Override
    public boolean gridColumnHasDefaultValue(BasicElement column2) {
        if (column2 instanceof PgTableColumn) {
            PgGPlumBaseDefType type = ((PgTableColumn)column2).getDefType();
            return type != null && type.getDefaultExpression() != null;
        }
        return super.gridColumnHasDefaultValue(column2);
    }

    @Override
    public int getJdbcType(BasicTypedElement element2) {
        if (element2 instanceof PgTableColumn) {
            PgDataTypeSubKind kind;
            PgTableColumn modelColumn = (PgTableColumn)element2;
            PgSchema schema = modelColumn.getSchema();
            PgDatabase database = schema == null ? null : schema.getDatabase();
            PgBaseDefType defType = database == null ? null : (PgDefType)ObjectUtils.tryCast((Object)database.findIdentifiedElement(modelColumn.getTypeId()), PgDefType.class);
            PgDataTypeSubKind pgDataTypeSubKind = kind = defType == null ? null : defType.getSubKind();
            if (kind == PgDataTypeSubKind.ENUM) {
                return 12;
            }
        }
        return super.getJdbcType(element2);
    }

    @Override
    public void ddlPreviewProcessCorrespondence(@NotNull Collection<ElementDelta<?>> correspondence, @NotNull ElementDelta<BasicElement> delta) {
        if (correspondence == null) {
            PgModelHelper.$$$reportNull$$$0(9);
        }
        if (delta == null) {
            PgModelHelper.$$$reportNull$$$0(10);
        }
        if (delta.getSourceElement() instanceof PgLocalTableColumn || delta.getTargetElement() instanceof PgLocalTableColumn) {
            PgGPlumBaseSequence s2;
            PgLocalTableColumn c1 = (PgLocalTableColumn)delta.getSourceElement();
            PgLocalTableColumn c2 = (PgLocalTableColumn)delta.getTargetElement();
            PgGPlumBaseSequence s1 = c1 == null ? null : c1.getSequence();
            PgGPlumBaseSequence pgGPlumBaseSequence = s2 = c2 == null ? null : c2.getSequence();
            if (s1 != null && !c1.isIdentityColumn() || s2 != null && !c2.isIdentityColumn()) {
                correspondence.add(ElementDelta.create(s1, s2));
            }
        }
    }

    @Override
    public void docAppendInfo(@NotNull BasicElement delegate, @NotNull StringBuilder sb) {
        if (delegate == null) {
            PgModelHelper.$$$reportNull$$$0(11);
        }
        if (sb == null) {
            PgModelHelper.$$$reportNull$$$0(12);
        }
        if (delegate instanceof PgTable) {
            PgTable pgTable = (PgTable)delegate;
            if (!pgTable.getAncestorIds().isEmpty()) {
                List ancestors = ContainerUtil.mapNotNull(this.getAncestors(pgTable), t -> t instanceof PgTable ? (PgTable)t : null);
                PgModelHelper.appendPgInheritanceTables(sb, ancestors, "Inherits ");
            }
            if (!pgTable.getSuccessorIds().isEmpty()) {
                Set<PgGPlumBaseTable> successors2 = this.getSuccessors(pgTable);
                PgModelHelper.appendPgInheritanceTables(sb, successors2, "Base for ");
            }
        }
    }

    @Override
    @Nullable
    public DataType getDataTypeForGridCompletion(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        DataType dataType;
        if (grid == null) {
            PgModelHelper.$$$reportNull$$$0(13);
        }
        if (column2 == null) {
            PgModelHelper.$$$reportNull$$$0(14);
        }
        if ((dataType = super.getDataTypeForGridCompletion(grid, column2)) == null) {
            return null;
        }
        GridColumn gridColumn = grid.getLayoutColumn(column2);
        if (gridColumn == null) {
            return PgModelHelper.unwrapDataType(dataType, grid);
        }
        Project project = DataGridUtil.getProject(grid);
        return (DataType)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)gridColumn, () -> new CachedValueProvider.Result((Object)PgModelHelper.unwrapDataType(dataType, grid), new Object[]{DbPsiFacade.getInstance((Project)project)}));
    }

    private static DataType unwrapDataType(@NotNull DataType dataType, @NotNull DataGrid grid) {
        PsiObject table;
        if (dataType == null) {
            PgModelHelper.$$$reportNull$$$0(15);
        }
        if (grid == null) {
            PgModelHelper.$$$reportNull$$$0(16);
        }
        return (table = (PsiObject)ObjectUtils.tryCast((Object)DataGridUtil.getDatabaseTable(grid), PsiObject.class)) != null ? SqlImplUtil.getSqlType(dataType, (SqlLanguageDialectEx)PgDialect.INSTANCE, (PsiElement)table).getDataType() : dataType;
    }

    private static void appendPgInheritanceTables(@NotNull StringBuilder b2, @NotNull Collection<? extends PgGPlumBaseTable> tables, @NotNull String tablesAlias) {
        if (b2 == null) {
            PgModelHelper.$$$reportNull$$$0(17);
        }
        if (tables == null) {
            PgModelHelper.$$$reportNull$$$0(18);
        }
        if (tablesAlias == null) {
            PgModelHelper.$$$reportNull$$$0(19);
        }
        b2.append("<br>").append(tablesAlias).append(' ');
        b2.append(tables.size() >= 2 ? "tables: " : "table: ");
        boolean first2 = true;
        for (PgGPlumBaseTable pgGPlumBaseTable : tables) {
            if (first2) {
                first2 = false;
            } else {
                b2.append(',').append(' ');
            }
            b2.append("<b><tt>").append(pgGPlumBaseTable.getName()).append("</tt></b>");
        }
        b2.append("<br>");
    }

    private static void applyPgColumn(@NotNull DeColumn from, PgLocalTableColumn col) {
        PgGPlumBaseSequence prevSeq;
        PgLocalTableColumn prev;
        if (from == null) {
            PgModelHelper.$$$reportNull$$$0(20);
        }
        String prevSeqName = (prev = (PgLocalTableColumn)ObjectUtils.tryCast((Object)from.unwrap(), PgLocalTableColumn.class)) == null ? null : prev.getSequenceName();
        PgGPlumBaseSequence pgGPlumBaseSequence = prevSeq = prev == null ? null : prev.getSequence();
        if (from.flags.contains((Object)DeColumn.Flag.AUTO_INC)) {
            if (prev == null || !prev.isIdentityColumn()) {
                String seqName = prevSeqName == null ? col.getTableName() + "_" + col.getName() + "_seq" : prevSeqName;
                PgSequence seq = (PgSequence)col.getSchema().getSequences().createOrGet(seqName);
                if (prevSeq != null) {
                    BasicMetaUtils.copyProperties(prevSeq, seq, false);
                } else {
                    seq.setOwnedByColumn(true);
                }
                col.setBelongingSequenceName(seqName);
                String schemaName = col.getSchema().getName();
                col.setDefaultExpression(prevSeqName == null ? "nextval('" + (schemaName.isEmpty() ? "" : schemaName + ".") + seqName + "')" : prev.getDefaultExpression());
            }
        } else {
            col.setBelongingSequenceName(null);
            boolean notChangedSeq = prevSeqName != null && Comparing.equal((String)from.defaultValue, (String)prev.getDefaultExpression());
            col.setDefaultExpression(notChangedSeq ? null : from.defaultValue);
            col.setIdentityKind(null);
        }
    }

    @Override
    @Nullable
    public PgBaseTable findTableByObjectId(@NotNull PgBaseSchema schema, long id) {
        PgBaseTable maybeFound;
        if (schema == null) {
            PgModelHelper.$$$reportNull$$$0(21);
        }
        return (maybeFound = super.findTableByObjectId(schema, id)) == null ? (PgBaseTable)((PgSchema)schema).getForeignTables().getByObjectId(id) : maybeFound;
    }

    @Override
    @Nullable
    public PgBaseTable findModTableByObjectId(@NotNull PgBaseSchema schema, long id) {
        PgBaseTable maybeFound;
        if (schema == null) {
            PgModelHelper.$$$reportNull$$$0(22);
        }
        return (maybeFound = super.findModTableByObjectId(schema, id)) == null ? (PgBaseTable)((PgSchema)schema).getForeignTables().getByObjectId(id) : maybeFound;
    }

    @Override
    public boolean hasDefaultType(@NotNull PgGPlumBaseSequence sequence) {
        PgGPlumBaseLocalTableColumn column2;
        if (sequence == null) {
            PgModelHelper.$$$reportNull$$$0(23);
        }
        return (column2 = sequence.getColumn()) instanceof PgLocalTableColumn && ((PgLocalTableColumn)column2).isIdentityColumn() || super.hasDefaultType(sequence);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 4: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correspondence";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delta";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablesAlias";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/postgres/model/PgModelHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "nodeTriggerSuffix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "nodeTableSuffix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "exportApplyColumn";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "exportLightExport";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "ddlPreviewProcessCorrespondence";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "docAppendInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataTypeForGridCompletion";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "unwrapDataType";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "appendPgInheritanceTables";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "applyPgColumn";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "findTableByObjectId";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "findModTableByObjectId";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDefaultType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

