/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.MetaNode;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.MultiMap;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraPlanModelBuilder
extends AbstractPlanModelBuilder<MetaNode<MetaData>> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<Pair<PlanModel.NodeType, String>, PlanModel.NodeType> SUB_MAPPING = new HashMap<Pair<PlanModel.NodeType, String>, PlanModel.NodeType>();
    private final String myStatement;
    @NotNull
    private final String myExplainTable;
    private MetaNode<MetaData> myPlan;

    public OraPlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull String statement, @NotNull String explainTable) {
        if (owner == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (statement == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(2);
        }
        if (explainTable == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(3);
        }
        super(owner, consumer2, EnumSet.of(PlanModel.Feature.STARTUP_COST));
        this.myStatement = statement;
        this.myExplainTable = explainTable;
    }

    @Nullable
    Integer getInteger(ResultSet resultSet, String col) throws SQLException {
        return resultSet.getObject(col) == null ? null : Integer.valueOf(resultSet.getInt(col));
    }

    @Nullable
    BigDecimal getBig(ResultSet resultSet, String col) throws SQLException {
        return resultSet.getObject(col) == null ? null : resultSet.getBigDecimal(col);
    }

    private MetaNode<MetaData> getMetaPlan(@NotNull DatabaseConnection connection2) {
        if (connection2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(4);
        }
        final MultiMap childMap = MultiMap.createLinked();
        final Ref root2 = Ref.create();
        OraPlanModelBuilder.useStatementWithPreserved(connection2, new AbstractPlanModelBuilder.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> statement) throws PlanRetrievalException, SQLException {
                String uuid = OraPlanModelBuilder.randomShorterUUID();
                statement.barren().execute("EXPLAIN PLAN SET STATEMENT_ID = '" + uuid + "' INTO \"" + OraPlanModelBuilder.this.myExplainTable + "\" FOR " + OraPlanModelBuilder.this.myStatement);
                statement.noisy().execute("SELECT OPERATION, OPTIONS, OBJECT_NAME, OBJECT_TYPE, ID, PARENT_ID, POSITION, COST, CARDINALITY, CPU_COST, IO_COST FROM \"" + OraPlanModelBuilder.this.myExplainTable + "\" WHERE STATEMENT_ID = '" + uuid + "'", OraPlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    while (rs.next()) {
                        MetaData nodeData = new MetaData(rs.getString("OPERATION"), rs.getString("OPTIONS"), rs.getString("OBJECT_NAME"), rs.getString("OBJECT_TYPE"), OraPlanModelBuilder.this.getInteger((ResultSet)rs, "ID"), OraPlanModelBuilder.this.getInteger((ResultSet)rs, "PARENT_ID"), OraPlanModelBuilder.this.getInteger((ResultSet)rs, "POSITION"), OraPlanModelBuilder.this.getBig((ResultSet)rs, "COST"), OraPlanModelBuilder.this.getBig((ResultSet)rs, "CARDINALITY"), OraPlanModelBuilder.this.getBig((ResultSet)rs, "CPU_COST"), OraPlanModelBuilder.this.getBig((ResultSet)rs, "IO_COST"));
                        if (nodeData.parentId == null) {
                            root2.set((Object)nodeData);
                            continue;
                        }
                        childMap.putValue((Object)nodeData.parentId, (Object)nodeData);
                    }
                }));
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
        if (root2.get() == null) {
            throw new PlanRetrievalException("No root operation found");
        }
        return new Object(){

            public MetaNode<MetaData> fillChildren(MetaNode<MetaData> node) {
                for (MetaData data : childMap.get((Object)((MetaData)node.data).id)) {
                    node.children.add(this.fillChildren(new MetaNode<MetaData>(data)));
                }
                Collections.sort(node.children, (o1, o2) -> Comparing.compare((Comparable)((MetaData)o1.data).position, (Comparable)((MetaData)o2.data).position));
                return node;
            }
        }.fillChildren(new MetaNode<Object>(root2.get()));
    }

    private void parseModel(@NotNull MetaNode<MetaData> root2) throws PlanRetrievalException {
        if (root2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(5);
        }
        this.openNode(null);
        this.parseStatement(root2);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String dump() {
        String string = new Object(){
            final StringBuilder dump = new StringBuilder();
            {
                this.visit(0, OraPlanModelBuilder.this.myPlan);
            }

            private void visit(int lvl, MetaNode<MetaData> node) {
                for (int i2 = 0; i2 < lvl; ++i2) {
                    this.dump.append("  ");
                }
                this.dump.append(((MetaData)node.data).operation).append("\t").append(((MetaData)node.data).options).append("\t").append(((MetaData)node.data).objectName).append("\t").append(((MetaData)node.data).objectType).append("\t").append(((MetaData)node.data).cardinality).append("\t").append(((MetaData)node.data).cost).append("\t").append(((MetaData)node.data).cpuCost).append("\t").append(((MetaData)node.data).ioCost);
                this.dump.append("\n");
                for (MetaNode<MetaData> metaNode : node.children) {
                    this.visit(lvl + 1, metaNode);
                }
            }
        }.dump.toString();
        if (string == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection2) {
        if (context == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(7);
        }
        if (connection2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(8);
        }
        this.myPlan = this.getMetaPlan(connection2);
        this.showRaw();
        this.parseModel(this.myPlan);
        this.modelReady();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(9);
        }
        String string = "cpu_cost = " + ((MetaData)element2.data).cpuCost + ", io_cost = " + ((MetaData)element2.data).ioCost;
        if (string == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(11);
        }
        return ((MetaData)element2.data).objectType != null && StringUtil.startsWithIgnoreCase((String)((MetaData)element2.data).objectType, (String)"table") ? ((MetaData)element2.data).objectName : null;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(12);
        }
        return ((MetaData)element2.data).cardinality;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(13);
        }
        return ((MetaData)element2.data).objectType != null && StringUtil.startsWithIgnoreCase((String)((MetaData)element2.data).objectType, (String)"index") ? ((MetaData)element2.data).objectName : null;
    }

    @Override
    protected void parsePlan(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(14);
        }
        this.openNode(null);
        this.parseSubPlans(element2);
        PlanModel.NodeType nodeType = TYPE_MAPPING.get(((MetaData)element2.data).operation);
        if (nodeType == null) {
            nodeType = PlanModel.NodeType.UNKNOWN;
        }
        nodeType = (PlanModel.NodeType)((Object)ObjectUtils.chooseNotNull((Object)((Object)SUB_MAPPING.get(Pair.create((Object)((Object)nodeType), (Object)((MetaData)element2.data).options))), (Object)((Object)nodeType)));
        String title = StringUtil.notNullize((String)((MetaData)element2.data).operation) + (StringUtil.isEmpty((String)((MetaData)element2.data).options) ? "" : " " + ((MetaData)element2.data).options);
        PlanModel.GenericNode node = this.createNode(element2, nodeType, title);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(15);
        }
        for (MetaNode<MetaData> metaNode : element2.children) {
            this.parsePlan(metaNode);
        }
    }

    @Override
    protected void parseStatement(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(16);
        }
        this.openNode(null);
        PlanModel.NodeType nodeType = STATEMENT_MAPPING.get(((MetaData)element2.data).operation);
        if (nodeType == null) {
            nodeType = PlanModel.NodeType.STATEMENT;
        }
        PlanModel.GenericNode node = this.createNode(element2, nodeType, nodeType == PlanModel.NodeType.STATEMENT ? ((MetaData)element2.data).operation : null);
        this.parseSubPlans(element2);
        this.closeNode(node);
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(17);
        }
        return ((MetaData)element2.data).cost == null ? null : Double.valueOf(((MetaData)element2.data).cost.doubleValue());
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(19);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode<MetaData> element2) {
        if (element2 == null) {
            OraPlanModelBuilder.$$$reportNull$$$0(20);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("AND-EQUAL", PlanModel.NodeType.SET_OP);
        TYPE_MAPPING.put("BITMAP", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("CONNECT BY", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("CONCATENATION", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("COUNT", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("DOMAIN INDEX", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("FILTER", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("FIRST ROW", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("FOR UPDATE", PlanModel.NodeType.LOCK_ROWS);
        TYPE_MAPPING.put("HASH", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("HASH JOIN", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("INDEX", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("INLIST ITERATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("INTERSECTION", PlanModel.NodeType.INTERSECT);
        TYPE_MAPPING.put("LOAD AS SELECT", PlanModel.NodeType.DIRECT_LOAD);
        TYPE_MAPPING.put("MERGE JOIN", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("MAT_VIEW REWRITE ACCESS", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("MINUS", PlanModel.NodeType.EXCEPT);
        TYPE_MAPPING.put("NESTED LOOPS", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("PARTITION", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX ITERATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX COORDINATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX PARTITION", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX RECEIVE", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX SEND", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("REMOTE", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("SEQUENCE", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("SORT", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("TABLE ACCESS", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("TEMP TABLE TRANSFORMATION", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("UNION-ALL", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("VIEW", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("FAST DUAL", PlanModel.NodeType.VALUE);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"FULL"), PlanModel.NodeType.SEQ_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY ROWID RANGE"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"SAMPLE BY ROWID RANGE"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY USER ROWID"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY GLOBAL INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY LOCAL INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.INDEX_SCAN), (Object)"UNIQUE SCAN"), PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.INDEX_SCAN), (Object)"FULL SCAN"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.INDEX_SCAN), (Object)"FULL SCAN DESCENDING"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.INDEX_SCAN), (Object)"FAST FULL SCAN"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.SORT), (Object)"UNIQUE"), PlanModel.NodeType.SORT_UNIQUE);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.SORT), (Object)"GROUP BY"), PlanModel.NodeType.GROUP_BY);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.SORT), (Object)"ORDER BY"), PlanModel.NodeType.ORDER_BY);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.UNKNOWN), (Object)"SORT"), PlanModel.NodeType.SORT);
        STATEMENT_MAPPING.put("SELECT STATEMENT", PlanModel.NodeType.SELECT);
        STATEMENT_MAPPING.put("INSERT STATEMENT", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("UPDATE STATEMENT", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("DELETE STATEMENT", PlanModel.NodeType.DELETE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explainTable";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/plan/OraPlanModelBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/plan/OraPlanModelBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMetaPlan";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseModel";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processRaw";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MetaData {
        public final String operation;
        public final String options;
        public final String objectName;
        public final String objectType;
        public final Integer id;
        public final Integer parentId;
        public final Integer position;
        public final BigDecimal cardinality;
        public final BigDecimal cost;
        public final BigDecimal cpuCost;
        public final BigDecimal ioCost;

        private MetaData(String operation2, String options, String objectName, String objectType, Integer id, Integer parentId, Integer position, BigDecimal cost, BigDecimal cardinality, BigDecimal cpuCost, BigDecimal ioCost) {
            this.operation = operation2;
            this.options = options;
            this.objectName = objectName;
            this.objectType = objectType;
            this.id = id;
            this.parentId = parentId;
            this.position = position;
            this.cost = cost;
            this.cardinality = cardinality;
            this.cpuCost = cpuCost;
            this.ioCost = ioCost;
        }
    }
}

