/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraMixinObjectType;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectTypeAttribute;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraObjectTypeRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraObjectType
extends OraMixinObjectType,
OraModule {
    @Override
    @Nullable
    default public OraSchema getSchema() {
        return this.getParent();
    }

    @Override
    @Nullable
    public OraSchema getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraObjectType> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModSingletonFamily<@NotNull ? extends OraObjectTypeBody> getBodies();

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends OraObjectTypeAttribute> getAttributes();

    @NotNull
    public @NotNull ModNamingFamily<@NotNull ? extends OraObjectTypeRoutine> getRoutines();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.BODY, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.ROUTINE);
        if (list == null) {
            OraObjectType.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getBodies(), this.getAttributes(), this.getRoutines());
        if (list == null) {
            OraObjectType.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceError> getErrors();

    @Override
    @NotNull
    public Set<Long> getDependsOnIds();

    @Nullable
    public String getSuperSchemaName();

    @Nullable
    public String getSuperObjectName();

    public boolean isIncomplete();

    public boolean isFinal();

    public boolean isInstantiable();

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        boolean instantiable;
        boolean finnal;
        boolean incomplete;
        String superObjectName;
        String superSchemaName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        Set<Long> dependsOnIds;
        boolean obfuscated;
        boolean invalid;
        int sourceTextLength;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer2 == null) {
            OraObjectType.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if (outdated = this.isOutdated()) {
            consumer2.accept("Outdated", PropertyConverter.export(outdated));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer2.accept("SourceTextLength", PropertyConverter.export(sourceTextLength));
        }
        if (invalid = this.isInvalid()) {
            consumer2.accept("Invalid", PropertyConverter.export(invalid));
        }
        if (obfuscated = this.isObfuscated()) {
            consumer2.accept("Obfuscated", PropertyConverter.export(obfuscated));
        }
        if (!(dependsOnIds = this.getDependsOnIds()).isEmpty()) {
            consumer2.accept("DependsOnIds", PropertyConverter.exportSetOfLong(dependsOnIds));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer2.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer2.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((superSchemaName = this.getSuperSchemaName()) != null) {
            consumer2.accept("SuperSchemaName", PropertyConverter.export(superSchemaName));
        }
        if ((superObjectName = this.getSuperObjectName()) != null) {
            consumer2.accept("SuperObjectName", PropertyConverter.export(superObjectName));
        }
        if (incomplete = this.isIncomplete()) {
            consumer2.accept("Incomplete", PropertyConverter.export(incomplete));
        }
        if (finnal = this.isFinal()) {
            consumer2.accept("Final", PropertyConverter.export(finnal));
        }
        if (instantiable = this.isInstantiable()) {
            consumer2.accept("Instantiable", PropertyConverter.export(instantiable));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Outdated", "SourceTextLength", "Errors", "Invalid", "Obfuscated", "DependsOnIds", "CreatedTimestamp", "ModifiedTimestamp", "SuperSchemaName", "SuperObjectName", "Incomplete", "Final", "Instantiable");
        if (list == null) {
            OraObjectType.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setDependsOnIds(@NotNull Set<Long> var1);

    public void setSuperSchemaName(@Nullable String var1);

    public void setSuperObjectName(@Nullable String var1);

    public void setIncomplete(boolean var1);

    public void setFinal(boolean var1);

    public void setInstantiable(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraObjectType.$$$reportNull$$$0(4);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String sourceTextLength = _properties.get("SourceTextLength");
        String invalid = _properties.get("Invalid");
        String obfuscated = _properties.get("Obfuscated");
        String dependsOnIds = _properties.get("DependsOnIds");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        String superSchemaName = _properties.get("SuperSchemaName");
        String superObjectName = _properties.get("SuperObjectName");
        String incomplete = _properties.get("Incomplete");
        String finnal = _properties.get("Final");
        String instantiable = _properties.get("Instantiable");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString(name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean(outdated) : false);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt(sourceTextLength) : 0);
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean(invalid) : false);
        this.setObfuscated(obfuscated != null ? PropertyConverter.importBoolean(obfuscated) : false);
        this.setDependsOnIds(dependsOnIds != null ? PropertyConverter.importSetOfLong(dependsOnIds) : Collections.emptySet());
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate(createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate(modifiedTimestamp) : null);
        this.setSuperSchemaName(superSchemaName != null ? PropertyConverter.importString(superSchemaName) : null);
        this.setSuperObjectName(superObjectName != null ? PropertyConverter.importString(superObjectName) : null);
        this.setIncomplete(incomplete != null ? PropertyConverter.importBoolean(incomplete) : false);
        this.setFinal(finnal != null ? PropertyConverter.importBoolean(finnal) : false);
        this.setInstantiable(instantiable != null ? PropertyConverter.importBoolean(instantiable) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraObjectType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraObjectType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

