/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/oracle/OraPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "formatTypes", "", "Lcom/intellij/database/data/types/LogicalType;", "getFormatTypes", "()Ljava/util/Set;", "ftsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "version", "Lcom/intellij/database/util/Version;", "getFtsIndextype", "Lcom/intellij/database/dialects/oracle/OraPredicatesHelper$FtsIndextype;", "index", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "FtsIndextype", "intellij.database.dialects.oracle"})
public final class OraPredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<LogicalType> formatTypes;

    @Override
    @NotNull
    protected Set<LogicalType> getFormatTypes() {
        return this.formatTypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull DasColumn column2, @Nullable Object value, @Nullable Version version) {
        void indextype;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        if (!(value instanceof String)) {
            return null;
        }
        DasTable dasTable = column2.getTable();
        if (!(dasTable instanceof OraLikeTable)) {
            dasTable = null;
        }
        OraLikeTable oraLikeTable = (OraLikeTable)dasTable;
        if (oraLikeTable == null) {
            return null;
        }
        OraLikeTable table = oraLikeTable;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Iterator iterator = table.getIndices().iterator();
        while (iterator.hasNext()) {
            List<? extends BasicLikeColumn> indexCols;
            BasicIndex index2;
            BasicIndex basicIndex = index2 = (BasicIndex)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicIndex, (String)"index");
            Intrinsics.checkExpressionValueIsNotNull(basicIndex.getCols(), (String)"index.cols");
            if (indexCols.size() != 1 || !Intrinsics.areEqual((Object)indexCols.get(0), (Object)column2) || !(index2 instanceof OraIndex)) continue;
            indextype.element = this.getFtsIndextype((OraIndex)index2);
            if ((FtsIndextype)((Object)indextype.element) == null) continue;
            break;
        }
        if ((FtsIndextype)((Object)indextype.element) == null) {
            return null;
        }
        String string = DbImplUtil.StringLiteralDecorator.MATCHES.decorate((String)value, this.getDbms());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MATCHES.decorate(value, dbms)");
        String literal = string;
        return new PredicatesHelper.PredicateProducer((Ref.ObjectRef)indextype, column2, literal){
            final /* synthetic */ Ref.ObjectRef $indextype;
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                builder.identifier(((FtsIndextype)((Object)this.$indextype.element)).getOperator()).symbol("(").identifier((DasObject)this.$column).symbol(",").space().plain(this.$literal);
                if ((FtsIndextype)((Object)this.$indextype.element) == FtsIndextype.CTXCAT) {
                    builder.symbol(",").space().plain("''");
                }
                builder.symbol(")").space().symbol(">").space().number(0);
            }
            {
                this.$indextype = objectRef;
                this.$column = dasColumn;
                this.$literal = string;
            }
        };
    }

    private final FtsIndextype getFtsIndextype(OraIndex index2) {
        FtsIndextype ftsIndextype;
        block1: {
            FtsIndextype[] ftsIndextypeArray = FtsIndextype.values();
            boolean bl = false;
            FtsIndextype[] ftsIndextypeArray2 = ftsIndextypeArray;
            boolean bl2 = false;
            FtsIndextype[] ftsIndextypeArray3 = ftsIndextypeArray2;
            int n = ftsIndextypeArray3.length;
            for (int j = 0; j < n; ++j) {
                FtsIndextype ftsIndextype2;
                FtsIndextype indexType = ftsIndextype2 = ftsIndextypeArray3[j];
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)index2.getIndextypeName(), (Object)indexType.name()) && Intrinsics.areEqual((Object)index2.getIndextypeOwner(), (Object)indexType.getOwner()))) continue;
                ftsIndextype = ftsIndextype2;
                break block1;
            }
            ftsIndextype = null;
        }
        return ftsIndextype;
    }

    public OraPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
        this.formatTypes = SetsKt.setOf((Object[])new LogicalType[]{LogicalType.TIME_WITH_TIMEZONE, LogicalType.TIMESTAMP_WITH_TIMEZONE, LogicalType.TIMESTAMP, LogicalType.TIME, LogicalType.DATE});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/OraPredicatesHelper$FtsIndextype;", "", "owner", "", "operator", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getOperator", "()Ljava/lang/String;", "getOwner", "CONTEXT", "CTXRULE", "CTXCAT", "intellij.database.dialects.oracle"})
    private static final class FtsIndextype
    extends Enum<FtsIndextype> {
        public static final /* enum */ FtsIndextype CONTEXT;
        public static final /* enum */ FtsIndextype CTXRULE;
        public static final /* enum */ FtsIndextype CTXCAT;
        private static final /* synthetic */ FtsIndextype[] $VALUES;
        @NotNull
        private final String owner;
        @NotNull
        private final String operator;

        static {
            FtsIndextype[] ftsIndextypeArray = new FtsIndextype[3];
            FtsIndextype[] ftsIndextypeArray2 = ftsIndextypeArray;
            ftsIndextypeArray[0] = CONTEXT = new FtsIndextype("CTXSYS", "CONTAINS");
            ftsIndextypeArray[1] = CTXRULE = new FtsIndextype("CTXSYS", "MATCHES");
            ftsIndextypeArray[2] = CTXCAT = new FtsIndextype("CTXSYS", "CATSEARCH");
            $VALUES = ftsIndextypeArray;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getOperator() {
            return this.operator;
        }

        private FtsIndextype(String owner, String operator) {
            this.owner = owner;
            this.operator = operator;
        }

        public static FtsIndextype[] values() {
            return (FtsIndextype[])$VALUES.clone();
        }

        public static FtsIndextype valueOf(String string) {
            return Enum.valueOf(FtsIndextype.class, string);
        }
    }
}

