/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dialects.mysqlbase.MysqlBasePredicatesHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/mysql/MysqlPredicatesHelper;", "Lcom/intellij/database/dialects/mysqlbase/MysqlBasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "shouldCastToChar", "", "", "", "column", "Lcom/intellij/database/model/DasColumn;", "version", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.mysql"})
public final class MysqlPredicatesHelper
extends MysqlBasePredicatesHelper {
    private final Set<String> shouldCastToChar;

    @Override
    protected boolean shouldCastToChar(@NotNull DasColumn column2, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Domain domain = DomainRegistry.getDomain(Dbms.MYSQL, version, new TypeNameColumnDescriptor(column2.getDataType().typeName), true);
        if (domain == null) {
            return false;
        }
        String string = domain.simpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"domain.simpleName()");
        String simpleName = string;
        return version != null && version.isOrGreater(new int[]{8, 0, 4}) && this.shouldCastToChar.contains(simpleName);
    }

    public MysqlPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
        this.shouldCastToChar = SetsKt.setOf((Object[])new String[]{"date", "time", "datetime", "timestamp"});
    }
}

