/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ssrp;

import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.mssql.ssrp.LocalDb;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDbSubstitutor
implements DatabaseConnectionManager.ConnectionSubstitutor {
    @Override
    @Nullable
    public String handle(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull JdbcDriverManager driverManager, @NotNull DatabaseDriver driver, @NotNull String url) {
        if (connectionPoint == null) {
            LocalDbSubstitutor.$$$reportNull$$$0(0);
        }
        if (driverManager == null) {
            LocalDbSubstitutor.$$$reportNull$$$0(1);
        }
        if (driver == null) {
            LocalDbSubstitutor.$$$reportNull$$$0(2);
        }
        if (url == null) {
            LocalDbSubstitutor.$$$reportNull$$$0(3);
        }
        final String localDbInst = connectionPoint.getAdditionalJdbcProperties().get("LOCAL_DB_INSTANCE");
        final String localDbExec = connectionPoint.getAdditionalJdbcProperties().get("LOCAL_DB_EXECUTABLE");
        if (localDbExec == null || localDbInst == null) {
            return null;
        }
        JdbcUrlParser parser = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(driver.getJDBCUrlParsers(), url));
        if (parser == null || !parser.getParameters().contains("localdb_pipe")) {
            return null;
        }
        parser.setUrlText(url);
        if (!parser.isValid()) {
            return null;
        }
        final Ref pipe = Ref.create();
        UIUtil.invokeAndWaitIfNeeded(() -> (new Task.Modal(null, "Actualizing LocalDB Instance Info", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                pipe.set((Object)LocalDb.getPipeForInstance(localDbInst, localDbExec, indicator));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/ssrp/LocalDbSubstitutor$1", "run"));
            }
        }).queue());
        if (!StringUtil.isEmpty((String)((String)pipe.get()))) {
            parser.setParameter("localdb_pipe", (String)pipe.get());
            return parser.getUrlText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connectionPoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "driverManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "driver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "url";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/mssql/ssrp/LocalDbSubstitutor";
        objectArray[2] = "handle";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

