/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExaDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    protected ExaDialect() {
        super(new TypeHelper.ExaTypeHelper(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.EXASOL;
        if (dbms == null) {
            ExaDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        if ("Exasol" == null) {
            ExaDialect.$$$reportNull$$$0(1);
        }
        return "Exasol";
    }

    @Override
    public boolean supportsTableDefinition() {
        return false;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        String s;
        if (system == null) {
            ExaDialect.$$$reportNull$$$0(2);
        }
        if (connection2 == null) {
            ExaDialect.$$$reportNull$$$0(3);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection2, system.getDbms(), "select current_schema", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)"EXA_DB", (ObjectKind)ObjectKind.DATABASE).append(s, ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            ExaDialect.$$$reportNull$$$0(4);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA && current.kind != ObjectKind.EXTERNAL_SCHEMA) {
            return null;
        }
        return String.format("open schema %s", this.quoteIdentifier(current.getName(), false, false));
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> getSupportedFkUpdate() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class);
        if (valuesCapability == null) {
            ExaDialect.$$$reportNull$$$0(5);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> getSupportedFkDelete() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class);
        if (valuesCapability == null) {
            ExaDialect.$$$reportNull$$$0(6);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
        if (valuesCapability == null) {
            ExaDialect.$$$reportNull$$$0(7);
        }
        return valuesCapability;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsUniqueIndices() {
        return false;
    }

    @Override
    @NotNull
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            ExaDialect.$$$reportNull$$$0(8);
        }
        if (kind == ObjectKind.EXTERNAL_SCHEMA) {
            if ("VIRTUAL SCHEMA" == null) {
                ExaDialect.$$$reportNull$$$0(9);
            }
            return "VIRTUAL SCHEMA";
        }
        if (kind == ObjectKind.FOREIGN_TABLE) {
            if ("TABLE" == null) {
                ExaDialect.$$$reportNull$$$0(10);
            }
            return "TABLE";
        }
        String string = super.getNameForKind(kind);
        if (string == null) {
            ExaDialect.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            ExaDialect.$$$reportNull$$$0(12);
        }
        if (sequence == null) {
            ExaDialect.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            ExaDialect.$$$reportNull$$$0(14);
        }
        String name2 = element2.getName();
        String schema = DasUtil.getSchema((DasObject)element2);
        return Pair.create((Object)("SELECT VIEW_TEXT FROM SYS.EXA_USER_VIEWS WHERE VIEW_SCHEMA = '" + schema.replace("'", "''") + "' AND VIEW_NAME = '" + name2.replace("'", "''") + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            ExaDialect.$$$reportNull$$$0(15);
        }
        String name2 = element2.getName();
        String schema = DasUtil.getSchema((DasObject)element2);
        Pair pair = Pair.create((Object)("SELECT FUNCTION_TEXT FROM SYS.EXA_USER_FUNCTIONS WHERE FUNCTION_SCHEMA = '" + schema.replace("'", "''") + "' AND FUNCTION_NAME = '" + name2.replace("'", "''") + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            ExaDialect.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        DasObject schema;
        if (identifier == null) {
            ExaDialect.$$$reportNull$$$0(17);
        }
        if (qualifier == null) {
            ExaDialect.$$$reportNull$$$0(18);
        }
        DasObject schemaOrExternal = (schema = DasUtil.getSchemaObject((DasObject)qualifier)) == null ? DasUtil.getParentOfKind((DasObject)qualifier, (ObjectKind)ObjectKind.EXTERNAL_SCHEMA, (boolean)false) : schema;
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schemaOrExternal, DasUtil.getName((DasObject)schemaOrExternal), null, null, null, null);
        if (ddlBuilder == null) {
            ExaDialect.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/exasol/ExaDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/exasol/ExaDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDelete";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForKind";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

