/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.clickhouse.generator.CHouseNamingService;
import com.intellij.database.dialects.clickhouse.model.CHouseLikeTable;
import com.intellij.database.dialects.clickhouse.model.CHouseRoot;
import com.intellij.database.dialects.clickhouse.model.CHouseSchema;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.util.Version;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBTransaction;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nJ\"\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\nJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\u00020\u0012*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0012*\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "()V", "processColumns", "", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "sc", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "action", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$ColumnInfo;", "processFunctions", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$FunctionInfo;", "processTables", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$TableInfo;", "retrieveSchemas", "", "", "retrieveTableSource", "tab", "Lcom/intellij/database/dialects/clickhouse/model/CHouseLikeTable;", "fqName", "ColumnInfo", "FunctionInfo", "TableInfo", "intellij.database.dialects.clickhouse"})
public final class CHouseIntroQueries
extends BaseIntroQueries {
    public static final CHouseIntroQueries INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> retrieveSchemas(@NotNull DBTransaction transaction) {
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        CHouseIntroQueries cHouseIntroQueries = this;
        String query$iv = "select name from system.databases order by name != currentDatabase()";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, String.class, query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTables(@NotNull DBTransaction transaction, @NotNull CHouseSchema sc, @NotNull Function1<? super TableInfo, Unit> action2) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        CHouseRoot cHouseRoot = sc.getRoot();
        if (cHouseRoot == null || (cHouseRoot = cHouseRoot.getServerVersion()) == null) {
            cHouseRoot = Version.ZERO;
        }
        CHouseRoot ver = cHouseRoot;
        DBTransaction dBTransaction = transaction;
        CHouseIntroQueries cHouseIntroQueries = this;
        String string = "select name, engine, " + (ver.isOrGreater(new int[]{1, 1, 54356}) ? "" : "0") + " is_temporary\n        from system.tables\n        where database = ?\n        ";
        Object[] parameters$iv = new String[]{sc.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, TableInfo.class, (String)query$iv, parameters$iv, action2);
    }

    /*
     * WARNING - void declaration
     */
    public final void processColumns(@NotNull DBTransaction transaction, @NotNull CHouseSchema sc, @NotNull Function1<? super ColumnInfo, Unit> action2) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        DBTransaction dBTransaction = transaction;
        CHouseIntroQueries cHouseIntroQueries = this;
        String string = "select table, name, type, default_kind, default_expression\n          from system.columns\n          where database = ?\n          ";
        Object[] parameters$iv = new String[]{sc.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ColumnInfo.class, (String)query$iv, parameters$iv, action2);
    }

    /*
     * WARNING - void declaration
     */
    public final void processFunctions(@NotNull DBTransaction transaction, @NotNull Function1<? super FunctionInfo, Unit> action2) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        DBTransaction dBTransaction = transaction;
        CHouseIntroQueries cHouseIntroQueries = this;
        String string = "select name, is_aggregate from system.functions";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, FunctionInfo.class, (String)query$iv, parameters$iv, action2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String retrieveTableSource(@NotNull DBTransaction transaction, @NotNull CHouseLikeTable tab) {
        void $this$retrieveOne$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
        DBTransaction dBTransaction = transaction;
        CHouseIntroQueries cHouseIntroQueries = this;
        String query$iv = "show create table " + this.fqName(tab);
        Object[] parameters$iv = null;
        boolean $i$f$retrieveOne = false;
        return (String)BaseIntroQueries.access$retrieveOne((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveOne$iv, String.class, query$iv, parameters$iv);
    }

    private final String fqName(@NotNull CHouseSchema $this$fqName) {
        String string = $this$fqName.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        return CHouseNamingService.INSTANCE.enquoteName(string);
    }

    private final String fqName(@NotNull CHouseLikeTable $this$fqName) {
        BasicSchema basicSchema = $this$fqName.getSchema();
        if (basicSchema == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.clickhouse.model.CHouseSchema");
        }
        StringBuilder stringBuilder = new StringBuilder().append(this.fqName((CHouseSchema)basicSchema)).append('.');
        String string = $this$fqName.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        return stringBuilder.append(CHouseNamingService.INSTANCE.enquoteName(string)).toString();
    }

    private CHouseIntroQueries() {
    }

    static {
        CHouseIntroQueries cHouseIntroQueries;
        INSTANCE = cHouseIntroQueries = new CHouseIntroQueries();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$TableInfo;", "", "()V", "engine", "", "is_temporary", "", "name", "intellij.database.dialects.clickhouse"})
    public static final class TableInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String engine;
        @JvmField
        public boolean is_temporary;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$ColumnInfo;", "", "()V", "default_expression", "", "default_kind", "name", "table", "type", "intellij.database.dialects.clickhouse"})
    public static final class ColumnInfo {
        @JvmField
        @NotNull
        public String table = "";
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @NotNull
        public String type = "";
        @JvmField
        @Nullable
        public String default_kind;
        @JvmField
        @Nullable
        public String default_expression;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$FunctionInfo;", "", "()V", "is_aggregate", "", "Ljava/lang/Boolean;", "name", "", "intellij.database.dialects.clickhouse"})
    public static final class FunctionInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public Boolean is_aggregate;
    }
}

