/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.debugger.SqlProgramSourceKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0001H\u00c6\u0001J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/debugger/SqlProgramPosition;", "Lcom/intellij/xdebugger/XSourcePosition;", "source", "Lcom/intellij/database/debugger/SqlProgramSource;", "lineNr", "", "(Lcom/intellij/database/debugger/SqlProgramSource;I)V", "xPosition", "(Lcom/intellij/database/debugger/SqlProgramSource;Lcom/intellij/xdebugger/XSourcePosition;)V", "getSource", "()Lcom/intellij/database/debugger/SqlProgramSource;", "getXPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "component1", "component2", "copy", "createNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "equals", "", "other", "", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "getOffset", "hashCode", "toString", "", "intellij.database.impl"})
public final class SqlProgramPosition
implements XSourcePosition {
    @NotNull
    private final SqlProgramSource source;
    @NotNull
    private final XSourcePosition xPosition;

    @NotNull
    public VirtualFile getFile() {
        return this.source.getFile();
    }

    public int getLine() {
        return this.xPosition.getLine();
    }

    public int getOffset() {
        return this.xPosition.getOffset();
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Navigatable navigatable = this.xPosition.createNavigatable(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)navigatable, (String)"xPosition.createNavigatable(project)");
        return navigatable;
    }

    @NotNull
    public final SqlProgramSource getSource() {
        return this.source;
    }

    @NotNull
    public final XSourcePosition getXPosition() {
        return this.xPosition;
    }

    public SqlProgramPosition(@NotNull SqlProgramSource source, @NotNull XSourcePosition xPosition) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)xPosition, (String)"xPosition");
        this.source = source;
        this.xPosition = xPosition;
    }

    public SqlProgramPosition(@NotNull SqlProgramSource source, int lineNr) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this(source, SqlProgramSourceKt.createVirtualFilePosition(source.getFile(), lineNr));
    }

    @NotNull
    public final SqlProgramSource component1() {
        return this.source;
    }

    @NotNull
    public final XSourcePosition component2() {
        return this.xPosition;
    }

    @NotNull
    public final SqlProgramPosition copy(@NotNull SqlProgramSource source, @NotNull XSourcePosition xPosition) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)xPosition, (String)"xPosition");
        return new SqlProgramPosition(source, xPosition);
    }

    public static /* synthetic */ SqlProgramPosition copy$default(SqlProgramPosition sqlProgramPosition, SqlProgramSource sqlProgramSource, XSourcePosition xSourcePosition, int n, Object object) {
        if ((n & 1) != 0) {
            sqlProgramSource = sqlProgramPosition.source;
        }
        if ((n & 2) != 0) {
            xSourcePosition = sqlProgramPosition.xPosition;
        }
        return sqlProgramPosition.copy(sqlProgramSource, xSourcePosition);
    }

    @NotNull
    public String toString() {
        return "SqlProgramPosition(source=" + this.source + ", xPosition=" + this.xPosition + ")";
    }

    public int hashCode() {
        SqlProgramSource sqlProgramSource = this.source;
        XSourcePosition xSourcePosition = this.xPosition;
        return (sqlProgramSource != null ? ((Object)sqlProgramSource).hashCode() : 0) * 31 + (xSourcePosition != null ? xSourcePosition.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SqlProgramPosition)) break block3;
                SqlProgramPosition sqlProgramPosition = (SqlProgramPosition)object;
                if (!Intrinsics.areEqual((Object)this.source, (Object)sqlProgramPosition.source) || !Intrinsics.areEqual((Object)this.xPosition, (Object)sqlProgramPosition.xPosition)) break block3;
            }
            return true;
        }
        return false;
    }
}

