/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.debugger.SqlBreakpointProperties;
import com.intellij.database.debugger.SqlDebuggerEditorsProvider;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTrigger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLineBreakpointType
extends XLineBreakpointType<SqlBreakpointProperties> {
    public static final String ID = "SqlLineBreakpoint";
    public static final String NAME = "SQL line breakpoint";

    protected SqlLineBreakpointType() {
        super(ID, NAME);
    }

    @Nullable
    public SqlBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            SqlLineBreakpointType.$$$reportNull$$$0(0);
        }
        return new SqlBreakpointProperties();
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        int end;
        if (file == null) {
            SqlLineBreakpointType.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SqlLineBreakpointType.$$$reportNull$$$0(2);
        }
        if (!Registry.is((String)"database.debug.enable")) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        int start = document.getLineEndOffset(line);
        if (start == (end = document.getLineStartOffset(line))) {
            return false;
        }
        Ref res2 = Ref.create((Object)false);
        XDebuggerUtil.getInstance().iterateLine(project, document, line, element2 -> {
            SqlStatement st = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class, (boolean)false);
            boolean result2 = st != null && SyntaxTraverser.psiApi().parents((Object)st).skip(1).find(o -> o instanceof DasRoutine || o instanceof DasTrigger) != null;
            res2.set((Object)result2);
            return !result2;
        });
        return (Boolean)res2.get();
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<SqlBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            SqlLineBreakpointType.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SqlLineBreakpointType.$$$reportNull$$$0(4);
        }
        return new SqlDebuggerEditorsProvider();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/debugger/SqlLineBreakpointType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBreakpointProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorsProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

