/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSrcChangesTracker {
    public static final VcsRevisionNumber LOCAL = VcsRevisionNumber.NULL;
    public static final VcsRevisionNumber REMOTE = new TextRevisionNumber("Remote");
    protected final Map<String, DbSrcChangeList> myChangeLists = new HashMap<String, DbSrcChangeList>();
    private final EventDispatcher<ModificationTrackerListener<DbSrcChangesTracker>> myDispatcher = DataSourceUiUtil.eventDispatcher(ModificationTrackerListener.class);
    protected final Project myProject;

    @NotNull
    public static DbSrcChangesTracker getInstance(@Nullable Project project) {
        DbSrcChangesTracker dbSrcChangesTracker = project == null ? (DbSrcChangesTracker)ServiceManager.getService(App.class) : (DbSrcChangesTracker)ServiceManager.getService((Project)project, Prj.class);
        if (dbSrcChangesTracker == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(0);
        }
        return dbSrcChangesTracker;
    }

    public DbSrcChangesTracker(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public abstract DbSrcFileStatus getFileStatus();

    public boolean isDisposed() {
        return this.myProject != null ? this.myProject.isDisposed() : ApplicationManager.getApplication().isDisposed();
    }

    public void addListener(@NotNull ModificationTrackerListener<DbSrcChangesTracker> listener, @NotNull Disposable parent2) {
        if (listener == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener(listener, parent2);
    }

    protected void invokeLater(@NotNull Runnable r) {
        if (r == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(3);
        }
        Application app = ApplicationManager.getApplication();
        app.invokeLater(r, this.myProject == null ? app.getDisposed() : this.myProject.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DbSrcChangeList> getChangeLists() {
        ArrayList<DbSrcChangeList> changeLists;
        Map<String, DbSrcChangeList> map2 = this.myChangeLists;
        synchronized (map2) {
            changeLists = new ArrayList<DbSrcChangeList>(this.myChangeLists.values());
        }
        if (this.myProject != null) {
            changeLists.addAll(DbSrcChangesTracker.getInstance(null).getChangeLists());
        }
        ArrayList<DbSrcChangeList> arrayList = changeLists;
        if (arrayList == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DbSrcChangeList getChangeList(@NotNull String dataSource) {
        if (dataSource == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(5);
        }
        Map<String, DbSrcChangeList> map2 = this.myChangeLists;
        synchronized (map2) {
            return this.myChangeLists.get(dataSource);
        }
    }

    @Nullable
    public static Change getChange(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(6);
        }
        if (!DbSrcUtils.isDbSrcFile(file)) {
            return null;
        }
        DbSrcChangeList list = DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<DbSrcChangeList>(){

            @Override
            public DbSrcChangeList processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                return original ? null : DbSrcChangesTracker.getInstance(project).getChangeList(dataSourceId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$1";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (list == null) {
            return null;
        }
        for (Change change : list.getChanges()) {
            DbContentRevision rev = (DbContentRevision)((Object)ObjectUtils.tryCast((Object)change.getAfterRevision(), DbContentRevision.class));
            if (rev == null || !file.equals(rev.getVirtualFile())) continue;
            return change;
        }
        return null;
    }

    public static boolean isChanged(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(7);
        }
        ((App)ServiceManager.getService(App.class)).distributeUpdates(Collections.singletonList(file));
        return DbSrcChangesTracker.getChange(file) != null;
    }

    public static void flushAndUpdateFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            FileDocumentManager docManager = FileDocumentManager.getInstance();
            for (VirtualFile file : files) {
                Document document = docManager.getDocument(file);
                if (document != null) {
                    docManager.saveDocument(document);
                }
                DbSrcFileSystem.getInstance().getBaseFile(file, false, true);
            }
        });
        ((App)ServiceManager.getService(App.class)).distributeUpdates(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(9);
        }
        if (!files.isEmpty()) {
            HashMap changeLists = new HashMap();
            MultiMap byDataSource = MultiMap.createLinkedSet();
            Map<String, DbSrcChangeList> map2 = this.myChangeLists;
            synchronized (map2) {
                this.myChangeLists.forEach((key2, value) -> changeLists.put(key2, value));
            }
            DbSrcFileSystem dbFs = DbSrcFileSystem.getInstance();
            for (VirtualFile file : files) {
                VirtualFile base;
                String ds = DbSrcUtils.getDataSource(file);
                if (ds == null || (base = dbFs.getBaseFile(file, true, false, true)) == null) continue;
                byDataSource.putValue((Object)ds, (Object)base);
            }
            for (Map.Entry entry : byDataSource.entrySet()) {
                DbSrcChangeList list = (DbSrcChangeList)changeLists.get(entry.getKey());
                if (list == null) continue;
                list.updateChanges((Iterable)entry.getValue());
            }
        }
        if (this.myProject != null) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
        ((ModificationTrackerListener)this.myDispatcher.getMulticaster()).modificationCountChanged((Object)this);
    }

    public static void updateIndexLater(@NotNull Set<Project> projects, @Nullable Runnable extra) {
        if (projects == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(10);
        }
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> {
            DbSrcChangesTracker.updateIndex(projects);
            if (extra != null) {
                extra.run();
            }
        }, app.getDisposed());
    }

    public static void updateIndex(@NotNull Set<Project> projects) {
        if (projects == null) {
            DbSrcChangesTracker.$$$reportNull$$$0(11);
        }
        JBIterable toProcess = projects.contains(null) ? Arrays.asList(ProjectManager.getInstance().getOpenProjects()) : JBIterable.from(projects).filter(p2 -> !p2.isDisposed());
        toProcess.forEach(p2 -> ((Prj)ServiceManager.getService((Project)p2, Prj.class)).updateIndex());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChangeList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "flushAndUpdateFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateIndexLater";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDataSourceListener
    implements DataSourceStorage.Listener {
        private final DbSrcChangesTracker myTracker;

        MyDataSourceListener(@NotNull DbSrcChangesTracker tracker) {
            if (tracker == null) {
                MyDataSourceListener.$$$reportNull$$$0(0);
            }
            this.myTracker = tracker;
            for (LocalDataSource localDataSource : this.getDataSources()) {
                this.dataSourceAdded(localDataSource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MyDataSourceListener.$$$reportNull$$$0(1);
            }
            if (!this.isGlobalAccepted() && dataSource.isGlobal() || this.myTracker.isDisposed()) {
                return;
            }
            Map<String, DbSrcChangeList> map2 = this.myTracker.myChangeLists;
            synchronized (map2) {
                String id = dataSource.getUniqueId();
                if (!this.myTracker.myChangeLists.containsKey(id)) {
                    this.myTracker.myChangeLists.put(id, new DbSrcChangeList(this.myTracker.myProject, id));
                }
            }
        }

        private boolean isGlobalAccepted() {
            return this.myTracker.myProject == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MyDataSourceListener.$$$reportNull$$$0(2);
            }
            if (!this.isGlobalAccepted() && dataSource.isGlobal() || this.myTracker.isDisposed()) {
                return;
            }
            Map<String, DbSrcChangeList> map2 = this.myTracker.myChangeLists;
            synchronized (map2) {
                String id = dataSource.getUniqueId();
                this.myTracker.myChangeLists.remove(id);
            }
        }

        @NotNull
        private List<? extends LocalDataSource> getDataSources() {
            if (this.myTracker.myProject != null) {
                List<LocalDataSource> list = DataSourceStorage.getProjectStorage(this.myTracker.myProject).getDataSources();
                if (list == null) {
                    MyDataSourceListener.$$$reportNull$$$0(3);
                }
                return list;
            }
            List<LocalDataSource> list = DataSourceStorage.getStorage().getDataSources();
            if (list == null) {
                MyDataSourceListener.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "dataSourceAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "dataSourceRemoved";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Prj
    extends DbSrcChangesTracker {
        private final Alarm myAlarm;

        public Prj(@NotNull Project project, @NotNull App ignored) {
            if (project == null) {
                Prj.$$$reportNull$$$0(0);
            }
            if (ignored == null) {
                Prj.$$$reportNull$$$0(1);
            }
            super(project);
            this.myAlarm = new Alarm((Disposable)project);
            project.getMessageBus().connect((Disposable)project).subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceListener(this));
        }

        private void updateIndex() {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> DumbService.getInstance((Project)this.myProject).queueTask((DumbModeTask)new UnindexedFilesUpdater(this.myProject)), 5000, ModalityState.NON_MODAL);
        }

        @Override
        @NotNull
        public DbSrcFileStatus getFileStatus() {
            DbSrcFileStatus dbSrcFileStatus = ((App)ServiceManager.getService(App.class)).getFileStatus();
            if (dbSrcFileStatus == null) {
                Prj.$$$reportNull$$$0(2);
            }
            return dbSrcFileStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$Prj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$Prj";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class App
    extends DbSrcChangesTracker {
        private final DbSrcFileStatus myFileStatus = new DbSrcFileStatus();
        private final Set<VirtualFile> myDirtyFiles = new HashSet<VirtualFile>();
        private final Alarm myAlarm = new Alarm();
        private final AtomicBoolean myAdded = new AtomicBoolean(false);
        private final DocumentListener myListener = new DocumentListener(){
            private final FileDocumentManager documentManager = FileDocumentManager.getInstance();

            public void documentChanged(@NotNull DocumentEvent event) {
                VirtualFile file;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DbSrcUtils.isDbSrcFile(file = this.documentManager.getFile(event.getDocument()))) {
                    this.fileDirty(file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App$1", "documentChanged"));
            }
        };

        public App() {
            super(null);
            MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
            appConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void after(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    HashSet<Project> projects = new HashSet<Project>();
                    for (VFileEvent vFileEvent : events) {
                        Ref<Project> project;
                        if (!(vFileEvent.getFileSystem() instanceof DbSrcFileSystem)) continue;
                        this.fileDirty(vFileEvent.getFile());
                        if (!(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileContentChangeEvent) || (project = DbSrcUtils.getProject(vFileEvent.getPath())) == null) continue;
                        projects.add((Project)project.get());
                    }
                    if (!projects.isEmpty()) {
                        DbSrcChangesTracker.updateIndexLater(projects, null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App$2", "after"));
                }
            });
            appConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectOpened(@NotNull Project project) {
                    if (project == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.ensureListenerAdded();
                }

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (JBIterable.of((Object[])ProjectManager.getInstance().getOpenProjects()).filter(p2 -> !p2.isDefault()).isEmpty()) {
                        this.ensureListenerRemoved();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "project";
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectOpened";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectClosed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ProjectManager projectManager = ProjectManager.getInstance();
            if (projectManager != null) {
                for (Project project : projectManager.getOpenProjects()) {
                    if (project.isDefault()) continue;
                    this.ensureListenerAdded();
                }
            }
            appConnection.subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceListener(this));
        }

        public void ensureListenerAdded() {
            if (!this.myAdded.getAndSet(true)) {
                EditorFactory.getInstance().getEventMulticaster().addDocumentListener(this.myListener);
            }
        }

        public void ensureListenerRemoved() {
            if (this.myAdded.getAndSet(false)) {
                EditorFactory.getInstance().getEventMulticaster().removeDocumentListener(this.myListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fileDirty(@Nullable VirtualFile file) {
            if (!DbSrcUtils.isDbSrcFile(file)) {
                return;
            }
            Set<VirtualFile> set = this.myDirtyFiles;
            synchronized (set) {
                this.myDirtyFiles.add(file);
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(this::update, 1000, ModalityState.defaultModalityState());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            ArrayList<VirtualFile> files;
            Set<VirtualFile> set = this.myDirtyFiles;
            synchronized (set) {
                files = new ArrayList<VirtualFile>(this.myDirtyFiles);
                this.myDirtyFiles.clear();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.distributeUpdates(files));
        }

        private void distributeUpdates(List<VirtualFile> files) {
            MultiMap byProject = MultiMap.create();
            for (VirtualFile file : files) {
                Ref<Project> p2 = DbSrcUtils.getProject(file.getPath());
                if (p2 == null) continue;
                byProject.putValue(p2.get(), (Object)file);
            }
            if (byProject.containsKey(null)) {
                this.updateFiles(byProject.get(null));
                for (Iterator<Object> iterator : ProjectManager.getInstance().getOpenProjects()) {
                    DbSrcChangesTracker.getInstance(iterator).updateFiles(byProject.get(iterator));
                }
            } else {
                for (Map.Entry entry : byProject.entrySet()) {
                    DbSrcChangesTracker.getInstance((Project)entry.getKey()).updateFiles((Collection)entry.getValue());
                }
            }
        }

        @Override
        @NotNull
        public DbSrcFileStatus getFileStatus() {
            DbSrcFileStatus dbSrcFileStatus = this.myFileStatus;
            if (dbSrcFileStatus == null) {
                App.$$$reportNull$$$0(0);
            }
            return dbSrcFileStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App", "getFileStatus"));
        }
    }

    public static final class DbContentRevision
    extends CurrentContentRevision {
        private final VirtualFile myContent;
        private final VcsRevisionNumber myRevision;

        public DbContentRevision(@NotNull VirtualFile content, @NotNull FilePath file, @NotNull VcsRevisionNumber revision) {
            if (content == null) {
                DbContentRevision.$$$reportNull$$$0(0);
            }
            if (file == null) {
                DbContentRevision.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                DbContentRevision.$$$reportNull$$$0(2);
            }
            super(file);
            this.myContent = content;
            this.myFile = file;
            this.myRevision = revision;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myContent;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision;
            if (vcsRevisionNumber == null) {
                DbContentRevision.$$$reportNull$$$0(3);
            }
            return vcsRevisionNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbContentRevision";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbSrcChangeList
    implements ChangeList {
        private final String myDataSourceId;
        private final Project myProject;
        private volatile Map<VirtualFile, Change> myChanges;
        private String myName;

        public DbSrcChangeList(@Nullable Project project, @NotNull String dataSourceId) {
            if (dataSourceId == null) {
                DbSrcChangeList.$$$reportNull$$$0(0);
            }
            this.myChanges = Collections.emptyMap();
            this.myProject = project;
            this.myDataSourceId = dataSourceId;
            this.updateName();
        }

        public Collection<Change> getChanges() {
            return this.myChanges == null ? Collections.emptyList() : this.myChanges.values();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                DbSrcChangeList.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String getComment() {
            return null;
        }

        private void updateName() {
            LocalDataSource source = this.getDataSource();
            this.myName = source == null ? "invalid" : source.getName();
        }

        @Nullable
        public LocalDataSource getDataSource() {
            return DbSrcUtils.findDataSource(this.myProject, this.myDataSourceId);
        }

        public void updateChanges(@NotNull Iterable<VirtualFile> files) {
            if (files == null) {
                DbSrcChangeList.$$$reportNull$$$0(2);
            }
            final DbSrcFileStatus fileStatus = DbSrcChangesTracker.getInstance(null).getFileStatus();
            final VcsContextFactory contextFactory = VcsContextFactory.SERVICE.getInstance();
            Map<VirtualFile, Change> old = this.myChanges;
            final ContainerUtil.ImmutableMapBuilder newChanges = ContainerUtil.immutableMapBuilder();
            for (Map.Entry<VirtualFile, Change> entry : old.entrySet()) {
                if (fileStatus.getStatus(entry.getKey()).getStatus() == null) continue;
                newChanges.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            for (VirtualFile file : files) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file) {
                        if (file == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (file.isDirectory()) {
                            return true;
                        }
                        DbSrcFileStatus.StatusEntry status = fileStatus.getStatus(file);
                        if (status.getStatus() != null) {
                            String baseUrl = status.getBaseFileUrl();
                            VirtualFile baseFile = baseUrl == null ? null : VirtualFileManager.getInstance().findFileByUrl(baseUrl);
                            FilePath path = contextFactory.createFilePath(file.getPath(), false);
                            newChanges.put((Object)file, (Object)new Change((ContentRevision)(baseFile == null ? null : new DbContentRevision(baseFile, path, REMOTE)), (ContentRevision)new DbContentRevision(file, path, LOCAL), status.getStatus()));
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList$1", "visitFile"));
                    }
                });
            }
            this.updateName();
            this.myChanges = newChanges.build();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateChanges";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

