/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConnectionSubstitutor
implements DatabaseConnectionManager.ConnectionSubstitutor {
    public static final String SSH_HOST = "localhost";

    @Override
    @Nullable
    public String handle(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull JdbcDriverManager driverManager, @NotNull DatabaseDriver driver, @NotNull String url) {
        Integer localPort;
        if (connectionPoint == null) {
            SshConnectionSubstitutor.$$$reportNull$$$0(0);
        }
        if (driverManager == null) {
            SshConnectionSubstitutor.$$$reportNull$$$0(1);
        }
        if (driver == null) {
            SshConnectionSubstitutor.$$$reportNull$$$0(2);
        }
        if (url == null) {
            SshConnectionSubstitutor.$$$reportNull$$$0(3);
        }
        if ((localPort = driverManager.getLocalPort(connectionPoint.getDataSource())) == null) {
            return null;
        }
        Ref parser = Ref.create();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), StringUtil.notNullize((String)url), (Ref<JdbcUrlParser>)parser);
        if (hostPort == null) {
            return url;
        }
        ((JdbcUrlParser)parser.get()).setParameter("host", SSH_HOST);
        ((JdbcUrlParser)parser.get()).setParameter("port", String.valueOf(localPort));
        return ((JdbcUrlParser)parser.get()).getUrlText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connectionPoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "driverManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "driver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "url";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/SshConnectionSubstitutor";
        objectArray[2] = "handle";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

