/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessTemplateJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import icons.DatabaseIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public class DatabaseDriverImpl
implements DatabaseDriver {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverImpl.class);
    public static final String DRIVER_DIR = "jdbc-drivers";
    public static final String PROPERTY_DRIVER_PATH = "datagrip.driver.path";
    @Nullable
    private static String ourDownloadPath;
    private final boolean myPredefined;
    private final String myId;
    private String myName;
    private String myComment;
    private String myDriverClass;
    private String mySqlDialect;
    private Icon myIcon;
    private String myIconName;
    private String myVmOptions;
    private final Map<String, String> myVmEnv = new LinkedHashMap<String, String>();
    private final List<UrlTemplate> myUrlTemplates = new ArrayList<UrlTemplate>();
    private final Map<String, String> myDriverProperties = new LinkedHashMap<String, String>();
    private final Map<DatabaseDriver.Option<?>, String> myOptions = new LinkedHashMap();
    private String myJrePath;
    private String myInitScript;
    private String myKeepAliveQuery;
    private ArtifactRefImpl myArtifactRef;
    private DatabaseDriver.Bounds myBounds;
    private final List<SimpleClasspathElement> myAdditionalClasspathElements = new ArrayList<SimpleClasspathElement>();
    private final Ref<Parsers> myParsers = Ref.create();

    @NotNull
    public static @SystemDependent String getDownloadPath() {
        if (ourDownloadPath == null) {
            String propertyValue = System.getProperty(PROPERTY_DRIVER_PATH);
            ourDownloadPath = propertyValue != null ? PathManager.getAbsolutePath((String)StringUtil.unquoteString((String)propertyValue, (char)'\"')) : PathManager.getConfigPath() + File.separator + DRIVER_DIR;
        }
        String string = ourDownloadPath;
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public DatabaseDriverImpl(@Nullable String id, boolean predefined) {
        this.myId = StringUtil.isEmpty((String)id) ? UUID.randomUUID().toString() : id;
        this.myPredefined = predefined;
    }

    public DatabaseDriverImpl(@Nullable String id, @Nullable String name2, @Nullable String driverClass, @Nullable UrlTemplate urlTemplate) {
        this(id, false);
        this.myName = name2;
        this.myDriverClass = driverClass;
        if (urlTemplate != null) {
            this.setURLTemplates(Collections.singletonList(urlTemplate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Parsers getParsers() {
        Ref<Parsers> ref = this.myParsers;
        // MONITORENTER : ref
        if (this.myParsers.isNull()) {
            this.myParsers.set((Object)new Parsers(this.myUrlTemplates));
        }
        Parsers parsers = (Parsers)this.myParsers.get();
        // MONITOREXIT : ref
        if (parsers != null) return parsers;
        DatabaseDriverImpl.$$$reportNull$$$0(1);
        return parsers;
    }

    @NotNull
    public List<Pair<UrlTemplate, String>> getTemplatesErrors() {
        List<Pair<UrlTemplate, String>> list = this.getParsers().templatesErrors;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public boolean isPredefined() {
        return this.myPredefined;
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = !StringUtil.isEmpty((String)this.myName) ? this.myName : "?";
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getComment() {
        return this.myComment;
    }

    @NotNull
    public String getFullName() {
        String string = this.getName();
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(5);
        }
        this.myName = name2;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment;
    }

    @Override
    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers() {
        List<StatelessJdbcUrlParser> list = this.getParsers().jdbcUrlParsers;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @Nullable
    public DatabaseDriver.Bounds getConnectionBounds() {
        return this.myBounds;
    }

    @Nullable
    public String getJrePath() {
        return this.myJrePath;
    }

    public void setJrePath(@Nullable String jrePath) {
        this.myJrePath = jrePath;
    }

    @Override
    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations() {
        EnumSet<StatelessJdbcUrlParser.LocationType> enumSet = this.getParsers().supportedLocations;
        if (enumSet == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(7);
        }
        return enumSet;
    }

    @Override
    public LocalDataSource createDataSource(@Nullable String newName) {
        LocalDataSource result2 = LocalDataSource.fromDriver(this, this.getSampleUrl(), false);
        if (DbImplUtil.supportsDomainAuth(this)) {
            result2.setDomainAuthentication(true);
        }
        this.setDefaultProperties(result2, true);
        result2.setName(StringUtil.notNullize((String)newName));
        return result2;
    }

    public void setDefaultProperties(@NotNull LocalDataSource result2, boolean override) {
        if (result2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(8);
        }
        if (override) {
            result2.setVmOptions(this.myVmOptions);
            result2.setVmEnv(this.myVmEnv);
            result2.setInitScript(this.myInitScript);
        } else {
            result2.setVmOptions(StringUtil.join(Arrays.asList(this.myVmOptions, result2.getVmOptions()), (String)" "));
            result2.getVmEnv().putAll(ContainerUtil.union(this.myVmEnv, result2.getVmEnv()));
            result2.setInitScript(StringUtil.join(Arrays.asList(this.myInitScript, result2.getInitScript()), (String)"\n"));
        }
        result2.setDriverClass(this.myDriverClass);
        result2.setAutoSynchronize(DatabaseDriver.OPTION_AUTO_SYNC.get(this));
        result2.setAutoCommit(DatabaseDriver.OPTION_AUTO_COMMIT.get(this));
        result2.setSchemaControl(DatabaseDriver.OPTION_SCHEMA_CONTROL.get(this));
        result2.setSourceLoading(DatabaseDriver.OPTION_SOURCE_LOADING.get(this));
        StatelessJdbcUrlParser urlParser = JdbcUrlParserUtil.select(result2);
        result2.setAuthRequired(urlParser == null || JdbcUrlParserUtil.isAuthSupported(urlParser));
    }

    @Override
    public String getDriverClass() {
        return this.myDriverClass;
    }

    public void setDriverClass(String driverClass) {
        this.myDriverClass = driverClass;
    }

    @NotNull
    public Collection<UrlTemplate> getUrlTemplates() {
        List<UrlTemplate> list = this.myUrlTemplates;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURLTemplates(@NotNull Collection<UrlTemplate> templates) {
        if (templates == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(10);
        }
        this.myUrlTemplates.clear();
        this.myUrlTemplates.addAll(templates);
        Ref<Parsers> ref = this.myParsers;
        synchronized (ref) {
            this.myParsers.set(null);
        }
    }

    @Override
    public boolean matchesUrl(@NotNull String url) {
        if (url == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(11);
        }
        return JdbcUrlParserUtil.select(this.getJDBCUrlParsers(), url) != null;
    }

    @Override
    @NotNull
    public String getSampleUrl() {
        StatelessJdbcUrlParser sparser = null;
        for (StatelessJdbcUrlParser parser : this.getJDBCUrlParsers()) {
            if (!parser.getName().equals("default")) continue;
            sparser = parser;
            break;
        }
        if (sparser == null) {
            sparser = (StatelessJdbcUrlParser)ContainerUtil.getFirstItem(this.getJDBCUrlParsers());
        }
        if (sparser == null) {
            if ("" == null) {
                DatabaseDriverImpl.$$$reportNull$$$0(12);
            }
            return "";
        }
        JdbcUrlParser parser = sparser.createStateful();
        for (String p2 : parser.getParameters()) {
            String def = parser.getParameterDefValue(p2);
            parser.setParameter(p2, StringUtil.notNullize((String)def));
        }
        String string = parser.getUrlText();
        if (string == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public String getSqlDialect() {
        return this.mySqlDialect;
    }

    public void setSqlDialect(String dialect) {
        if (Comparing.equal((String)dialect, (String)this.getSqlDialect())) {
            return;
        }
        this.mySqlDialect = dialect;
    }

    @NotNull
    public Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.myIcon != null ? this.myIcon : DatabaseIcons.UserDriver;
        if (icon == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(14);
        }
        return icon;
    }

    public void setIcon(@Nullable Icon icon) {
        if (this.myIcon == icon || this.myIcon == null && icon == DatabaseIcons.UserDriver) {
            return;
        }
        this.myIcon = icon;
        Dbms dbms = DbImplUtil.getDbms(this);
        if (dbms == Dbms.UNKNOWN && this.myIcon != DatabaseIcons.UserDriver || dbms != Dbms.UNKNOWN && this.myIcon != dbms.getIcon()) {
            if (icon != null && !(icon instanceof IconLoader.CachedImageIcon)) {
                throw new AssertionError((Object)icon.getClass().getName());
            }
            this.myIconName = icon == null ? null : ((IconLoader.CachedImageIcon)icon).getOriginalPath();
        }
    }

    @Override
    public Map<String, String> getDriverProperties() {
        return this.myDriverProperties;
    }

    @Override
    public <T> T getOption(@NotNull DatabaseDriver.Option<T> option) {
        if (option == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(15);
        }
        String value = this.myOptions.get(option);
        return option.fromString(value);
    }

    @Override
    public <T> void setOption(@NotNull DatabaseDriver.Option<T> option, T value) {
        if (option == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(16);
        }
        if (value == null) {
            this.myOptions.remove(option);
        } else {
            this.myOptions.put(option, String.valueOf(value));
        }
    }

    @Override
    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map2 = this.myVmEnv;
        if (map2 == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(17);
        }
        return map2;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(18);
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @Nullable
    public String getInitScript() {
        return this.myInitScript;
    }

    public void setInitScript(@Nullable String initScript) {
        this.myInitScript = initScript;
    }

    @Nullable
    public String getKeepAliveQuery() {
        return this.myKeepAliveQuery;
    }

    public void setKeepAliveQuery(@Nullable String keepAliveQuery) {
        this.myKeepAliveQuery = keepAliveQuery;
    }

    public String getArtifactName() {
        return this.myArtifactRef == null ? null : this.myArtifactRef.getName();
    }

    @Override
    @Nullable
    public DatabaseDriver.ArtifactRef getArtifact() {
        return this.myArtifactRef;
    }

    @Override
    public List<SimpleClasspathElement> getClasspathElements() {
        if (this.myArtifactRef == null || !this.myArtifactRef.isUsed()) {
            return Collections.unmodifiableList(this.myAdditionalClasspathElements);
        }
        return JBIterable.from(this.myArtifactRef.getElements()).append(this.myAdditionalClasspathElements).toList();
    }

    public void loadState(@NotNull Element config, boolean merge, boolean overrideName, int format) {
        if (config == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(19);
        }
        this.loadState(config, merge, overrideName, format, null);
    }

    public void loadState(@NotNull Element config, boolean merge, boolean overrideName, int format, @Nullable PluginDescriptor descriptor) {
        Element keepAliveQueryElement;
        String optionName;
        Element artifactElement;
        Element vmOptionsElement;
        Element env;
        Application app;
        PathMacroManager pathMacroManager;
        if (config == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(20);
        }
        PathMacroManager pathMacroManager2 = pathMacroManager = (app = ApplicationManager.getApplication()) == null ? null : PathMacroManager.getInstance((ComponentManager)app);
        if (overrideName || this.myName == null) {
            this.myName = DatabaseDriverImpl.getOverride(config.getAttributeValue("name"), this.myName, merge);
        }
        this.myDriverClass = DatabaseDriverImpl.getOverride(config.getAttributeValue("driver-class"), this.myDriverClass, merge);
        this.myJrePath = DatabaseDriverImpl.getOverride(config.getAttributeValue("jre-path"), this.myJrePath, merge);
        Element bounds = config.getChild("connection-bounds");
        if (!merge) {
            this.myBounds = null;
        }
        if (bounds != null) {
            String readOnly = bounds.getAttributeValue("in-read-only");
            String boundTo = bounds.getAttributeValue("bound-to");
            LinkedHashSet<Object> rewriteParameters = new LinkedHashSet<Object>();
            for (Element param : bounds.getChildren("rewrite-parameter")) {
                String name2 = param.getAttributeValue("name");
                boolean inUrl = "true".equals(param.getAttributeValue("in-url"));
                if (!StringUtil.isNotEmpty((String)name2)) continue;
                rewriteParameters.add(Pair.create((Object)name2, (Object)inUrl));
            }
            String defaultValue = bounds.getAttributeValue("default-value");
            if (!merge || this.myBounds == null) {
                if (this.myBounds == null) {
                    this.myBounds = new DatabaseDriver.Bounds();
                }
                this.myBounds.inReadOnlyMode = "true".equals(readOnly);
                this.myBounds.boundTo = "schema".equals(boundTo) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                this.myBounds.rewriteParameters = new ArrayList<Pair<String, Boolean>>(rewriteParameters);
                this.myBounds.defaultValue = defaultValue;
            } else {
                if (readOnly != null) {
                    this.myBounds.inReadOnlyMode = "true".equals(readOnly);
                }
                if (boundTo != null) {
                    ObjectKind objectKind = this.myBounds.boundTo = "schema".equals(boundTo) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                }
                if (!rewriteParameters.isEmpty()) {
                    rewriteParameters.addAll(this.myBounds.rewriteParameters);
                    this.myBounds.rewriteParameters = new ArrayList<Pair<String, Boolean>>(rewriteParameters);
                }
                if (defaultValue != null) {
                    this.myBounds.defaultValue = defaultValue;
                }
            }
        }
        this.mySqlDialect = DatabaseDriverImpl.getOverride(config.getAttributeValue("dialect"), this.mySqlDialect, merge);
        this.myIconName = DatabaseDriverImpl.getOverride(config.getAttributeValue("icon"), this.myIconName, merge);
        if (!StringUtil.isEmpty((String)this.myIconName)) {
            ClassLoader loader = descriptor == null ? null : descriptor.getPluginClassLoader();
            this.myIcon = loader == null ? IconLoader.findIcon((String)this.myIconName) : IconLoader.findIcon((String)this.myIconName, (ClassLoader)loader);
        } else {
            Dbms dbms = DbImplUtil.getDbms(this);
            this.myIcon = dbms != Dbms.UNKNOWN ? dbms.getIcon() : null;
        }
        Element remarks = config.getChild("remarks");
        if (remarks != null) {
            this.myComment = remarks.getTextTrim();
        }
        ArrayList<UrlTemplate> templates = new ArrayList<UrlTemplate>();
        if (merge) {
            templates.addAll(this.myUrlTemplates);
        }
        for (Object element2 : config.getChildren("url-template")) {
            String name3 = DatabaseDriverImpl.getIfNotNull(element2.getAttributeValue("name"), "default");
            String template = DatabaseDriverImpl.getIfNotNull(element2.getAttributeValue("template"), element2.getValue());
            if (StringUtil.isEmpty((String)template)) continue;
            templates.add(new UrlTemplate(name3, template));
        }
        this.setURLTemplates(templates);
        if (!merge) {
            this.myVmEnv.clear();
        }
        if ((env = config.getChild("vm-env")) != null) {
            for (Element property : env.getChildren("property")) {
                this.myVmEnv.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        if ((vmOptionsElement = config.getChild("vm-options")) != null) {
            Element element3 = vmOptionsElement;
            this.myVmOptions = DatabaseDriverImpl.getOverride(element3.getTextTrim(), this.myVmOptions, merge);
        }
        if ((artifactElement = config.getChild("artifact")) != null) {
            Element element4 = artifactElement;
            String name4 = DatabaseDriverImpl.getOverride(element4.getAttributeValue("name"), this.myArtifactRef == null ? null : this.myArtifactRef.getName(), merge);
            String version = DatabaseDriverImpl.getOverride(element4.getAttributeValue("version"), this.myArtifactRef == null ? null : this.myArtifactRef.getVersion(), merge);
            String rolling = DatabaseDriverImpl.getOverride(element4.getAttributeValue("rolling"), this.myArtifactRef == null ? null : Boolean.toString(this.myArtifactRef.isRolling()), merge);
            this.myArtifactRef = ArtifactRefImpl.update(this.myArtifactRef, merge, name4, version, !Boolean.FALSE.toString().equals(rolling));
            if (this.myArtifactRef != null) {
                this.myArtifactRef.setUseArtifact(Boolean.TRUE.toString().equals(element4.getAttributeValue("use")));
                for (Element lib : element4.getChildren("library")) {
                    if (pathMacroManager != null) {
                        pathMacroManager.expandPaths(lib);
                    }
                    this.myArtifactRef.appendLegacy(SimpleClasspathElementFactory.createElements(null, (Element)lib));
                }
            }
        }
        if (!merge) {
            this.myOptions.clear();
        }
        for (Element element5 : config.getChildren("option")) {
            optionName = element5.getAttributeValue("name");
            String value = element5.getAttributeValue("value");
            DatabaseDriver.Option option = DatabaseDriver.Option.byName(optionName);
            if (option == null) continue;
            this.myOptions.put(option, value);
        }
        if (!merge) {
            this.myDriverProperties.clear();
        }
        for (Element element6 : config.getChildren("property")) {
            optionName = element6.getAttributeValue("name");
            if (StringUtil.isEmpty((String)optionName)) continue;
            this.myDriverProperties.put(optionName, element6.getAttributeValue("value"));
        }
        if (!merge) {
            this.myAdditionalClasspathElements.clear();
        }
        String downloadRoot = VfsUtilCore.pathToUrl((String)DatabaseDriverImpl.getDownloadPath());
        for (Element element7 : config.getChildren("library")) {
            ArrayList<SimpleClasspathElement> artifact = new ArrayList<SimpleClasspathElement>();
            ArrayList additional = new ArrayList();
            if (pathMacroManager != null) {
                pathMacroManager.expandPaths(element7);
            }
            for (SimpleClasspathElement e : SimpleClasspathElementFactory.createElements(null, (Element)element7)) {
                boolean downloaded = false;
                if (format < 163 && this.myArtifactRef != null) {
                    downloaded = true;
                    for (String root2 : e.getClassesRootUrls()) {
                        if (root2.startsWith(downloadRoot)) continue;
                        downloaded = false;
                        break;
                    }
                }
                (downloaded ? artifact : additional).add(e);
            }
            if (this.myArtifactRef != null && !artifact.isEmpty()) {
                this.myArtifactRef.appendLegacy(artifact);
            }
            this.myAdditionalClasspathElements.addAll(additional);
        }
        Element initScriptElement = config.getChild("init-script");
        if (initScriptElement != null) {
            this.myInitScript = DatabaseDriverImpl.getOverride(initScriptElement.getTextTrim(), this.myInitScript, merge);
        }
        if ((keepAliveQueryElement = config.getChild("keep-alive-query")) != null) {
            this.myKeepAliveQuery = DatabaseDriverImpl.getOverride(keepAliveQueryElement.getTextTrim(), this.myKeepAliveQuery, merge);
        }
    }

    public Element getState(@Nullable DatabaseDriver predef) {
        DatabaseDriver.Bounds preBounds;
        boolean allOptions;
        Element result2 = new Element("driver");
        result2.setAttribute("id", this.myId);
        boolean bl = allOptions = !this.myPredefined || predef == null;
        if (allOptions || !Comparing.equal((String)predef.getName(), (String)this.myName)) {
            result2.setAttribute("name", StringUtil.notNullize((String)this.myName));
        }
        if (this.mySqlDialect != null && (allOptions || !Comparing.equal((String)predef.getSqlDialect(), (String)this.mySqlDialect))) {
            result2.setAttribute("dialect", this.mySqlDialect);
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myDriverClass), (String)(predef == null ? null : predef.getDriverClass()))) {
            result2.setAttribute("driver-class", this.myDriverClass);
        }
        if (StringUtil.isNotEmpty((String)this.myJrePath)) {
            result2.setAttribute("jre-path", this.myJrePath);
        }
        if (allOptions && StringUtil.isNotEmpty((String)this.myIconName)) {
            result2.setAttribute("icon", this.myIconName);
        }
        if (!StringUtil.isEmpty((String)this.myComment)) {
            result2.addContent(new Element("remarks").addContent(this.myComment));
        }
        HashSet<UrlTemplate> predefTemplates = predef == null ? Collections.emptySet() : new HashSet<UrlTemplate>(((DatabaseDriverImpl)predef).myUrlTemplates);
        for (UrlTemplate template : this.myUrlTemplates) {
            if (predefTemplates.contains(template)) continue;
            Element element2 = new Element("url-template");
            element2.setAttribute("name", template.getName());
            element2.setAttribute("template", template.getTemplate());
            result2.addContent(element2);
        }
        DatabaseDriver.Bounds bounds = preBounds = predef == null ? null : predef.getConnectionBounds();
        if (!Comparing.equal((Object)this.myBounds, (Object)preBounds)) {
            Element bounds2 = new Element("connection-bounds");
            if (preBounds == null) {
                preBounds = new DatabaseDriver.Bounds();
            }
            if (!Comparing.equal((Object)this.myBounds.inReadOnlyMode, (Object)preBounds.inReadOnlyMode)) {
                bounds2.setAttribute("in-read-only", Boolean.toString(this.myBounds.inReadOnlyMode));
            }
            if (!Comparing.equal((Object)this.myBounds.boundTo, (Object)preBounds.boundTo)) {
                bounds2.setAttribute("bound-to", this.myBounds.boundTo.code());
            }
            if (!Comparing.equal(this.myBounds.rewriteParameters, preBounds.rewriteParameters)) {
                for (Pair<String, Boolean> pair : this.myBounds.rewriteParameters) {
                    Element param = new Element("rewrite-parameter");
                    param.setAttribute("name", (String)pair.first);
                    if (((Boolean)pair.second).booleanValue()) {
                        param.setAttribute("in-url", "true");
                    }
                    bounds2.addContent(param);
                }
            }
            if (!Comparing.equal((String)this.myBounds.defaultValue, (String)preBounds.defaultValue)) {
                bounds2.setAttribute("default-value", StringUtil.notNullize((String)this.myBounds.defaultValue));
            }
            result2.addContent(bounds2);
        }
        if (this.myArtifactRef != null) {
            Element artifactElement = new Element("artifact");
            artifactElement.setAttribute("name", this.myArtifactRef.getName());
            if (!this.myArtifactRef.isRolling()) {
                artifactElement.setAttribute("rolling", Boolean.FALSE.toString());
            }
            if (this.myArtifactRef.isUsed()) {
                artifactElement.setAttribute("use", Boolean.TRUE.toString());
            }
            if (this.myArtifactRef.getVersion() != null) {
                artifactElement.setAttribute("version", this.myArtifactRef.getVersion());
            } else {
                DatabaseDriverImpl.serializeClassPathElements(artifactElement, this.myArtifactRef.getElements());
            }
            result2.addContent(artifactElement);
        }
        for (DatabaseDriver.Option option : this.myOptions.keySet()) {
            if (!allOptions && option.isFixed()) continue;
            Element element3 = new Element("option");
            element3.setAttribute("name", option.getName());
            element3.setAttribute("value", this.myOptions.get(option));
            result2.addContent(element3);
        }
        if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
            Element e3 = new Element("vm-options");
            e3.setText(this.myVmOptions);
            result2.addContent(e3);
        }
        if (!this.myVmEnv.isEmpty()) {
            Element env = new Element("vm-env");
            for (String string : this.myVmEnv.keySet()) {
                Element prop = new Element("property");
                prop.setAttribute("name", string);
                prop.setAttribute("value", this.myVmEnv.get(string));
                env.addContent(prop);
            }
            result2.addContent(env);
        }
        Map<Object, Object> predefProps = predef == null ? Collections.emptyMap() : predef.getDriverProperties();
        for (Map.Entry<String, String> entry : this.myDriverProperties.entrySet()) {
            if (Comparing.equal((String)((String)predefProps.get(entry.getKey())), (String)entry.getValue())) continue;
            Element optionElement = new Element("property");
            optionElement.setAttribute("name", entry.getKey());
            optionElement.setAttribute("value", entry.getValue());
            result2.addContent(optionElement);
        }
        DatabaseDriverImpl.serializeClassPathElements(result2, this.myAdditionalClasspathElements);
        if (StringUtil.isNotEmpty((String)this.myInitScript)) {
            Element element4 = new Element("init-script");
            element4.setText(this.myInitScript);
            result2.addContent(element4);
        }
        if (StringUtil.isNotEmpty((String)this.myKeepAliveQuery)) {
            Element element5 = new Element("keep-alive-query");
            element5.setText(this.myKeepAliveQuery);
            result2.addContent(element5);
        }
        return result2;
    }

    private static void serializeClassPathElements(Element result2, List<SimpleClasspathElement> classpathElements) {
        for (SimpleClasspathElement cpe : classpathElements) {
            Element libraryElement = new Element("library");
            try {
                cpe.serialize(libraryElement);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            result2.addContent(libraryElement);
        }
    }

    private static String getIfNotNull(String value, String defaultValue) {
        return StringUtil.isEmpty((String)value) ? defaultValue : value;
    }

    private static String getOverride(String value, String oldValue, boolean merge) {
        return merge ? DatabaseDriverImpl.getIfNotNull(value, oldValue) : value;
    }

    public static boolean supportsGenericIntrospector(DatabaseDriver driver) {
        DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
        return artifact == null || !artifact.getName().equals("Cassandra");
    }

    public void setAdditionalClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myAdditionalClasspathElements.clear();
        this.myAdditionalClasspathElements.addAll(classpathElements);
    }

    @Override
    @NotNull
    public List<SimpleClasspathElement> getAdditionalClasspathElements() {
        List<SimpleClasspathElement> list = this.myAdditionalClasspathElements;
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public DatabaseDriverImpl copy(@Nullable String newName, boolean withId) {
        DatabaseDriverImpl result2 = new DatabaseDriverImpl(withId ? this.myId : null, (String)ObjectUtils.chooseNotNull((Object)newName, (Object)this.myName), null, null);
        result2.loadState(this.getState(null), false, false, Integer.MAX_VALUE);
        DatabaseDriverImpl databaseDriverImpl = result2;
        if (databaseDriverImpl == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(22);
        }
        return databaseDriverImpl;
    }

    public boolean equalConfiguration(DatabaseDriverImpl o, boolean ignoreClassPath) {
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myName), (String)StringUtil.nullize((String)o.myName))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (!Comparing.equal((Object)this.myArtifactRef, (Object)o.myArtifactRef)) {
            return false;
        }
        if (!ignoreClassPath && !this.myAdditionalClasspathElements.equals(o.myAdditionalClasspathElements)) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.mySqlDialect), (String)StringUtil.nullize((String)o.mySqlDialect))) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myDriverClass), (String)StringUtil.nullize((String)o.myDriverClass))) {
            return false;
        }
        if (!Comparing.equal((Object)this.myBounds, (Object)o.myBounds)) {
            return false;
        }
        if (!Comparing.equal((String)this.myJrePath, (String)o.myJrePath)) {
            return false;
        }
        if (!this.myDriverProperties.equals(o.myDriverProperties)) {
            return false;
        }
        for (DatabaseDriver.Option<?> option : DatabaseDriver.Option.enumerate()) {
            if (Comparing.equal(this.getOption(option), o.getOption(option))) continue;
            return false;
        }
        if (!this.myUrlTemplates.equals(o.myUrlTemplates)) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myVmOptions), (String)StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        if (!ContainerUtil.diff(this.myVmEnv, o.myVmEnv).isEmpty()) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myInitScript), (String)StringUtil.nullize((String)o.myInitScript))) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myKeepAliveQuery), (String)StringUtil.nullize((String)o.myKeepAliveQuery))) {
            return false;
        }
        return Comparing.equal((Object)this.myIcon, (Object)o.myIcon);
    }

    public boolean equalConfiguration(DatabaseDriverImpl o) {
        return this.equalConfiguration(o, false);
    }

    public String toString() {
        return DatabaseDriverImpl.class.getSimpleName() + "{myId='" + this.myId + '\'' + ", myName='" + this.myName + '\'' + '}';
    }

    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(23);
        }
        sb.append("Id - ").append(this.getId()).append("\n");
        sb.append("Name - ").append(this.getName()).append("\n");
        sb.append("DriverClass - ").append(this.getDriverClass()).append("\n");
        sb.append("Dialect - ").append(this.getSqlDialect()).append("\n");
        sb.append("IconName - ").append(this.myIconName).append("\n");
        sb.append("VmOptions - ").append(this.getVmOptions()).append("\n");
        sb.append("Predefined - ").append(this.isPredefined()).append("\n");
        sb.append("UrlTemplates").append("\n");
        for (UrlTemplate urlTemplate : this.getUrlTemplates()) {
            sb.append(" * ").append(urlTemplate.getName()).append(" - ").append(urlTemplate.getTemplate()).append("\n");
        }
        sb.append("DriverProperties").append("\n");
        for (Map.Entry entry : this.getDriverProperties().entrySet()) {
            sb.append(" * ").append((String)entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("Option").append("\n");
        for (Map.Entry entry : this.myOptions.entrySet()) {
            sb.append(" * ").append(entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("ArtifactName - ").append(this.getArtifactName()).append("\n");
        if (this.myArtifactRef != null) {
            for (SimpleClasspathElement simpleClasspathElement : this.myArtifactRef.getElements()) {
                sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
            }
        }
        sb.append("Bounds - ");
        if (this.myBounds != null) {
            sb.append("boundTo: ").append(this.myBounds.boundTo);
            sb.append("defaultValue: ").append(this.myBounds.defaultValue);
            sb.append("inReadOnlyMode: ").append(this.myBounds.inReadOnlyMode);
            sb.append("rewriteParameters:");
            for (Pair pair : this.myBounds.rewriteParameters) {
                sb.append(" ").append((String)pair.first);
                if (!((Boolean)pair.second).booleanValue()) continue;
                sb.append(":in-url");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n");
        sb.append("ClasspathElements").append("\n");
        for (SimpleClasspathElement simpleClasspathElement : this.getAdditionalClasspathElements()) {
            sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
        }
        if (StringUtil.isNotEmpty((String)this.myInitScript)) {
            sb.append("initScript: ").append(this.myInitScript).append("\n");
        }
    }

    @Nullable
    public static SqlLanguageDialect getLanguage(@Nullable DatabaseDriver driver) {
        if (driver == null || driver.getSqlDialect() == null) {
            return null;
        }
        return SqlDialects.findDialectById(driver.getSqlDialect());
    }

    @NotNull
    public List<SimpleClasspathElement> getArtifactClasspathElements() {
        List<SimpleClasspathElement> list = this.myArtifactRef == null ? Collections.emptyList() : this.myArtifactRef.getElements();
        if (list == null) {
            DatabaseDriverImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    public void setArtifact(@Nullable String name2, @Nullable String version, boolean rolling) {
        this.myArtifactRef = ArtifactRefImpl.update(this.myArtifactRef, true, name2, version, rolling);
    }

    public void setUseArtifact(boolean use) {
        if (this.myArtifactRef != null) {
            this.myArtifactRef.setUseArtifact(use);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmEnv";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParsers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesErrors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJDBCUrlParsers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLocations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlTemplates";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSampleUrl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmEnv";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalClasspathElements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactClasspathElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setURLTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchesUrl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Parsers {
        final List<StatelessJdbcUrlParser> jdbcUrlParsers = new ArrayList<StatelessJdbcUrlParser>();
        final EnumSet<StatelessJdbcUrlParser.LocationType> supportedLocations = EnumSet.noneOf(StatelessJdbcUrlParser.LocationType.class);
        final List<Pair<UrlTemplate, String>> templatesErrors = new ArrayList<Pair<UrlTemplate, String>>();

        Parsers(List<UrlTemplate> templates) {
            for (UrlTemplate template : templates) {
                try {
                    StatelessTextDecomposition decomposition = StatelessTextDecomposition.build(template.getTemplate(), TypesRegistry.INSTANCE);
                    this.jdbcUrlParsers.add(new StatelessTemplateJdbcUrlParser(template.getName(), decomposition));
                }
                catch (StatelessTextDecomposition.InvalidTemplateException e) {
                    Application application = ApplicationManager.getApplication();
                    if (application == null || application.isUnitTestMode()) {
                        throw new RuntimeException(e);
                    }
                    this.templatesErrors.add((Pair<UrlTemplate, String>)Pair.create((Object)template, (Object)e.getMessage()));
                }
            }
            for (StatelessJdbcUrlParser p2 : this.jdbcUrlParsers) {
                this.supportedLocations.addAll(p2.getPossibleLocations());
            }
        }
    }

    private static class ArtifactRefImpl
    implements DatabaseDriver.ArtifactRef {
        private Boolean myUseArtifact;
        private final boolean myRolling;
        private final String myName;
        private final String myVersion;
        private final List<SimpleClasspathElement> myLegacyElements;

        @Nullable
        public static ArtifactRefImpl create(@Nullable String name2, @Nullable String version, boolean rolling) {
            return StringUtil.isEmpty((String)name2) ? null : new ArtifactRefImpl(name2, version, rolling);
        }

        @Nullable
        public static ArtifactRefImpl update(@Nullable ArtifactRefImpl prev, boolean merge, @Nullable String name2, @Nullable String version, boolean rolling) {
            boolean changed;
            if (!merge) {
                return ArtifactRefImpl.create(name2, version, rolling);
            }
            boolean bl = changed = prev == null || !Comparing.equal((String)prev.getName(), (String)name2) || !Comparing.equal((String)prev.getVersion(), (String)version) || !Comparing.equal((Object)prev.isRolling(), (Object)rolling);
            if (!changed) {
                return prev;
            }
            ArtifactRefImpl res2 = ArtifactRefImpl.create(name2, version, rolling);
            if (res2 != null && prev != null) {
                if (version == null) {
                    res2.appendLegacy(prev.myLegacyElements);
                }
                if (prev.isUsed()) {
                    res2.setUseArtifact(true);
                }
            }
            return res2;
        }

        private ArtifactRefImpl(@NotNull String name2, @Nullable String version, boolean rolling) {
            if (name2 == null) {
                ArtifactRefImpl.$$$reportNull$$$0(0);
            }
            this.myUseArtifact = null;
            this.myLegacyElements = new ArrayList<SimpleClasspathElement>();
            if (DatabaseArtifactManager.isLatest(version)) {
                throw new AssertionError((Object)"Should be concrete version");
            }
            this.myName = name2;
            this.myVersion = version;
            this.myRolling = rolling;
        }

        @Override
        public boolean isUsed() {
            if (this.myUseArtifact == null) {
                return !this.myLegacyElements.isEmpty();
            }
            return this.myUseArtifact;
        }

        public void setUseArtifact(boolean useArtifact) {
            this.myUseArtifact = useArtifact;
        }

        public void appendLegacy(@NotNull List<SimpleClasspathElement> items) {
            if (items == null) {
                ArtifactRefImpl.$$$reportNull$$$0(1);
            }
            if (items.isEmpty()) {
                return;
            }
            this.myLegacyElements.addAll(items);
            if (this.myUseArtifact == null) {
                this.myUseArtifact = true;
            }
        }

        @NotNull
        public List<SimpleClasspathElement> getElements() {
            if (this.myVersion == null) {
                List<SimpleClasspathElement> list = this.myLegacyElements;
                if (list == null) {
                    ArtifactRefImpl.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<SimpleClasspathElement> list = DatabaseArtifactManager.getClasspathElements(this.myName, this.myVersion);
            if (list == null) {
                ArtifactRefImpl.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ArtifactRefImpl.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactRefImpl ref = (ArtifactRefImpl)o;
            if (this.myRolling != ref.myRolling) {
                return false;
            }
            if (!Comparing.equal((Object)this.isUsed(), (Object)ref.isUsed())) {
                return false;
            }
            if (!this.myName.equals(ref.myName)) {
                return false;
            }
            return Objects.equals(this.myVersion, ref.myVersion);
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isUsed());
            result2 = 31 * result2 + (this.myRolling ? 1 : 0);
            result2 = 31 * result2 + this.myName.hashCode();
            result2 = 31 * result2 + (this.myVersion != null ? this.myVersion.hashCode() : 0);
            return result2;
        }

        @Override
        @Nullable
        public String getVersion() {
            return this.myVersion;
        }

        @Override
        public boolean isRolling() {
            return this.myRolling;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "appendLegacy";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

