/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.SyncDateFormat;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DataSourceUiUtil {
    public static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceUiUtil");
    private static final SyncDateFormat ourTimestampFormat = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    public static final Map<String, ObjectKind> FILTER_BY_NAME = ContainerUtil.immutableMapBuilder().put((Object)"table", (Object)ObjectKind.TABLE).put((Object)"vtable", (Object)ObjectKind.VIRTUAL_TABLE).put((Object)"ftable", (Object)ObjectKind.FOREIGN_TABLE).put((Object)"view", (Object)ObjectKind.VIEW).put((Object)"mview", (Object)ObjectKind.MAT_VIEW).put((Object)"routine", (Object)ObjectKind.ROUTINE).put((Object)"aggregate", (Object)ObjectKind.AGGREGATE).put((Object)"package", (Object)ObjectKind.PACKAGE).put((Object)"sequence", (Object)ObjectKind.SEQUENCE).put((Object)"synonym", (Object)ObjectKind.SYNONYM).put((Object)"operator", (Object)ObjectKind.OPERATOR).put((Object)"collation", (Object)ObjectKind.COLLATION).put((Object)"role", (Object)ObjectKind.ROLE).put((Object)"user", (Object)ObjectKind.USER).put((Object)"fdw", (Object)ObjectKind.FOREIGN_DATA_WRAPPER).put((Object)"event", (Object)ObjectKind.SCHEDULED_EVENT).build();

    private DataSourceUiUtil() {
    }

    @NotNull
    public static <T extends EventListener, U extends T> EventDispatcher<U> eventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            DataSourceUiUtil.$$$reportNull$$$0(0);
        }
        EventDispatcher eventDispatcher = EventDispatcher.create(listenerClass);
        if (eventDispatcher == null) {
            DataSourceUiUtil.$$$reportNull$$$0(1);
        }
        return eventDispatcher;
    }

    @Nullable
    public static CompletionStage<DataSourceSyncManager.SyncResult> performAutoSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(2);
        }
        return DataSourceUiUtil.performAutoSyncTask(context, false);
    }

    @Nullable
    public static CompletionStage<DataSourceSyncManager.SyncResult> performAutoSyncTask(@NotNull LoaderContext context, boolean stopRunning) {
        LocalDataSource dataSource;
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(3);
        }
        if (!DbImplUtil.canConnectTo(dataSource = context.getDataSource()) || !dataSource.isAutoSynchronize()) {
            return null;
        }
        CompletionStage<DataSourceSyncManager.SyncResult> result2 = DataSourceSyncManager.getInstance().tryPerform(context, stopRunning, true);
        if (result2 == null) {
            return null;
        }
        result2.whenComplete((r, e) -> {
            if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e)) {
                DataSourceUiUtil.showNotification(context.getProject(), dataSource.getName(), "Cancelled", false);
            } else if (context.getErrorHandler().hasErrors()) {
                if (context.isOutdatedCheck()) {
                    DataSourceUiUtil.showOutdatedCheckErrorNotification(context, r == null ? 0L : r.elapsedTime);
                } else {
                    DataSourceUiUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
                }
            }
        });
        return result2;
    }

    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            DataSourceUiUtil.$$$reportNull$$$0(5);
        }
        DataSourceUiUtil.performAutoSyncTask(LoaderContext.loadAll(project, dataSource));
    }

    @NotNull
    public static LoaderContext getConnectionContext(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable ObjectPath path) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DataSourceUiUtil.$$$reportNull$$$0(7);
        }
        LoaderContext context = new LoaderContext(project, dataSource);
        if (JdbcUrlParserUtil.isDatabaseBounded(dataSource)) {
            if ((path = JdbcUrlParserUtil.toBound(dataSource, path)) == null) {
                context.include(ObjectPath.create((String)"@", (ObjectKind)ObjectKind.DATABASE));
            } else {
                context.include(path);
            }
        } else {
            context.includeAllSchemas();
        }
        LoaderContext loaderContext = context;
        if (loaderContext == null) {
            DataSourceUiUtil.$$$reportNull$$$0(8);
        }
        return loaderContext;
    }

    @NotNull
    public static CompletionStage<DataSourceSyncManager.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        CompletionStage<DataSourceSyncManager.SyncResult> result2;
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(9);
        }
        if ((result2 = DataSourceSyncManager.getInstance().tryPerform(context, true, true)) == null) {
            CompletableFuture<DataSourceSyncManager.SyncResult> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                DataSourceUiUtil.$$$reportNull$$$0(10);
            }
            return completableFuture;
        }
        CompletionStage<DataSourceSyncManager.SyncResult> completionStage = result2.whenComplete((r, e) -> {
            if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e)) {
                DataSourceUiUtil.showNotification(context.getProject(), context.getDataSource().getName(), "Cancelled", false);
            } else {
                DataSourceUiUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
            }
        });
        if (completionStage == null) {
            DataSourceUiUtil.$$$reportNull$$$0(11);
        }
        return completionStage;
    }

    @NotNull
    public static String formatDataSourceInfoString(LocalDataSource o) {
        Casing modes = o.getCaseModes();
        NameVersion databaseVersion = o.getDatabaseVersion();
        Dbms effectiveDbms = o.getDbms();
        Dbms actualDbms = Dbms.fromString((String)databaseVersion.name);
        Version effectiveVersion = o.getVersion();
        Version actualVersion = Version.parse((String)databaseVersion.version);
        boolean addEffectiveStr = effectiveDbms == actualDbms && (actualVersion != null && actualVersion.eqCoarse(effectiveVersion) || actualVersion == null && databaseVersion.version.contains(effectiveVersion.toString()));
        NameVersion driverVersion = o.getDriverVersion();
        String string = MessageFormat.format("DBMS: {0} (ver. {1})\nCase sensitivity: plain={5}, delimited={6}\nDriver: {2} (ver. {3}, JDBC{4}){7}", databaseVersion.name, databaseVersion.version, driverVersion.name, driverVersion.version, o.getJDBCVersion(), Case.LOWER.apply(modes.plain.name()), Case.LOWER.apply(modes.quoted.name()), addEffectiveStr ? "" : MessageFormat.format("\nEffective version: {0} (ver. {1})", effectiveDbms.getDisplayName(), effectiveVersion));
        if (string == null) {
            DataSourceUiUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean isMsSql2008(@Nullable Version version) {
        return version == null || version.isOrGreater(new int[]{10, 50});
    }

    public static void showNotification(@Nullable Project project, String title, String message2, boolean error2) {
        final Pair<String, HyperlinkListener> pair = DataSourceUiUtil.truncatePopupMessageIfNeeded(message2, error2 ? DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]) : title, error2 ? Messages.getErrorIcon() : Messages.getInformationIcon());
        NotificationGroup group2 = error2 ? DatabaseNotifications.DATABASE_VIEW_GROUP : DatabaseNotifications.DATABASE_VIEW_LOG_GROUP;
        group2.createNotification(title, (String)pair.first, error2 ? NotificationType.WARNING : NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((HyperlinkListener)pair.second).hyperlinkUpdate(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/DataSourceUiUtil$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    public static Pair<String, HyperlinkListener> truncatePopupMessageIfNeeded(String text2, final String dialogTitle, final Icon icon) {
        boolean truncate;
        boolean bl = truncate = text2.length() > 120;
        if (!truncate) {
            return Pair.create((Object)text2, null);
        }
        String balloonMessage = text2.substring(0, 120) + " ... <a href=\"more\">" + DatabaseMessages.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        final String message2 = text2.replace("\t", "  ");
        return Pair.create((Object)balloonMessage, (Object)new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "more".equals(e.getDescription())) {
                    Messages.showIdeaMessageDialog(null, (String)message2, (String)dialogTitle, (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)icon, null);
                }
            }
        });
    }

    public static void showErrorBalloon(Throwable error2, Component component, Point point, boolean showArrow, boolean showConfig) {
        if (!component.isVisible() || !component.isShowing()) {
            return;
        }
        String errorText = StringUtil.notNullize((String)error2.getMessage(), (String)error2.getClass().getSimpleName());
        errorText = DataSourceUiUtil.wrap(errorText, 50, "\n", true);
        errorText = StringUtil.trimLog((String)errorText, (int)200);
        errorText = StringUtil.trimTrailing((String)errorText);
        final String errorFullText = ExceptionUtil.getThrowableText((Throwable)error2, (String)"com.intellij.");
        String imgURL = DataSourceUiUtil.getIconUrl("/general/settings.png");
        String detailsLinkMessage = " <a href=\"more\">" + DatabaseMessages.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        String balloonContent = showConfig ? "<table border=0 cellspacing=0 cellpadding=0><tr valign=top><td>" + errorText + detailsLinkMessage + "</td><td align=right>&nbsp;&nbsp;<a href=\"config\"><img alt=\"Disable error balloons\" hspace=0 vspace=0 border=0 width=16 height=16 src=\"" + imgURL + "\"></a></td></tr></table>" : errorText + detailsLinkMessage;
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if ("more".equals(e.getDescription())) {
                        Messages.showIdeaMessageDialog(null, (String)errorFullText, (String)"Query Error", (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
                    } else if ("config".equals(e.getDescription())) {
                        ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)"");
                    }
                }
            }
        };
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonContent, MessageType.ERROR, hyperlinkListener).setClickHandler(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceUiUtil$4", "actionPerformed"));
            }
        }, true).setShowCallout(showArrow).setHideOnAction(true).setHideOnClickOutside(true);
        Balloon balloon = builder.createBalloon();
        balloon.show(new RelativePoint(component, point), Balloon.Position.below);
    }

    @Nullable
    public static String getIconUrl(String icon) {
        String imgURL = null;
        URL resource = AllIcons.class.getClassLoader().getResource(icon);
        try {
            imgURL = resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imgURL;
    }

    public static String wrap(@NotNull String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            DataSourceUiUtil.$$$reportNull$$$0(13);
        }
        if (newLineStr == null) {
            newLineStr = "\n";
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str, offset, wrapLength + offset);
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str, offset, spaceToWrapAt);
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    @NotNull
    public static String currentTime() {
        String string = "[" + ourTimestampFormat.format(new Date()) + "] ";
        if (string == null) {
            DataSourceUiUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable DasDataSource database) throws PatternSyntaxException {
        DasDataSource delegate = database instanceof DbElement ? ((DbElement)database).getDelegate() : database;
        String filterText = delegate instanceof LocalDataSource ? ((LocalDataSource)delegate).getObjectPattern() : null;
        Condition<DasObject> condition = DataSourceUiUtil.buildObjectFilter(filterText);
        if (condition == null) {
            DataSourceUiUtil.$$$reportNull$$$0(15);
        }
        return condition;
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable String filterText) throws PatternSyntaxException {
        if (StringUtil.isEmptyOrSpaces((String)filterText)) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                DataSourceUiUtil.$$$reportNull$$$0(16);
            }
            return condition;
        }
        THashMap builders = new THashMap();
        for (Object s : StringUtil.split((String)filterText, (String)"||")) {
            StringBuilder target2;
            ObjectKind kind;
            String string = ((String)s).trim();
            if (string.length() == 0) continue;
            int idx = string.indexOf(58);
            boolean exclude = string.charAt(idx + 1) == '-';
            String patternText = string.substring(idx + (exclude ? 2 : 1));
            if (idx < 0 || idx == string.length() - 1) {
                kind = ObjectKind.NONE;
            } else {
                String k = string.substring(0, idx);
                kind = (ObjectKind)ContainerUtil.getOrElse(FILTER_BY_NAME, (Object)k, (Object)ObjectKind.NONE);
                if (kind == ObjectKind.NONE) {
                    exclude = false;
                    patternText = string;
                }
            }
            Couple item = (Couple)builders.get(kind);
            if (item == null) {
                item = Couple.of((Object)new StringBuilder(), (Object)new StringBuilder());
                builders.put(kind, item);
            }
            StringBuilder stringBuilder = target2 = exclude ? (StringBuilder)item.second : (StringBuilder)item.first;
            if (target2.length() != 0) {
                target2.append("|");
            }
            target2.append(patternText);
        }
        THashMap map2 = new THashMap();
        for (Map.Entry entry : builders.entrySet()) {
            Couple v2 = (Couple)entry.getValue();
            map2.put(entry.getKey(), Conditions.and((Condition)((Condition)ObjectUtils.notNull(DataSourceUiUtil.makeCondition((CharSequence)v2.first), (Object)Conditions.alwaysTrue())), (Condition)Conditions.not((Condition)((Condition)ObjectUtils.notNull(DataSourceUiUtil.makeCondition((CharSequence)v2.second), (Object)Conditions.alwaysFalse())))));
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map2.entrySet());
        if (map2.size() == 1 && item != null && item.getKey() == ObjectKind.NONE) {
            Condition condition = Conditions.compose((Function)DasUtil.TO_NAME, (Condition)((Condition)item.getValue()));
            if (condition == null) {
                DataSourceUiUtil.$$$reportNull$$$0(17);
            }
            return condition;
        }
        Condition condition = arg_0 -> DataSourceUiUtil.lambda$buildObjectFilter$2((Map)map2, arg_0);
        if (condition == null) {
            DataSourceUiUtil.$$$reportNull$$$0(18);
        }
        return condition;
    }

    @Nullable
    public static Condition<String> makeCondition(CharSequence regex) {
        if (regex.length() == 0) {
            return null;
        }
        Pattern p2 = Pattern.compile(regex.toString(), 2);
        return s -> p2.matcher((CharSequence)s).matches();
    }

    public static void runAsyncWithCorrectModality(@NotNull Task.Backgroundable task) {
        if (task == null) {
            DataSourceUiUtil.$$$reportNull$$$0(19);
        }
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task), null, ModalityState.current());
    }

    public static void runSynchronously(@NotNull Task task) {
        ProgressIndicator indicator;
        if (task == null) {
            DataSourceUiUtil.$$$reportNull$$$0(20);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            task.run(indicator);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            if (indicator.isCanceled()) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
    }

    @NotNull
    public static JBPopup buildHiddenNamespacesPopup(@NotNull Project project, final @NotNull LocalDataSource dataSource, @Nullable BasicElement selection) {
        if (project == null) {
            DataSourceUiUtil.$$$reportNull$$$0(21);
        }
        if (dataSource == null) {
            DataSourceUiUtil.$$$reportNull$$$0(22);
        }
        final DataSourceScopeEditor editor = new DataSourceScopeEditor(project){

            @Override
            protected LocalDataSource getDataSource(boolean withCredentials) {
                return dataSource;
            }

            @Override
            @NotNull
            public DataSourceSchemaMapping getSchemaMapping() {
                TreePattern scope = this.getEditorState();
                this.mySchemaMapping.setIntrospectionScope(scope);
                DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
                if (dataSourceSchemaMapping == null) {
                    5.$$$reportNull$$$0(0);
                }
                return dataSourceSchemaMapping;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil$5", "getSchemaMapping"));
            }
        };
        editor.setInitialModel(dataSource, (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class));
        TreePattern pattern = dataSource.getIntrospectionScope();
        editor.setScopes(pattern, pattern);
        editor.setFakeCurrentSchema(dataSource.getFakeCurrentSchema());
        editor.setSchemaMapping(dataSource.getSchemaMapping());
        editor.select(selection);
        Ref notApply = Ref.create();
        final Ref popupRef = Ref.create();
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(editor.getComponent(), (JComponent)editor.getTree()).setMovable(true).setResizable(true).setRequestFocus(true).setDimensionServiceKey(project, "HiddenNamespacesPopup", false).setAdText("Press Enter or click outside the list to apply").setKeyEventHandler(event -> {
            if (event.getID() == 401) {
                if (event.getKeyCode() == 10) {
                    ((JBPopup)popupRef.get()).closeOk((InputEvent)event);
                    return true;
                }
                if (event.getKeyCode() == 27 && !editor.hasSpeedSearchActive()) {
                    notApply.set((Object)Boolean.TRUE);
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
            }
            return false;
        }).addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                ((AbstractPopup)popupRef.get()).setShowHints(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceUiUtil$6", "beforeShown"));
            }
        }).createPopup();
        popupRef.set((Object)popup);
        popup.setFinalRunnable(() -> {
            if (notApply.get() == Boolean.TRUE) {
                return;
            }
            Couple<String> fcs = editor.getFakeCurrentSchema();
            DataSourceSchemaMapping mapping = editor.getSchemaMapping();
            if (Comparing.equal(fcs, dataSource.getFakeCurrentSchema()) && Comparing.equal((Object)mapping, (Object)dataSource.getSchemaMapping())) {
                return;
            }
            @NotNull TreePattern oldScope = dataSource.getIntrospectionScope();
            dataSource.setFakeCurrentSchema(fcs);
            dataSource.getSchemaMapping().assign(mapping);
            DataSourceStorage.getProjectStorage(project).updateDataSource(dataSource);
            DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.scopeChange(new LoaderContext(project, dataSource), oldScope, dataSource.getIntrospectionScope()));
        });
        new UiNotifyConnector.Once((Component)editor.getComponent(), new Activatable(){

            public void showNotify() {
                editor.introspectIfEmpty();
            }

            public void hideNotify() {
            }
        });
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            DataSourceUiUtil.$$$reportNull$$$0(23);
        }
        return jBPopup;
    }

    public static LoaderContext scopeChange(@NotNull LoaderContext context, @NotNull TreePattern oldScope, @NotNull TreePattern newScope) {
        TreePattern diff;
        if (context == null) {
            DataSourceUiUtil.$$$reportNull$$$0(24);
        }
        if (oldScope == null) {
            DataSourceUiUtil.$$$reportNull$$$0(25);
        }
        if (newScope == null) {
            DataSourceUiUtil.$$$reportNull$$$0(26);
        }
        if (!(diff = TreePatternUtils.diff(oldScope, newScope)).isEmpty()) {
            context.include(diff);
        }
        return context;
    }

    public static boolean setNamespacesVisible(Project project, LocalDataSource dataSource, Iterable<? extends BasicNamespace> selectedValues, boolean visible) {
        return DataSourceUiUtil.setPathsVisible(project, dataSource, (Iterable<ObjectPath>)JBIterable.from(selectedValues).map(nsp -> ObjectPaths.of(nsp)), visible);
    }

    public static boolean setPathsVisible(Project project, LocalDataSource dataSource, Iterable<ObjectPath> paths, boolean visible) {
        TreePattern newScope;
        TreePattern objects2 = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(paths).map(nsp -> TreePatternUtils.create(nsp)));
        TreePattern scope = dataSource.getIntrospectionScope();
        TreePattern treePattern = newScope = visible ? TreePatternUtils.union(scope, objects2) : TreePatternUtils.minus(scope, objects2);
        if (scope.equals(newScope)) {
            return false;
        }
        dataSource.setIntrospectionScope(newScope);
        if (dataSource.isGlobal()) {
            DataSourceStorage.getStorage().updateDataSource(dataSource);
        } else {
            DataSourceStorage.getProjectStorage(project).updateDataSource(dataSource);
        }
        return true;
    }

    public static void showNotification(LoaderContext context, long elapsedTime) {
        boolean isError = context.getErrorHandler().hasErrors();
        String message2 = StringUtil.notNullize((String)StringUtil.nullize((String)DataSourceUiUtil.computeMessage(context)), (String)"Connection successful");
        DataSourceUiUtil.showNotification(context.getProject(), context.getDataSource().getName(), message2 + DataSourceUiUtil.getElapsedString(elapsedTime), isError);
    }

    private static void showOutdatedCheckErrorNotification(final LoaderContext context, long elapsedTime) {
        String message2 = DataSourceUiUtil.computeMessage(context);
        String title = context.getDataSource().getName();
        final Pair<String, HyperlinkListener> pair = DataSourceUiUtil.truncatePopupMessageIfNeeded(message2 + DataSourceUiUtil.getElapsedString(elapsedTime), DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]), Messages.getErrorIcon());
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, (String)pair.first + "<br>You can <a href=\"disable\">disable outdated object notification</a>", NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    8.$$$reportNull$$$0(1);
                }
                ((HyperlinkListener)pair.second).hyperlinkUpdate(event);
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "disable".equals(event.getDescription())) {
                    context.getDataSource().setCheckOutdated(false);
                    DataSourceStorage.getProjectStorage(context.getProject()).updateDataSource(context.getDataSource());
                    notification.expire();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/DataSourceUiUtil$8";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(context.getProject());
    }

    @NotNull
    protected static String computeMessage(LoaderContext context) {
        boolean isError = context.getErrorHandler().hasErrors();
        String summary = context.getErrorHandler().getSummary();
        if (isError) {
            String string = DataSourceUiUtil.escapeAngleBrackets(summary);
            if (string == null) {
                DataSourceUiUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        if (context.hasSelection()) {
            List objects2 = JBIterable.from(context.getSelection()).filter(Conditions.notInstanceOf(Class.class)).toList();
            int size = objects2.size();
            Object item = ContainerUtil.getFirstItem((Collection)objects2);
            String itemName = item instanceof String ? (String)item : (item instanceof DasObject ? ((DasObject)item).getName() : null);
            String string = size == 1 && !StringUtil.isEmptyOrSpaces((String)itemName) ? itemName + " synchronized" : "Synchronization successful";
            if (string == null) {
                DataSourceUiUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = DataSourceUiUtil.formatDataSourceInfoString(context.getDataSource()) + "\n\nConnection successful";
        if (string == null) {
            DataSourceUiUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static String escapeAngleBrackets(String message2) {
        return message2.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    protected static String getElapsedString(long elapsedTime) {
        return elapsedTime > 1L ? " (" + StringUtil.formatDuration((long)elapsedTime) + ")" : "";
    }

    @NotNull
    public static Promise<?> promiseFacadeUpdate(@NotNull DbPsiFacade facade, @Nullable Disposable parent2) {
        if (facade == null) {
            DataSourceUiUtil.$$$reportNull$$$0(30);
        }
        AsyncPromise p2 = new AsyncPromise();
        Disposable listenerDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)ObjectUtils.notNull((Object)parent2, (Object)facade.getProject())), (Disposable)listenerDisposable);
        facade.addModificationTrackerListener(o -> {
            Disposer.dispose((Disposable)listenerDisposable);
            p2.setResult(null);
        }, listenerDisposable);
        AsyncPromise asyncPromise = p2;
        if (asyncPromise == null) {
            DataSourceUiUtil.$$$reportNull$$$0(31);
        }
        return asyncPromise;
    }

    public static DatabaseDriver createDefaultDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> existing) {
        if (existing == null) {
            DataSourceUiUtil.$$$reportNull$$$0(32);
        }
        Set names = (Set)JBIterable.from(existing).map(DatabaseDriver::getName).addAllTo((Collection)new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
        return DatabaseDriverManager.getInstance().createDriver(DbUtil.generateUniqueName((String)"User Driver", (Set)names), "java.sql.Driver", null);
    }

    public static void showTroubleshooting() {
        HelpManager.getInstance().invokeHelp("Connectivity_problems");
    }

    private static /* synthetic */ boolean lambda$buildObjectFilter$2(Map map2, DasObject object) {
        Condition c2 = (Condition)map2.get(object.getKind());
        return c2 == null || c2.value((Object)object.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceUiUtil";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldScope";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScope";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceUiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "eventDispatcher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDataSourceInfoString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "currentTime";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildObjectFilter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHiddenNamespacesPopup";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMessage";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseFacadeUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "eventDispatcher";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionContext";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncWithCorrectModality";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runSynchronously";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildHiddenNamespacesPopup";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "scopeChange";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "promiseFacadeUpdate";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultDatabaseDriver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DbGroupDropTarget
    implements DnDTarget {
        private final String myGroupName;

        public DbGroupDropTarget(@NotNull String groupName) {
            if (groupName == null) {
                DbGroupDropTarget.$$$reportNull$$$0(0);
            }
            this.myGroupName = groupName;
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }

        public void drop(DnDEvent event) {
            List dataSources2 = DbGroupDropTarget.getDataSources(event).toList();
            DbDataSource first2 = (DbDataSource)ContainerUtil.getFirstItem((Collection)dataSources2);
            if (first2 == null) {
                return;
            }
            for (DbDataSource dataSource : dataSources2) {
                ((AbstractDataSource)dataSource.getDelegate()).setGroupName(this.myGroupName);
            }
            DatabaseView.refreshViewAndSelect(first2.getProject(), dataSources2);
        }

        public boolean update(DnDEvent event) {
            return DbGroupDropTarget.getDataSources(event).isNotEmpty();
        }

        @NotNull
        private static JBIterable<DbDataSource> getDataSources(DnDEvent event) {
            block4: {
                JBIterable jBIterable;
                try {
                    JBIterable result2;
                    Object data = event.getTransferData(DnDEventImpl.ourDataFlavor);
                    if (!(data instanceof Object[]) || !(result2 = JBIterable.of((Object[])((Object[])data))).filter(o -> !(o instanceof DbDataSource)).isEmpty()) break block4;
                    jBIterable = result2.filter(DbDataSource.class);
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
                if (jBIterable == null) {
                    DbGroupDropTarget.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbGroupDropTarget.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceUiUtil$DbGroupDropTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceUiUtil$DbGroupDropTarget";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

