/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.RunSqlScriptAction;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportFromSqlAction
extends DumbAwareAction {
    private static final List<ObjectKind> GENERIC_KINDS = Arrays.asList(ObjectKind.ROOT, ObjectKind.DATABASE, ObjectKind.SCHEMA);

    public void update(@NotNull AnActionEvent e) {
        JBIterable dataSource;
        JBIterable<DbElement> elements;
        if (e == null) {
            ImportFromSqlAction.$$$reportNull$$$0(0);
        }
        if ((elements = DatabaseView.getSelectedElements(e.getDataContext(), true)).processEach(ImportFromSqlAction::isSuitableElement) && (dataSource = elements.map(DbElement::getDataSource).unique()).processEach(DbImplUtil::canConnectToAndModify)) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    private static boolean isSuitableElement(@NotNull DbElement element2) {
        if (element2 == null) {
            ImportFromSqlAction.$$$reportNull$$$0(1);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element2);
        ObjectKind searchPathObjectKind = dialect.getSearchPathObjectKind();
        MetaModel model = DbImplUtil.getMetaModel(element2);
        ObjectKind kind = element2.getKind();
        return searchPathObjectKind == null && GENERIC_KINDS.contains(kind) || ImportFromSqlAction.isOnTheWayFromRootToSearchPathObject(model, searchPathObjectKind, kind);
    }

    private static boolean isOnTheWayFromRootToSearchPathObject(@NotNull MetaModel model, @Nullable ObjectKind searchPathObjectKind, @NotNull ObjectKind elementKind) {
        if (model == null) {
            ImportFromSqlAction.$$$reportNull$$$0(2);
        }
        if (elementKind == null) {
            ImportFromSqlAction.$$$reportNull$$$0(3);
        }
        if (searchPathObjectKind == null) {
            return false;
        }
        List path = (List)model.getPathsToRoot(searchPathObjectKind).first();
        return path != null && path.contains(elementKind);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportFromSqlAction.$$$reportNull$$$0(4);
        }
        JBIterable<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), true);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FileDocumentManager.getInstance().saveAllDocuments();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null, files -> {
            List paths = elements.map(it2 -> {
                LocalDataSource dataSource = DbImplUtil.getLocalDataSource((DasDataSource)it2.getDataSource());
                Object delegate = it2.getDelegate();
                return RunSqlScriptAction.makeTargetPair(dataSource, delegate);
            }).filter(Conditions.notNull()).toList();
            List result2 = JBIterable.from((Iterable)paths).filter(it2 -> !ContainerUtil.exists((Iterable)paths, pair -> ImportFromSqlAction.isAncestor((Pair<LocalDataSource, ObjectPath>)it2, (Pair<LocalDataSource, ObjectPath>)pair))).toList();
            RunSqlScriptAction.perform(project, (JBIterable<VirtualFile>)JBIterable.from((Iterable)files), result2);
        });
    }

    private static boolean isAncestor(@NotNull Pair<LocalDataSource, ObjectPath> possibleAncestor, @NotNull Pair<LocalDataSource, ObjectPath> possibleChild) {
        if (possibleAncestor == null) {
            ImportFromSqlAction.$$$reportNull$$$0(5);
        }
        if (possibleChild == null) {
            ImportFromSqlAction.$$$reportNull$$$0(6);
        }
        ObjectPath ancestorPath = (ObjectPath)possibleAncestor.second;
        ObjectPath childPath = (ObjectPath)possibleChild.second;
        if (childPath == null) {
            return false;
        }
        if (ancestorPath == null) {
            return possibleAncestor.first == possibleChild.first;
        }
        return ancestorPath.isAncestorOf(childPath, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementKind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleAncestor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleChild";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/ImportFromSqlAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isOnTheWayFromRootToSearchPathObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAncestor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

