/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IntIntFunction;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a$\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u00a8\u0006\u0016"}, d2={"containsAll", "", "Lcom/intellij/vcs/log/data/DataPack;", "commits", "", "Lcom/intellij/vcs/log/CommitId;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "findBranch", "Lcom/intellij/vcs/log/VcsRef;", "Lcom/intellij/vcs/log/data/RefsModel;", "name", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "subgraphDifference", "Lgnu/trove/TIntHashSet;", "withRef", "withoutRef", "withRefIndex", "", "withoutRefIndex", "intellij.platform.vcs.log.impl"})
public final class DataPackUtilKt {
    @Nullable
    public static final VcsRef findBranch(@NotNull RefsModel $this$findBranch, @NotNull String name, @NotNull VirtualFile root) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findBranch, (String)"$this$findBranch");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        return VcsLogUtil.findBranch($this$findBranch, root, name);
    }

    @Nullable
    public static final TIntHashSet subgraphDifference(@NotNull DataPack $this$subgraphDifference, @NotNull VcsRef withRef, @NotNull VcsRef withoutRef, @NotNull VcsLogStorage storage) {
        Intrinsics.checkParameterIsNotNull((Object)$this$subgraphDifference, (String)"$this$subgraphDifference");
        Intrinsics.checkParameterIsNotNull((Object)withRef, (String)"withRef");
        Intrinsics.checkParameterIsNotNull((Object)withoutRef, (String)"withoutRef");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        if (Intrinsics.areEqual((Object)withoutRef.getRoot(), (Object)withRef.getRoot()) ^ true) {
            return null;
        }
        int withRefIndex = storage.getCommitIndex(withRef.getCommitHash(), withRef.getRoot());
        int withoutRefIndex = storage.getCommitIndex(withoutRef.getCommitHash(), withoutRef.getRoot());
        return DataPackUtilKt.subgraphDifference($this$subgraphDifference, withRefIndex, withoutRefIndex);
    }

    @Nullable
    public static final TIntHashSet subgraphDifference(@NotNull DataPack $this$subgraphDifference, int withRefIndex, int withoutRefIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$this$subgraphDifference, (String)"$this$subgraphDifference");
        if (withRefIndex == withoutRefIndex) {
            return new TIntHashSet();
        }
        PermanentGraph<Integer> permanentGraph = $this$subgraphDifference.getPermanentGraph();
        if (!(permanentGraph instanceof PermanentGraphInfo)) {
            permanentGraph = null;
        }
        PermanentGraphInfo permanentGraphInfo = (PermanentGraphInfo)permanentGraph;
        if (permanentGraphInfo == null) {
            return null;
        }
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        int withRefNode = permanentGraphInfo2.getPermanentCommitsInfo().getNodeId(withRefIndex);
        int withoutRefNode = permanentGraphInfo2.getPermanentCommitsInfo().getNodeId(withoutRefIndex);
        if (withRefNode < 0 || withoutRefNode < 0) {
            return null;
        }
        LinearGraph linearGraph = permanentGraphInfo2.getLinearGraph();
        Intrinsics.checkExpressionValueIsNotNull((Object)linearGraph, (String)"permanentGraphInfo.linearGraph");
        TIntHashSet withRefNodeIds = GraphUtilKt.subgraphDifference(linearGraph, withRefNode, withoutRefNode);
        return TroveUtil.map2IntSet(withRefNodeIds, new IntIntFunction(permanentGraphInfo2){
            final /* synthetic */ PermanentGraphInfo $permanentGraphInfo;

            @NotNull
            public final Integer fun(int it) {
                CommitId CommitId2 = this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(it);
                Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"permanentGraphInfo.perma\u2026mmitsInfo.getCommitId(it)");
                return (Integer)CommitId2;
            }
            {
                this.$permanentGraphInfo = permanentGraphInfo;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean containsAll(@NotNull DataPack $this$containsAll, @NotNull Collection<? extends CommitId> commits, @NotNull VcsLogStorage storage) {
        boolean bl;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$containsAll, (String)"$this$containsAll");
        Intrinsics.checkParameterIsNotNull(commits, (String)"commits");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Iterable $this$map$iv = commits;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CommitId commitId = (CommitId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Integer n = storage.getCommitIndex(it.getHash(), it.getRoot());
            collection.add(n);
        }
        List commitIds2 = (List)destination$iv$iv;
        PermanentGraph<Integer> permanentGraph = $this$containsAll.getPermanentGraph();
        if (!(permanentGraph instanceof PermanentGraphInfo)) {
            permanentGraph = null;
        }
        PermanentGraphInfo permanentGraphInfo = (PermanentGraphInfo)permanentGraph;
        if (permanentGraphInfo == null) return false;
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        if (permanentGraphInfo2.getPermanentCommitsInfo() instanceof PermanentCommitsInfoImpl) {
            PermanentCommitsInfo permanentCommitsInfo = permanentGraphInfo2.getPermanentCommitsInfo();
            if (permanentCommitsInfo != null) return ((PermanentCommitsInfoImpl)permanentCommitsInfo).containsAll(commitIds2);
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl<kotlin.Int>");
        }
        Set<Integer> set = permanentGraphInfo2.getPermanentCommitsInfo().convertToNodeIds(commitIds2);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"permanentGraphInfo.perma\u2026nvertToNodeIds(commitIds)");
        Set<Integer> nodeIds = set;
        if (nodeIds.size() != commits.size()) return false;
        Iterable $this$all$iv = nodeIds;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Integer it = (Integer)element$iv;
            boolean bl3 = false;
            if (Intrinsics.compare((int)it, (int)0) < 0) return false;
            bl = true;
        } while (bl);
        return false;
    }
}

