/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.MapBasedForwardIndex;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFullDetailsIndex<T, D>
implements Disposable {
    protected static final String INDEX = "index";
    @NotNull
    protected final MyMapReduceIndex myMapReduceIndex;
    @NotNull
    protected final StorageId myStorageId;
    @NotNull
    protected final String myName;
    @NotNull
    protected final DataIndexer<Integer, T, D> myIndexer;
    @NotNull
    private final FatalErrorHandler myFatalErrorHandler;
    private volatile boolean myDisposed;

    public VcsLogFullDetailsIndex(@NotNull StorageId storageId, @NotNull String name, @NotNull DataIndexer<Integer, T, D> indexer, @NotNull DataExternalizer<T> externalizer, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(0);
        }
        if (name == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(1);
        }
        if (indexer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(2);
        }
        if (externalizer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(3);
        }
        if (fatalErrorHandler == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(4);
        }
        if (disposableParent == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(5);
        }
        this.myDisposed = false;
        this.myName = name;
        this.myStorageId = storageId;
        this.myIndexer = indexer;
        this.myFatalErrorHandler = fatalErrorHandler;
        this.myMapReduceIndex = this.createMapReduceIndex(externalizer);
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    @NotNull
    private MyMapReduceIndex createMapReduceIndex(@NotNull DataExternalizer<T> dataExternalizer) throws IOException {
        if (dataExternalizer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(6);
        }
        MyIndexExtension<T, D> extension = new MyIndexExtension<T, D>(this.myName, this.myIndexer, dataExternalizer, this.myStorageId.getVersion());
        ForwardIndex<Integer, T> forwardIndex = this.createForwardIndex(extension);
        MyMapReduceIndex myMapReduceIndex = new MyMapReduceIndex(extension, new MyMapIndexStorage<T>(this.myName, this.myStorageId, dataExternalizer), forwardIndex);
        if (myMapReduceIndex == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(7);
        }
        return myMapReduceIndex;
    }

    @Nullable
    protected ForwardIndex<Integer, T> createForwardIndex(@NotNull IndexExtension<Integer, T, D> extension) throws IOException {
        if (extension == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    public TIntHashSet getCommitsWithAnyKey(@NotNull Set<Integer> keys) throws StorageException {
        if (keys == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(9);
        }
        this.checkDisposed();
        TIntHashSet result2 = new TIntHashSet();
        for (Integer key : keys) {
            this.iterateCommitIds(key, (Consumer<Integer>)((Consumer)arg_0 -> ((TIntHashSet)result2).add(arg_0)));
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(10);
        }
        return tIntHashSet;
    }

    @NotNull
    public TIntHashSet getCommitsWithAllKeys(@NotNull Collection<Integer> keys) throws StorageException {
        if (keys == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(11);
        }
        this.checkDisposed();
        TIntHashSet tIntHashSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myMapReduceIndex, keys, k -> {
            ProgressManager.checkCanceled();
            return true;
        }, null, null);
        if (tIntHashSet == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(12);
        }
        return tIntHashSet;
    }

    private void iterateCommitIds(int key, @NotNull Consumer<Integer> consumer) throws StorageException {
        if (consumer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(13);
        }
        ValueContainer data = this.myMapReduceIndex.getData(key);
        data.forEach((id, value) -> {
            consumer.consume((Object)id);
            return true;
        });
    }

    protected void iterateCommitIdsAndValues(int key, @NotNull ObjIntConsumer<? super T> consumer) throws StorageException {
        if (consumer == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(14);
        }
        this.myMapReduceIndex.getData(key).forEach((id, value) -> {
            consumer.accept(value, id);
            return true;
        });
    }

    @Nullable
    protected <MapIndexType> MapIndexType getKeysForCommit(int commit2) throws IOException {
        MapBasedForwardIndex index = this.myMapReduceIndex.getForwardIndex();
        if (index == null) {
            return null;
        }
        return (MapIndexType)index.getInput(commit2);
    }

    public void update(int commitId, @NotNull D details) {
        if (details == null) {
            VcsLogFullDetailsIndex.$$$reportNull$$$0(15);
        }
        this.checkDisposed();
        this.myMapReduceIndex.update(commitId, details).compute();
    }

    public void flush() throws StorageException {
        this.checkDisposed();
        this.myMapReduceIndex.flush();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myMapReduceIndex.dispose();
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataExternalizer";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMapReduceIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsWithAnyKey";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitsWithAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMapReduceIndex";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createForwardIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsWithAnyKey";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommitsWithAllKeys";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommitIds";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommitIdsAndValues";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyIndexExtension<T, D>
    extends IndexExtension<Integer, T, D> {
        @NotNull
        private final IndexId<Integer, T> myID;
        @NotNull
        private final DataIndexer<Integer, T, D> myIndexer;
        @NotNull
        private final DataExternalizer<T> myExternalizer;
        private final int myVersion;

        MyIndexExtension(@NotNull String name, @NotNull DataIndexer<Integer, T, D> indexer, @NotNull DataExternalizer<T> externalizer, int version) {
            if (name == null) {
                MyIndexExtension.$$$reportNull$$$0(0);
            }
            if (indexer == null) {
                MyIndexExtension.$$$reportNull$$$0(1);
            }
            if (externalizer == null) {
                MyIndexExtension.$$$reportNull$$$0(2);
            }
            this.myID = IndexId.create((String)name);
            this.myIndexer = indexer;
            this.myExternalizer = externalizer;
            this.myVersion = version;
        }

        @NotNull
        public IndexId<Integer, T> getName() {
            IndexId<Integer, T> indexId = this.myID;
            if (indexId == null) {
                MyIndexExtension.$$$reportNull$$$0(3);
            }
            return indexId;
        }

        @NotNull
        public DataIndexer<Integer, T, D> getIndexer() {
            DataIndexer<Integer, T, D> dataIndexer = this.myIndexer;
            if (dataIndexer == null) {
                MyIndexExtension.$$$reportNull$$$0(4);
            }
            return dataIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
            if (enumeratorIntegerDescriptor == null) {
                MyIndexExtension.$$$reportNull$$$0(5);
            }
            return enumeratorIntegerDescriptor;
        }

        @NotNull
        public DataExternalizer<T> getValueExternalizer() {
            DataExternalizer<T> dataExternalizer = this.myExternalizer;
            if (dataExternalizer == null) {
                MyIndexExtension.$$$reportNull$$$0(6);
            }
            return dataExternalizer;
        }

        public int getVersion() {
            return this.myVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalizer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyIndexExtension";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyDescriptor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueExternalizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyMapIndexStorage<T>
    extends MapIndexStorage<Integer, T> {
        MyMapIndexStorage(@NotNull String name, @NotNull StorageId storageId, @NotNull DataExternalizer<T> externalizer) throws IOException {
            if (name == null) {
                MyMapIndexStorage.$$$reportNull$$$0(0);
            }
            if (storageId == null) {
                MyMapIndexStorage.$$$reportNull$$$0(1);
            }
            if (externalizer == null) {
                MyMapIndexStorage.$$$reportNull$$$0(2);
            }
            super(storageId.getStorageFile(name, true), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, externalizer, 5000, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "storageId";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "externalizer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapIndexStorage";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMapReduceIndex
    extends MapReduceIndex<Integer, T, D> {
        MyMapReduceIndex(@NotNull MyIndexExtension<T, D> extension, @Nullable MyMapIndexStorage<T> mapIndexStorage, ForwardIndex<Integer, T> forwardIndex) {
            if (extension == null) {
                MyMapReduceIndex.$$$reportNull$$$0(0);
            }
            if (mapIndexStorage == null) {
                MyMapReduceIndex.$$$reportNull$$$0(1);
            }
            super(extension, mapIndexStorage, forwardIndex);
        }

        @Nullable
        public <MapIndexType> MapBasedForwardIndex<Integer, T, MapIndexType> getForwardIndex() {
            if (this.myForwardIndex instanceof MapBasedForwardIndex) {
                return (MapBasedForwardIndex)this.myForwardIndex;
            }
            return null;
        }

        public void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        public void requestRebuild(@NotNull Throwable ex) {
            if (ex == null) {
                MyMapReduceIndex.$$$reportNull$$$0(2);
            }
            VcsLogFullDetailsIndex.this.myFatalErrorHandler.consume((Object)this, ex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapIndexStorage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ex";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogFullDetailsIndex$MyMapReduceIndex";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestRebuild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

