/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ProjectExcludesIgnoredFileProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "()V", "getIgnoredFiles", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getIgnoredGroupDescription", "", "getProjectExcludePaths", "isIgnoredFile", "", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
public final class ProjectExcludesIgnoredFileProvider
implements IgnoredFileProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        if (!VcsApplicationSettings.getInstance().MARK_EXCLUDED_AS_IGNORED) return false;
        if (Registry.is((String)"ide.hide.excluded.files")) return false;
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) return false;
        VirtualFile virtualFile2 = virtualFile;
        boolean bl = false;
        boolean bl2 = false;
        VirtualFile file = virtualFile2;
        boolean bl3 = false;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        if (!projectFileIndex2.isExcluded(file)) return false;
        if (projectFileIndex2.isUnderIgnored(file)) return false;
        return true;
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getProjectExcludePaths(project);
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        return "Project exclude paths";
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IgnoredFileDescriptor> getProjectExcludePaths(Project project) {
        void $this$mapTo$iv$iv;
        int n;
        if (!VcsApplicationSettings.getInstance().MARK_EXCLUDED_AS_IGNORED) {
            return SetsKt.emptySet();
        }
        Comparator<VirtualFile> comparator = ChangesComparator.getVirtualFileComparator(false);
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"ChangesComparator.getVirtualFileComparator(false)");
        TreeSet excludes = SetsKt.sortedSetOf(comparator, (Object[])new VirtualFile[0]);
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Object object = (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project);
        int n2 = ((DirectoryIndexExcludePolicy[])object).length;
        for (n = 0; n < n2; ++n) {
            DirectoryIndexExcludePolicy policy;
            DirectoryIndexExcludePolicy directoryIndexExcludePolicy = policy = object[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryIndexExcludePolicy, (String)"policy");
            for (String string : directoryIndexExcludePolicy.getExcludeUrlsForProject()) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(string);
                if (file == null) continue;
                excludes.add(file);
            }
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        object = moduleManager.getModules();
        n2 = ((DirectoryIndexExcludePolicy[])object).length;
        for (n = 0; n < n2; ++n) {
            DirectoryIndexExcludePolicy module;
            DirectoryIndexExcludePolicy directoryIndexExcludePolicy = module = object[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryIndexExcludePolicy, (String)"module");
            if (directoryIndexExcludePolicy.isDisposed()) continue;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            for (String string : moduleRootManager.getExcludeRoots()) {
                if (!fileIndex.isExcluded((VirtualFile)string)) continue;
                excludes.add(string);
            }
        }
        Iterable $this$map$iv = excludes;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IgnoredFileBean ignoredFileBean = IgnoredBeanFactory.ignoreFile((VirtualFile)file, (Project)project);
            collection.add(ignoredFileBean);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

