/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.diff.util.Side;
import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PathDescription;
import com.intellij.openapi.diff.impl.patch.StaticPathDescription;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaTextPatchBuilder {
    private IdeaTextPatchBuilder() {
    }

    private static List<BeforeAfter<AirContentRevision>> revisionsConvertor(@NotNull Project project, @NotNull List<? extends Change> changes2, boolean honorExcludedFromCommit) throws VcsException {
        if (project == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(0);
        }
        if (changes2 == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<BeforeAfter<AirContentRevision>> result2 = new ArrayList<BeforeAfter<AirContentRevision>>(changes2.size());
        Map byRoots = VcsUtil.groupByRoots((Project)project, changes2, change -> (FilePath)ObjectUtils.chooseNotNull((Object)ChangesUtil.getBeforePath((Change)change), (Object)ChangesUtil.getAfterPath((Change)change)));
        for (VcsRoot root : byRoots.keySet()) {
            Collection rootChanges = (Collection)byRoots.get(root);
            if (root.getVcs() == null || root.getVcs().getOutgoingChangesProvider() == null) {
                IdeaTextPatchBuilder.addConvertChanges(project, rootChanges, result2, null, honorExcludedFromCommit);
                continue;
            }
            VcsOutgoingChangesProvider provider = root.getVcs().getOutgoingChangesProvider();
            Collection basedOnLocal = provider.filterLocalChangesBasedOnLocalCommits(rootChanges, root.getPath());
            rootChanges.removeAll(basedOnLocal);
            IdeaTextPatchBuilder.addConvertChanges(project, rootChanges, result2, null, honorExcludedFromCommit);
            IdeaTextPatchBuilder.addConvertChanges(project, basedOnLocal, result2, provider, honorExcludedFromCommit);
        }
        return result2;
    }

    private static void addConvertChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @NotNull List<? super BeforeAfter<AirContentRevision>> result2, @Nullable VcsOutgoingChangesProvider<?> provider, boolean honorExcludedFromCommit) {
        if (project == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(2);
        }
        if (changes2 == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(4);
        }
        List<Change> otherChanges = PartialChangesUtil.processPartialChanges(project, changes2, false, (PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean>)((PairFunction)(partialChanges, tracker) -> {
            if (!tracker.hasPartialChangesToCommit()) {
                return false;
            }
            List changelistIds = ContainerUtil.map((Collection)partialChanges, ChangeListChange::getChangeListId);
            Change change = ((ChangeListChange)partialChanges.get(0)).getChange();
            PartialCommitHelper helper = tracker.handlePartialCommit(Side.LEFT, changelistIds, honorExcludedFromCommit);
            String actualText = helper.getContent();
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), null, provider), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), actualText, provider)));
            return true;
        }));
        for (Change change : otherChanges) {
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision(), null, provider), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision(), null, provider)));
        }
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, Collection<? extends Change> changes2, String basePath, boolean reversePatch) throws VcsException {
        List<FilePatch> list = IdeaTextPatchBuilder.buildPatch(project, changes2, basePath, reversePatch, false);
        if (list == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project, Collection<? extends Change> changes2, String basePath, boolean reversePatch, boolean honorExcludedFromCommit) throws VcsException {
        List<Object> revisions;
        if (project != null) {
            revisions = IdeaTextPatchBuilder.revisionsConvertor(project, new ArrayList<Change>(changes2), honorExcludedFromCommit);
        } else {
            revisions = new ArrayList(changes2.size());
            for (Change change : changes2) {
                revisions.add(new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change.getBeforeRevision()), (Object)IdeaTextPatchBuilder.convertRevision(change.getAfterRevision())));
            }
        }
        List<FilePatch> list = TextPatchBuilder.buildPatch(revisions, basePath, reversePatch, SystemInfo.isFileSystemCaseSensitive, () -> ProgressManager.checkCanceled());
        if (list == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr) {
        return IdeaTextPatchBuilder.convertRevision(cr, null, null);
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr, @Nullable String actualTextContent, @Nullable VcsOutgoingChangesProvider provider) {
        if (cr == null) {
            return null;
        }
        if (provider != null) {
            Date date = provider.getRevisionDate(cr.getRevisionNumber(), cr.getFile());
            Long ts = date == null ? null : Long.valueOf(date.getTime());
            return IdeaTextPatchBuilder.convertRevisionToAir(cr, actualTextContent, ts);
        }
        return IdeaTextPatchBuilder.convertRevisionToAir(cr, actualTextContent, null);
    }

    @NotNull
    private static AirContentRevision convertRevisionToAir(@NotNull ContentRevision cr, @Nullable String actualTextContent, @Nullable Long ts) {
        if (cr == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(7);
        }
        FilePath fp = cr.getFile();
        StaticPathDescription description = new StaticPathDescription(fp.isDirectory(), ts == null ? fp.getIOFile().lastModified() : ts.longValue(), fp.getPath());
        if (actualTextContent != null) {
            PartialTextAirContentRevision partialTextAirContentRevision = new PartialTextAirContentRevision(actualTextContent, cr, description, ts);
            if (partialTextAirContentRevision == null) {
                IdeaTextPatchBuilder.$$$reportNull$$$0(8);
            }
            return partialTextAirContentRevision;
        }
        if (cr instanceof BinaryContentRevision) {
            BinaryAirContentRevision binaryAirContentRevision = new BinaryAirContentRevision((BinaryContentRevision)cr, description, ts);
            if (binaryAirContentRevision == null) {
                IdeaTextPatchBuilder.$$$reportNull$$$0(9);
            }
            return binaryAirContentRevision;
        }
        TextAirContentRevision textAirContentRevision = new TextAirContentRevision(cr, description, ts);
        if (textAirContentRevision == null) {
            IdeaTextPatchBuilder.$$$reportNull$$$0(10);
        }
        return textAirContentRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatch";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRevisionToAir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "revisionsConvertor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addConvertChanges";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertRevisionToAir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PartialTextAirContentRevision
    extends TextAirContentRevision {
        @NotNull
        private final String myContent;

        PartialTextAirContentRevision(@NotNull String content, @NotNull ContentRevision delegateRevision, @NotNull StaticPathDescription description, @Nullable Long timestamp) {
            if (content == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(0);
            }
            if (delegateRevision == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(1);
            }
            if (description == null) {
                PartialTextAirContentRevision.$$$reportNull$$$0(2);
            }
            super(delegateRevision, description, timestamp);
            this.myContent = content;
        }

        @Override
        public String getContentAsString() {
            return this.myContent;
        }

        @Override
        public byte[] getContentAsBytes() {
            return this.myContent.getBytes(this.getCharset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegateRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$PartialTextAirContentRevision";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TextAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final ContentRevision myRevision;
        @NotNull
        private final StaticPathDescription myDescription;
        @Nullable
        private final Long myTimestamp;

        TextAirContentRevision(@NotNull ContentRevision revision, @NotNull StaticPathDescription description, @Nullable Long timestamp) {
            if (revision == null) {
                TextAirContentRevision.$$$reportNull$$$0(0);
            }
            if (description == null) {
                TextAirContentRevision.$$$reportNull$$$0(1);
            }
            this.myRevision = revision;
            this.myDescription = description;
            this.myTimestamp = timestamp;
        }

        public boolean isBinary() {
            return false;
        }

        public String getContentAsString() throws VcsException {
            return this.myRevision.getContent();
        }

        public byte[] getContentAsBytes() throws VcsException {
            if (this.myRevision instanceof ByteBackedContentRevision) {
                return ((ByteBackedContentRevision)this.myRevision).getContentAsBytes();
            }
            String textContent = this.getContentAsString();
            if (textContent == null) {
                return null;
            }
            return textContent.getBytes(this.getCharset());
        }

        public String getRevisionNumber() {
            return this.myTimestamp != null ? null : this.myRevision.getRevisionNumber().asString();
        }

        @NotNull
        public PathDescription getPath() {
            StaticPathDescription staticPathDescription = this.myDescription;
            if (staticPathDescription == null) {
                TextAirContentRevision.$$$reportNull$$$0(2);
            }
            return staticPathDescription;
        }

        @NotNull
        public Charset getCharset() {
            Charset charset = this.myRevision.getFile().getCharset();
            if (charset == null) {
                TextAirContentRevision.$$$reportNull$$$0(3);
            }
            return charset;
        }

        @Nullable
        public String getLineSeparator() {
            VirtualFile virtualFile = this.myRevision.getFile().getVirtualFile();
            return virtualFile != null ? virtualFile.getDetectedLineSeparator() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCharset";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BinaryAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final BinaryContentRevision myRevision;
        @NotNull
        private final StaticPathDescription myDescription;
        @Nullable
        private final Long myTimestamp;

        BinaryAirContentRevision(@NotNull BinaryContentRevision revision, @NotNull StaticPathDescription description, @Nullable Long timestamp) {
            if (revision == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(0);
            }
            if (description == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(1);
            }
            this.myRevision = revision;
            this.myDescription = description;
            this.myTimestamp = timestamp;
        }

        public boolean isBinary() {
            return true;
        }

        public String getContentAsString() {
            throw new IllegalStateException();
        }

        public byte[] getContentAsBytes() throws VcsException {
            return this.myRevision.getBinaryContent();
        }

        public String getRevisionNumber() {
            return this.myTimestamp != null ? null : this.myRevision.getRevisionNumber().asString();
        }

        @NotNull
        public PathDescription getPath() {
            StaticPathDescription staticPathDescription = this.myDescription;
            if (staticPathDescription == null) {
                BinaryAirContentRevision.$$$reportNull$$$0(2);
            }
            return staticPathDescription;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

