/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.compose.console;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerComposeCredentialsType;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.docker.DockerNetworkUtilKt;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.jetbrains.python.docker.compose.console.PythonConsoleDockerComposeProcessCreatorKt;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/docker/compose/console/PythonConsoleDockerComposeProcessCreator;", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "Lcom/intellij/docker/remote/DockerComposeCredentialsHolder;", "()V", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "Companion", "intellij.python.docker"})
public final class PythonConsoleDockerComposeProcessCreator
implements PythonConsoleRemoteProcessCreator<DockerComposeCredentialsHolder> {
    private static final Logger LOG;
    private static final String DOCKER_CONTAINER_PROJECT_PATH = "/opt/project";
    public static final Companion Companion;

    @NotNull
    public CredentialsType<DockerComposeCredentialsHolder> getCredentialsType() {
        DockerComposeCredentialsType dockerComposeCredentialsType = DockerComposeCredentialsType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerComposeCredentialsType, (String)"DockerComposeCredentialsType.getInstance()");
        return (CredentialsType)dockerComposeCredentialsType;
    }

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, @NotNull DockerComposeCredentialsHolder credentials) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        int clientPort = NetUtils.findAvailableSocketPort();
        PydevConsoleCli.setupPythonConsoleScriptInServerMode((GeneralCommandLine)commandLine, (SdkAdditionalData)((SdkAdditionalData)data), (Integer)clientPort);
        ParametersList parametersList = commandLine.getParametersList();
        Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"commandLine.parametersList");
        String[] stringArray = parametersList.getArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"commandLine.parametersList.array");
        String[] command = stringArray;
        Map map = commandLine.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"commandLine.environment");
        Map env = map;
        File workDirectory = commandLine.getWorkDirectory();
        GeneralCommandLine patchedCommandLine = new GeneralCommandLine();
        patchedCommandLine.setWorkDirectory(workDirectory);
        patchedCommandLine.withParameters(Arrays.copyOf(command, command.length));
        patchedCommandLine.getEnvironment().putAll(env);
        patchedCommandLine.getParametersList().set(0, PythonRemoteInterpreterManager.toSystemDependent((String)new File(data.getHelpersPath(), runnerFileFromHelpers).getPath(), (boolean)PySourcePosition.isWindowsPath((String)data.getInterpreterPath())));
        try {
            String dockerHost;
            String string;
            patchedCommandLine.putUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS, (Object)PythonConsoleDockerComposeProcessCreator.Companion.buildDockerPathMappings(project));
            DockerCloudConfiguration configuration = DockerNetworkUtilKt.getDockerCloudConfiguration(credentials);
            List portBindings = CollectionsKt.listOf((Object)new DockerComposePort("0.0.0.0", Integer.valueOf(clientPort), Integer.valueOf(clientPort)));
            BaseOSProcessHandler processHandler = PythonConsoleDockerComposeProcessCreatorKt.access$startDockerComposeProcess(project, patchedCommandLine, data, pathMapper, portBindings);
            Process process = processHandler.getProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"processHandler.process");
            Process process2 = process;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using communication for Python console: port " + clientPort + " on pydevconsole.py side");
            }
            if ((string = DockerNetworkUtilKt.getDockerEngineAddress(configuration)) == null) {
                string = dockerHost = "localhost";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + dockerHost + " address to connect to pydevconsole.py side");
            }
            PydevConsoleCli.waitForPythonConsoleServerToBeStarted((Process)process2);
            PydevConsoleCommunicationClient pydevConsoleCommunication = new PydevConsoleCommunicationClient(project, dockerHost, clientPort, process2);
            pydevConsoleCommunication.connect();
            PyDockerComposeProcessConnectionData pyDockerComposeProcessConnectionData = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDockerComposeProcessConnectionData), (String)"PyDockerProcessUtil.getP\u2026ocessConnectionData(data)");
            PyRemoteSocketToLocalHostProvider pyRemoteSocketToLocalHostProvider = pyDockerComposeProcessConnectionData.getPyRemoteSocketToLocalHostProvider();
            Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteSocketToLocalHostProvider, (String)"PyDockerProcessUtil.getP\u2026SocketToLocalHostProvider");
            PyRemoteSocketToLocalHostProvider socketProvider = pyRemoteSocketToLocalHostProvider;
            return new RemoteConsoleProcessData((ProcessHandler)processHandler, (PydevConsoleCommunication)pydevConsoleCommunication, processHandler.getCommandLine(), process2, socketProvider);
        }
        catch (Exception e) {
            throw (Throwable)new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)PythonConsoleDockerComposeProcessCreator.class.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Pytho\u2026Creator::class.java.name)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/docker/compose/console/PythonConsoleDockerComposeProcessCreator$Companion;", "", "()V", "DOCKER_CONTAINER_PROJECT_PATH", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "buildDockerPathMappings", "Lcom/intellij/util/PathMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.docker"})
    public static final class Companion {
        private final PathMappingSettings buildDockerPathMappings(Project project) {
            return new PathMappingSettings(CollectionsKt.listOf((Object)new PathMappingSettings.PathMapping(project.getBasePath(), PythonConsoleDockerComposeProcessCreator.DOCKER_CONTAINER_PROJECT_PATH)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

