/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.util.ReflectionUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class HsqlJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> HSQLDB_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"integer", "smallint", "bigint", "tinyint", "double", "uuid", "date"});

    public HsqlJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Rdbms.of((String)"HSQLDB"), version, connection);
    }

    public HsqlJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return HsqlJdbcHelper.extractVersion(version);
    }

    @Override
    public Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Object result;
        Class<?> c = o.getClass();
        String className = c.getName();
        if ("org.hsqldb.types.BinaryData".equals(className) && (result = HsqlJdbcHelper.convertBinaryData(o)) != null) {
            return result;
        }
        return super.convertValue(exporter, o);
    }

    @Override
    @Nullable
    protected Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) throws SQLException {
        int precision;
        String typeName;
        boolean isBit;
        if (options == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(1);
        }
        if (metaData == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(2);
        }
        if ((isBit = "bit".equalsIgnoreCase(typeName = metaData.getColumnTypeName(index))) && !options.raw && (precision = metaData.getPrecision(index)) > 1) {
            byte[] bytes = resultSet.getBytes(index);
            return BitString.of(bytes, precision);
        }
        return super.tryGetObject(options, resultSet, metaData, index);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(3);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        long oneGb = 0x40000000L;
        long sixteenMb = 0x1000000L;
        if (HSQLDB_UNLIMITED_TYPES.contains(t) || e.length == 0 || t.startsWith("time") || t.startsWith("timestamp") || t.startsWith("interval") || (t.equals("clob") || t.equals("blob")) && (long)e.length == oneGb || t.equals("varbinary") && (long)e.length == sixteenMb || (t.equals("numeric") || t.equals("decimal")) && e.length == 128) {
            e.length = -1;
        }
    }

    @Nullable
    private static Object convertBinaryData(@NotNull Object o) {
        if (o == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(4);
        }
        Object bits = ReflectionHelper.tryInvokeMethod(o, "isBits", null, null);
        Object bytes = JdbcNativeUtil.tryGetBytes(o);
        if (!(bytes instanceof byte[] && bits instanceof Boolean && ((Boolean)bits).booleanValue())) {
            return bytes;
        }
        Long length = (Long)ReflectionUtilRt.getField(o.getClass(), (Object)o, Long.TYPE, (String)"bitLength");
        if (length == null) {
            return bytes;
        }
        return BitString.of((byte[])bytes, length);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "hsql")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return HsqlJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static HsqlJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        HsqlJdbcHelper hsqlJdbcHelper = new HsqlJdbcHelper(HsqlJdbcHelper.extractVersion(productVer), delegate);
        if (hsqlJdbcHelper == null) {
            HsqlJdbcHelper.$$$reportNull$$$0(5);
        }
        return hsqlJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/HsqlJdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/HsqlJdbcHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryGetObject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertBinaryData";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

