/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.remote.PyRemoteInterpreterManagerImpl;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import com.jetbrains.python.sdk.skeletons.SkeletonVersionChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyRemoteSkeletonGeneratorBase
extends PySkeletonGenerator {
    protected HashSet<String> myListedLocalPaths;
    protected HashSet<String> myListedBinaries;

    public PyRemoteSkeletonGeneratorBase(String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder) {
        if (pySdk == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(0);
        }
        super(skeletonPath, pySdk, currentFolder);
        this.myListedLocalPaths = Sets.newHashSet();
        this.myListedBinaries = Sets.newHashSet();
    }

    protected static long doneIn(long started) {
        return System.currentTimeMillis() - started;
    }

    @NotNull
    protected List<PyRemoteSourceItem> listSources(Sdk sdk, String extraSysPath) throws InvalidSdkException {
        String homePath = sdk.getHomePath();
        String parentDir = new File(homePath).getParent();
        long startTime = System.currentTimeMillis();
        String pathList = PyRemoteSkeletonGeneratorBase.prependSysPathWithSdkAddedPaths(sdk, extraSysPath);
        ImmutableList.Builder cmdBuilder = ImmutableList.builder();
        cmdBuilder.add((Object)homePath).add((Object)PythonHelpersLocator.getHelperPath((String)"generator3.py")).add((Object)"-v").add((Object)"-S");
        if (StringUtil.isNotEmpty((String)pathList)) {
            cmdBuilder.add((Object)"-s").add((Object)pathList);
        }
        ProcessOutput process = this.getProcessOutput(parentDir, ArrayUtilRt.toStringArray((Collection)cmdBuilder.build()), PythonSdkType.activateVirtualEnv((Sdk)sdk), 240000);
        LOG.info("Retrieving binary module list took " + PyRemoteSkeletonGeneratorBase.doneIn(startTime) + " ms");
        if (process.getExitCode() != 0) {
            StringBuilder sb = new StringBuilder("failed to run ").append("generator3.py").append(" for ").append(homePath);
            if (process.isTimeout()) {
                sb.append(": timed out.");
            } else {
                sb.append(", exit code ").append(process.getExitCode()).append(", stderr: \n-----\n");
                for (String line : process.getStderrLines()) {
                    sb.append(line).append("\n");
                }
                sb.append("-----");
            }
            throw new InvalidSdkException(sb.toString());
        }
        List lines = process.getStdoutLines();
        if (lines.size() < 1) {
            throw new InvalidSdkException("Empty output from generator3.py for " + homePath);
        }
        Iterator iter = lines.iterator();
        int generatorVersion = SkeletonVersionChecker.fromVersionString((String)((String)iter.next()).trim());
        ArrayList result = Lists.newArrayList();
        boolean end = false;
        while (iter.hasNext()) {
            String line = (String)iter.next();
            if ("END".equals(line = line.trim())) {
                end = true;
                break;
            }
            try {
                int size;
                String[] strs = line.split("\t");
                String path = strs[0];
                String rootPath = strs[1];
                try {
                    size = Integer.parseInt(strs[2]);
                }
                catch (Exception e) {
                    size = 0;
                }
                PyRemoteSourceItem item = new PyRemoteSourceItem(path, rootPath, size);
                result.add(item);
            }
            catch (Exception e) {
                LOG.error("Error parsing output: " + line, (Throwable)e);
            }
        }
        if (!end) {
            LOG.error("Skeletons generator: list_sources: no END of output");
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private static String prependSysPathWithSdkAddedPaths(@NotNull Sdk sdk, @Nullable String sysPath) {
        List addedPathList;
        if (sdk == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(2);
        }
        if ((addedPathList = PythonCommandLineState.getAddedPaths((Sdk)sdk)).isEmpty()) {
            return sysPath;
        }
        StringBuilder pathListBuilder = new StringBuilder();
        Joiner.on((String)File.pathSeparator).appendTo(pathListBuilder, (Iterable)addedPathList);
        if (StringUtil.isNotEmpty((String)sysPath)) {
            pathListBuilder.append(File.pathSeparator).append(sysPath);
        }
        return pathListBuilder.toString();
    }

    public boolean deleteOrLog(@NotNull File item) {
        if (item == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(3);
        }
        if (!this.myListedLocalPaths.contains(item.getPath())) {
            return super.deleteOrLog(item);
        }
        return false;
    }

    protected void storeListedLocalPaths(List<PyRemoteSourceItem> list) {
        this.myListedLocalPaths.clear();
        for (PyRemoteSourceItem item : list) {
            this.myListedLocalPaths.add(item.getLocalFile(this.getSkeletonsPath()).getPath());
        }
    }

    @NotNull
    public PySkeletonGenerator.ListBinariesResult listBinaries(@NotNull Sdk sdk, @NotNull String extraSysPath) throws InvalidSdkException {
        if (sdk == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(4);
        }
        if (extraSysPath == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(5);
        }
        this.myListedBinaries.clear();
        PySkeletonGenerator.ListBinariesResult result = super.listBinaries(sdk, extraSysPath);
        for (PySkeletonRefresher.PyBinaryItem item : result.modules.values()) {
            this.myListedBinaries.add(item.getPath());
        }
        PySkeletonGenerator.ListBinariesResult listBinariesResult = result;
        if (listBinariesResult == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(6);
        }
        return listBinariesResult;
    }

    public boolean exists(@NotNull String name) {
        if (name == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(7);
        }
        return this.myListedBinaries.contains(name);
    }

    @NotNull
    protected PyRemotePathMapper createPathMappings(@Nullable Project project, @NotNull PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData) {
        if (remoteSdkAdditionalData == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(8);
        }
        PyRemotePathMapper pathMapper = new PyRemotePathMapper();
        PythonRemoteInterpreterManager.addHelpersMapping((RemoteSdkProperties)remoteSdkAdditionalData, (PyRemotePathMapper)pathMapper);
        String skeletonsPath = this.getRemoteSkeletonsPath();
        if (skeletonsPath != null) {
            pathMapper.addMapping(this.getSkeletonsPath(), skeletonsPath, PyRemotePathMapper.PyPathMappingType.SKELETONS);
        }
        PyRemotePathMapper pyRemotePathMapper = pathMapper = PyRemoteInterpreterManagerImpl.appendBasicMappings(project, pathMapper, (RemoteSdkAdditionalData)remoteSdkAdditionalData);
        if (pyRemotePathMapper == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(9);
        }
        return pyRemotePathMapper;
    }

    protected static String[] addUnbuffered(String homePath, String[] commandLine) {
        ArrayList cmd = Lists.newArrayList((Object[])commandLine);
        if (!homePath.contains("jython")) {
            if (cmd.isEmpty()) {
                LOG.warn("Command line is empty for getProcessOutput");
            } else {
                cmd.add(1, "-u");
            }
        }
        commandLine = ArrayUtilRt.toStringArray((Collection)cmd);
        return commandLine;
    }

    @Nullable
    protected String getRemoteSkeletonsPath() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pySdk";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteSkeletonGeneratorBase";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraSysPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSkeletonGeneratorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listSources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listBinaries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prependSysPathWithSdkAddedPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteOrLog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "listBinaries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPathMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

