
let lastSearch = {text: "", caseSensitive: false};

function findText(selector, text, caseSensitive) {
  lastSearch.text = text;
  lastSearch.caseSensitive = caseSensitive;
  var sel = window.getSelection();
  sel.collapse(document.body, 0);

  return self.find(text, caseSensitive);
  // $(selector).filter(":visible").removeHighlight().highlight(text);
}

function findNext() {

  window.getSelection().collapseToEnd();
  self.find(lastSearch.text, lastSearch.caseSensitive, false, true);
  // iterateSelection(1);
}

function findPrev() {
  window.getSelection().collapseToStart();
  self.find(lastSearch.text, lastSearch.caseSensitive, true, true);
  // iterateSelection(-1);
}


//todo: handle big amount of results
function iterateSelection(direction) {
  let highlighted = $('.highlight').filter(":visible");
  if (highlighted.length === 0) return;

  let index = highlighted.index($(".selected"));
  if (index !== -1) {
    let current = highlighted.eq(index);
    current.removeClass("selected");
  }
  if (direction < 0 && index === -1) index = 0;
  let nextInd = (index + direction) % highlighted.length;
  let next = highlighted.eq(nextInd);
  next.addClass("selected");
  next.get(0).scrollIntoViewIfNeeded();
}


jQuery.fn.highlight = function(pat) {
  function innerHighlight(node, pat) {
    var skip = 0;
    if (node.nodeType == 3) {
      var pos = node.data.toUpperCase().indexOf(pat);
      pos -= (node.data.substr(0, pos).toUpperCase().length - node.data.substr(0, pos).length);
      if (pos >= 0) {
        var spannode = document.createElement('span');
        spannode.className = 'highlight';
        var middlebit = node.splitText(pos);
        var endbit = middlebit.splitText(pat.length);
        var middleclone = middlebit.cloneNode(true);
        spannode.appendChild(middleclone);
        middlebit.parentNode.replaceChild(spannode, middlebit);
        skip = 1;
      }
    }
    else if (node.nodeType == 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {
      for (var i = 0; i < node.childNodes.length; ++i) {
        let child = node.childNodes[i];
        i += innerHighlight(child, pat);
      }
    }
    return skip;
  }
  return this.length && pat && pat.length ? this.each(function() {
    innerHighlight(this, pat.toUpperCase());
  }) : this;
};

jQuery.fn.removeHighlight = function() {
  return this.find("span.highlight").each(function() {
    this.parentNode.firstChild.nodeName;
    with (this.parentNode) {
      replaceChild(this.firstChild, this);
      normalize();
    }
  }).end();
};