/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageFileEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageEditorImpl;
import org.intellij.images.editor.impl.ImageFileEditorState;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.ZoomOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageFileEditorImpl
extends UserDataHolderBase
implements ImageFileEditor,
PropertyChangeListener {
    private static final String NAME = "ImageFileEditor";
    private final ImageEditor imageEditor;
    private final EventDispatcher<PropertyChangeListener> myDispatcher;

    ImageFileEditorImpl(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(1);
        }
        this.myDispatcher = EventDispatcher.create(PropertyChangeListener.class);
        this.imageEditor = new ImageEditorImpl(project, file);
        Disposer.register((Disposable)this, (Disposable)this.imageEditor);
        Options options = OptionsManager.getInstance().getOptions();
        EditorOptions editorOptions = options.getEditorOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        TransparencyChessboardOptions transparencyChessboardOptions = editorOptions.getTransparencyChessboardOptions();
        this.imageEditor.setGridVisible(gridOptions.isShowDefault());
        this.imageEditor.setTransparencyChessboardVisible(transparencyChessboardOptions.isShowDefault());
        ((ImageEditorImpl)this.imageEditor).getComponent().getImageComponent().addPropertyChangeListener(this);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.imageEditor.getComponent();
        if (jComponent == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.imageEditor.getContentComponent();
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(3);
        }
        ImageZoomModel zoomModel = this.imageEditor.getZoomModel();
        return new ImageFileEditorState(this.imageEditor.isTransparencyChessboardVisible(), this.imageEditor.isGridVisible(), zoomModel.getZoomFactor(), zoomModel.isZoomLevelChanged());
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(4);
        }
        if (state instanceof ImageFileEditorState) {
            Options options = OptionsManager.getInstance().getOptions();
            ZoomOptions zoomOptions = options.getEditorOptions().getZoomOptions();
            ImageFileEditorState editorState = (ImageFileEditorState)state;
            ImageZoomModel zoomModel = this.imageEditor.getZoomModel();
            this.imageEditor.setTransparencyChessboardVisible(editorState.isBackgroundVisible());
            this.imageEditor.setGridVisible(editorState.isGridVisible());
            if (editorState.isZoomFactorChanged() || !zoomOptions.isSmartZooming()) {
                zoomModel.setZoomFactor(editorState.getZoomFactor());
            }
            zoomModel.setZoomLevelChanged(editorState.isZoomFactorChanged());
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(5);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(6);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(7);
        }
        PropertyChangeEvent editorEvent = new PropertyChangeEvent(this, event.getPropertyName(), event.getOldValue(), event.getNewValue());
        ((PropertyChangeListener)this.myDispatcher.getMulticaster()).propertyChange(editorEvent);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public ImageEditor getImageEditor() {
        ImageEditor imageEditor = this.imageEditor;
        if (imageEditor == null) {
            ImageFileEditorImpl.$$$reportNull$$$0(8);
        }
        return imageEditor;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.imageEditor.getFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/editor/impl/ImageFileEditorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/editor/impl/ImageFileEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

