/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.TIntArrayList;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectorUtils {
    public static final Comparator<TextRange> RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.intersects(o2)) {
            return 0;
        }
        return o1.getStartOffset() - o2.getStartOffset();
    };
    private static final Pattern MAP_ENTRY_PATTERN = Pattern.compile("([\\S&&[^=]]+)=(\"(?:[^\"]|\\\\\")*\"|\\S*)");

    private InjectorUtils() {
    }

    @Nullable
    public static Language getLanguage(@NotNull BaseInjection injection) {
        if (injection == null) {
            InjectorUtils.$$$reportNull$$$0(0);
        }
        return InjectorUtils.getLanguageByString(injection.getInjectedLanguageId());
    }

    @Nullable
    public static Language getLanguageByString(@NotNull String languageId) {
        Language language;
        if (languageId == null) {
            InjectorUtils.$$$reportNull$$$0(1);
        }
        if ((language = InjectedLanguage.findLanguageById(languageId)) != null) {
            return language;
        }
        ReferenceInjector injector = ReferenceInjector.findById((String)languageId);
        if (injector != null) {
            return injector.toLanguage();
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(languageId);
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    public static boolean registerInjectionSimple(@NotNull PsiLanguageInjectionHost host, @NotNull BaseInjection injection, @Nullable LanguageInjectionSupport support, @NotNull MultiHostRegistrar registrar) {
        Language language;
        if (host == null) {
            InjectorUtils.$$$reportNull$$$0(2);
        }
        if (injection == null) {
            InjectorUtils.$$$reportNull$$$0(3);
        }
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(4);
        }
        if ((language = InjectorUtils.getLanguage(injection)) == null) {
            return false;
        }
        InjectedLanguage injectedLanguage = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
        List<TextRange> ranges = injection.getInjectedArea((PsiElement)host);
        ArrayList<Trinity> list = new ArrayList<Trinity>(ranges.size());
        for (TextRange range : ranges) {
            list.add(Trinity.create((Object)host, (Object)injectedLanguage, (Object)range));
        }
        InjectorUtils.registerInjection(language, list, host.getContainingFile(), registrar);
        if (support != null) {
            InjectorUtils.registerSupport(support, true, (PsiElement)host, language);
        }
        return !ranges.isEmpty();
    }

    public static void registerInjection(@Nullable Language language, @NotNull List<? extends Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, @NotNull PsiFile containingFile, @NotNull MultiHostRegistrar registrar) {
        if (list == null) {
            InjectorUtils.$$$reportNull$$$0(5);
        }
        if (containingFile == null) {
            InjectorUtils.$$$reportNull$$$0(6);
        }
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(7);
        }
        if (language == null) {
            return;
        }
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
        if (parser == null && injector != null) {
            Iterator<? extends Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> iterator = list.iterator();
            if (iterator.hasNext()) {
                Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange> trinity = iterator.next();
                String string = ((InjectedLanguage)trinity.second).getPrefix();
                String suffix = ((InjectedLanguage)trinity.second).getSuffix();
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)trinity.first;
                TextRange textRange = (TextRange)trinity.third;
                InjectedLanguageUtil.injectReference((MultiHostRegistrar)registrar, (Language)language, (String)string, (String)suffix, (PsiLanguageInjectionHost)host, (TextRange)textRange);
                return;
            }
            return;
        }
        boolean injectionStarted = false;
        for (Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange> trinity : list) {
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)trinity.first;
            if (host.getContainingFile() != containingFile || !host.isValidHost()) continue;
            TextRange textRange = (TextRange)trinity.third;
            InjectedLanguage injectedLanguage = (InjectedLanguage)trinity.second;
            if (!injectionStarted) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)language.getID(), (CharSequence)((InjectedLanguage)trinity.second).getID())) {
                    registrar.startInjecting(language, StringUtil.toLowerCase((String)((InjectedLanguage)trinity.second).getID()));
                } else {
                    registrar.startInjecting(language);
                }
                injectionStarted = true;
            }
            registrar.addPlace(injectedLanguage.getPrefix(), injectedLanguage.getSuffix(), host, textRange);
        }
        if (injectionStarted) {
            registrar.doneInjecting();
        }
    }

    @NotNull
    public static Collection<String> getActiveInjectionSupportIds() {
        List list = ContainerUtil.map((Collection)LanguageInjectionSupport.EP_NAME.getExtensionList(), LanguageInjectionSupport::getId);
        if (list == null) {
            InjectorUtils.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public static Collection<LanguageInjectionSupport> getActiveInjectionSupports() {
        List list = LanguageInjectionSupport.EP_NAME.getExtensionList();
        if (list == null) {
            InjectorUtils.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public static LanguageInjectionSupport findInjectionSupport(@NotNull String id) {
        if (id == null) {
            InjectorUtils.$$$reportNull$$$0(10);
        }
        for (LanguageInjectionSupport support : LanguageInjectionSupport.EP_NAME.getExtensionList()) {
            if (!id.equals(support.getId())) continue;
            return support;
        }
        return null;
    }

    public static Class<?> @NotNull [] getPatternClasses(@NotNull String supportId) {
        LanguageInjectionSupport support;
        if (supportId == null) {
            InjectorUtils.$$$reportNull$$$0(11);
        }
        Class[] classArray = (support = InjectorUtils.findInjectionSupport(supportId)) == null ? ArrayUtil.EMPTY_CLASS_ARRAY : support.getPatternClasses();
        if (classArray == null) {
            InjectorUtils.$$$reportNull$$$0(12);
        }
        return classArray;
    }

    @NotNull
    public static LanguageInjectionSupport findNotNullInjectionSupport(@NotNull String id) {
        LanguageInjectionSupport result;
        if (id == null) {
            InjectorUtils.$$$reportNull$$$0(13);
        }
        if ((result = InjectorUtils.findInjectionSupport(id)) == null) {
            throw new IllegalStateException(id + " injector not found");
        }
        LanguageInjectionSupport languageInjectionSupport = result;
        if (languageInjectionSupport == null) {
            InjectorUtils.$$$reportNull$$$0(14);
        }
        return languageInjectionSupport;
    }

    @NotNull
    public static StringBuilder appendStringPattern(@NotNull StringBuilder sb, @NotNull String prefix, @NotNull String text, @NotNull String suffix) {
        if (sb == null) {
            InjectorUtils.$$$reportNull$$$0(15);
        }
        if (prefix == null) {
            InjectorUtils.$$$reportNull$$$0(16);
        }
        if (text == null) {
            InjectorUtils.$$$reportNull$$$0(17);
        }
        if (suffix == null) {
            InjectorUtils.$$$reportNull$$$0(18);
        }
        sb.append(prefix).append("string().");
        String[] parts = text.split("[,|\\s]+");
        boolean useMatches = false;
        for (String part : parts) {
            if (!InjectorUtils.isRegexp(part)) continue;
            useMatches = true;
            break;
        }
        if (useMatches) {
            sb.append("matches(\"").append(text).append("\")");
        } else if (parts.length > 1) {
            sb.append("oneOf(");
            boolean first = true;
            for (String part : parts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("\"").append(part).append("\"");
            }
            sb.append(")");
        } else {
            sb.append("equalTo(\"").append(text).append("\")");
        }
        sb.append(suffix);
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            InjectorUtils.$$$reportNull$$$0(19);
        }
        return stringBuilder;
    }

    public static boolean isRegexp(@NotNull String s) {
        if (s == null) {
            InjectorUtils.$$$reportNull$$$0(20);
        }
        boolean hasReChars = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '_' || c == '-' || Character.isLetterOrDigit(c)) continue;
            hasReChars = true;
            break;
        }
        if (hasReChars) {
            try {
                new URL(s);
            }
            catch (MalformedURLException e) {
                return true;
            }
        }
        return false;
    }

    public static void registerSupport(@NotNull LanguageInjectionSupport support, boolean settingsAvailable, @NotNull PsiElement element, @NotNull Language language) {
        if (support == null) {
            InjectorUtils.$$$reportNull$$$0(21);
        }
        if (element == null) {
            InjectorUtils.$$$reportNull$$$0(22);
        }
        if (language == null) {
            InjectorUtils.$$$reportNull$$$0(23);
        }
        InjectorUtils.putInjectedFileUserData(element, language, LanguageInjectionSupport.INJECTOR_SUPPORT, support);
        if (settingsAvailable) {
            InjectorUtils.putInjectedFileUserData(element, language, LanguageInjectionSupport.SETTINGS_EDITOR, support);
        }
    }

    public static <T> void putInjectedFileUserData(@NotNull PsiElement element, @NotNull Language language, @NotNull Key<T> key, @Nullable T value) {
        if (element == null) {
            InjectorUtils.$$$reportNull$$$0(24);
        }
        if (language == null) {
            InjectorUtils.$$$reportNull$$$0(25);
        }
        if (key == null) {
            InjectorUtils.$$$reportNull$$$0(26);
        }
        InjectedLanguageUtil.putInjectedFileUserData((PsiElement)element, (Language)language, key, value);
    }

    @Deprecated
    public static <T> void putInjectedFileUserData(@NotNull MultiHostRegistrar registrar, @NotNull Key<T> key, T value) {
        if (registrar == null) {
            InjectorUtils.$$$reportNull$$$0(27);
        }
        if (key == null) {
            InjectorUtils.$$$reportNull$$$0(28);
        }
        InjectedLanguageUtil.putInjectedFileUserData((MultiHostRegistrar)registrar, key, value);
    }

    public static Configuration getEditableInstance(@NotNull Project project) {
        if (project == null) {
            InjectorUtils.$$$reportNull$$$0(29);
        }
        return Configuration.getInstance();
    }

    public static boolean canBeRemoved(@NotNull BaseInjection injection) {
        if (injection == null) {
            InjectorUtils.$$$reportNull$$$0(30);
        }
        if (injection.isEnabled()) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)injection.getPrefix()) || StringUtil.isNotEmpty((String)injection.getSuffix())) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)injection.getValuePattern());
    }

    @Nullable
    private static CommentInjectionData findCommentInjectionData(@NotNull PsiElement context, @Nullable Ref<? super PsiElement> causeRef) {
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(31);
        }
        return InjectorUtils.findCommentInjectionData(context, true, causeRef);
    }

    @Nullable
    public static CommentInjectionData findCommentInjectionData(@NotNull PsiElement context, boolean treeElementsIncludeComment, @Nullable Ref<? super PsiElement> causeRef) {
        PsiElement target;
        PsiFile file;
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(32);
        }
        if ((file = (target = CompletionUtil.getOriginalOrSelf((PsiElement)context)).getContainingFile()) == null) {
            return null;
        }
        TreeMap<TextRange, CommentInjectionData> map = InjectorUtils.getInjectionMap(file);
        if (map == null) {
            return null;
        }
        Map.Entry<TextRange, CommentInjectionData> entry = map.lowerEntry(target.getTextRange());
        if (entry == null) {
            return null;
        }
        PsiComment psiComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)entry.getKey().getStartOffset(), PsiComment.class, (boolean)false);
        if (psiComment == null) {
            return null;
        }
        TextRange r0 = psiComment.getTextRange();
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)psiComment, (PsiElement)target);
        if (commonParent == null) {
            return null;
        }
        PsiElement topmostElement = target;
        for (PsiElement parent = target; parent != null && (treeElementsIncludeComment ? parent : parent.getParent()) != commonParent; parent = parent.getParent()) {
            topmostElement = parent;
        }
        int off1 = r0.getEndOffset();
        int off2 = topmostElement.getTextRange().getStartOffset();
        if (off2 - off1 > 120) {
            return null;
        }
        if (off2 - off1 > 2) {
            PsiElement e;
            Supplier<PsiElement> producer = InjectorUtils.prevWalker(topmostElement, commonParent);
            while ((e = producer.get()) != null && e != psiComment) {
                if (!(e instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)e).isValidHost() || StringUtil.isEmptyOrSpaces((String)e.getText())) continue;
                return null;
            }
        }
        if (causeRef != null) {
            causeRef.set((Object)psiComment);
        }
        return entry.getValue();
    }

    @Nullable
    public static BaseInjection findCommentInjection(@NotNull PsiElement context, @NotNull String supportId, @Nullable Ref<? super PsiElement> causeRef) {
        CommentInjectionData data;
        if (context == null) {
            InjectorUtils.$$$reportNull$$$0(33);
        }
        if (supportId == null) {
            InjectorUtils.$$$reportNull$$$0(34);
        }
        if ((data = InjectorUtils.findCommentInjectionData(context, causeRef)) == null) {
            return null;
        }
        BaseInjection injection = new BaseInjection(supportId);
        injection.setPrefix(data.getPrefix());
        injection.setSuffix(data.getSuffix());
        injection.setInjectedLanguageId(data.getInjectedLanguageId());
        injection.setDisplayName(data.getDisplayName());
        return injection;
    }

    @Nullable
    private static TreeMap<TextRange, CommentInjectionData> getInjectionMap(@NotNull PsiFile file) {
        if (file == null) {
            InjectorUtils.$$$reportNull$$$0(35);
        }
        return (TreeMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            TreeMap<TextRange, CommentInjectionData> map = InjectorUtils.calcInjections(file);
            return CachedValueProvider.Result.create(map.isEmpty() ? null : map, (Object[])new Object[]{file});
        });
    }

    @NotNull
    private static TreeMap<TextRange, CommentInjectionData> calcInjections(@NotNull PsiFile file) {
        if (file == null) {
            InjectorUtils.$$$reportNull$$$0(36);
        }
        TreeMap<TextRange, CommentInjectionData> injectionMap = new TreeMap<TextRange, CommentInjectionData>(RANGE_COMPARATOR);
        TIntArrayList ints = new TIntArrayList();
        StringSearcher searcher = new StringSearcher("language=", true, true, false);
        CharSequence contents = file.getViewProvider().getContents();
        char[] contentsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)contents);
        int s0 = 0;
        int s1 = contents.length();
        int idx = searcher.scan(contents, contentsArray, s0, s1);
        while (idx != -1) {
            ints.add(idx);
            PsiComment element = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)idx, PsiComment.class, (boolean)false);
            if (element != null) {
                CommentInjectionData injection;
                String str = ElementManipulators.getValueText((PsiElement)element).trim();
                CommentInjectionData commentInjectionData = injection = str.startsWith("language=") ? new CommentInjectionData(InjectorUtils.decodeMap(str), str) : null;
                if (injection != null) {
                    injectionMap.put(element.getTextRange(), injection);
                }
            }
            idx = searcher.scan(contents, contentsArray, idx + 1, s1);
        }
        TreeMap<TextRange, CommentInjectionData> treeMap = injectionMap;
        if (treeMap == null) {
            InjectorUtils.$$$reportNull$$$0(37);
        }
        return treeMap;
    }

    @NotNull
    private static Map<String, String> decodeMap(@NotNull CharSequence charSequence) {
        if (charSequence == null) {
            InjectorUtils.$$$reportNull$$$0(38);
        }
        if (StringUtil.isEmpty((CharSequence)charSequence)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                InjectorUtils.$$$reportNull$$$0(39);
            }
            return map;
        }
        Matcher matcher = MAP_ENTRY_PATTERN.matcher(charSequence);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            map.put(StringUtil.unescapeStringCharacters((String)matcher.group(1)), StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)matcher.group(2))));
        }
        LinkedHashMap<String, String> linkedHashMap = map;
        if (linkedHashMap == null) {
            InjectorUtils.$$$reportNull$$$0(40);
        }
        return linkedHashMap;
    }

    @NotNull
    private static Supplier<PsiElement> prevWalker(final @NotNull PsiElement element, final @NotNull PsiElement scope) {
        if (element == null) {
            InjectorUtils.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            InjectorUtils.$$$reportNull$$$0(42);
        }
        return new Supplier<PsiElement>(){
            PsiElement e;
            {
                this.e = element;
            }

            @Override
            @Nullable
            public PsiElement get() {
                if (this.e == null || this.e == scope) {
                    return null;
                }
                PsiElement prev = this.e.getPrevSibling();
                if (prev != null) {
                    this.e = PsiTreeUtil.getDeepestLast((PsiElement)prev);
                    return this.e;
                }
                PsiElement parent = this.e.getParent();
                this.e = parent == scope || parent instanceof PsiFile ? null : parent;
                return this.e;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 37: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 37: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: 
            case 7: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 37: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectorUtils";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 22: 
            case 24: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectorUtils";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveInjectionSupportIds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveInjectionSupports";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findNotNullInjectionSupport";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "appendStringPattern";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInjections";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageByString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerInjectionSimple";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerInjection";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 37: 
            case 39: 
            case 40: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInjectionSupport";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPatternClasses";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findNotNullInjectionSupport";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendStringPattern";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isRegexp";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "registerSupport";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "putInjectedFileUserData";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEditableInstance";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "canBeRemoved";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjectionData";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionMap";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "calcInjections";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "decodeMap";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "prevWalker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 37: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommentInjectionData {
        private final String myDisplayName;
        private final Map<String, String> myMap;

        CommentInjectionData(@NotNull Map<String, String> map, @NotNull String displayName) {
            if (map == null) {
                CommentInjectionData.$$$reportNull$$$0(0);
            }
            if (displayName == null) {
                CommentInjectionData.$$$reportNull$$$0(1);
            }
            this.myMap = Collections.unmodifiableMap(map);
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getPrefix() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("prefix"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getSuffix() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("suffix"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getInjectedLanguageId() {
            String string = (String)ObjectUtils.notNull((Object)this.myMap.get("language"), (Object)"");
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                CommentInjectionData.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public Map<String, String> getValues() {
            Map<String, String> map = this.myMap;
            if (map == null) {
                CommentInjectionData.$$$reportNull$$$0(6);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectorUtils$CommentInjectionData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectorUtils$CommentInjectionData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInjectedLanguageId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

