/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.ui;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.tracing.MethodTracerData;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.table.TableView;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.tracing.ui.DataById;
import com.jetbrains.performancePlugin.tracing.ui.DataByIdTableModel;
import com.jetbrains.performancePlugin.tracing.ui.DataSource;
import com.jetbrains.performancePlugin.tracing.ui.TracerDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class InternalTracingToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    private static final String ID = "Internal Method Tracing";

    InternalTracingToolWindowFactory() {
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            InternalTracingToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            InternalTracingToolWindowFactory.$$$reportNull$$$0(1);
        }
        DataById<MethodTracerData> dataById = new DataById<MethodTracerData>(d -> d.id);
        DataByIdTableModel<MethodTracerData> allThreadsModel = new DataByIdTableModel<MethodTracerData>(dataById, dataById.column("Class", d -> d.className), dataById.column("Method", d -> d.methodName), dataById.column("Invocation count", d -> d.invocationCount), dataById.column("Total time, ms", d -> d.totalTime), dataById.column("Max time, ms", d -> d.maxTime), dataById.column("Avg time, ms", d -> d.getAvgTime()), dataById.column("Max recursion depth", d -> d.maxRecursionDepth));
        DataByIdTableModel<MethodTracerData> edtModel = new DataByIdTableModel<MethodTracerData>(dataById, dataById.column("Class", d -> d.className), dataById.column("Method", d -> d.methodName), dataById.column("Invocation count", d -> d.countOnEdt), dataById.column("Total time, ms", d -> d.timeOnEdt), dataById.column("Max time, ms", d -> d.maxTimeOnEdt), dataById.column("Avg time, ms", d -> d.getAvgTimeEdt()));
        TracerDataSource dataSource = new TracerDataSource();
        JPanel allThreadsPanel = InternalTracingToolWindowFactory.createTableWithToolbarPanel(dataSource, allThreadsModel);
        JPanel edtPanel = InternalTracingToolWindowFactory.createTableWithToolbarPanel(dataSource, edtModel);
        InternalTracingToolWindowFactory.scheduleRefresh(dataSource, toolWindow, allThreadsModel, edtModel);
        ContentFactory factory = ContentFactory.SERVICE.getInstance();
        ContentManager manager = toolWindow.getContentManager();
        manager.addContent(factory.createContent((JComponent)allThreadsPanel, PerformanceTestingBundle.message("content.display.name.all.threads", new Object[0]), false));
        manager.addContent(factory.createContent((JComponent)edtPanel, "EDT", false));
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        if (project == null) {
            InternalTracingToolWindowFactory.$$$reportNull$$$0(2);
        }
        return false;
    }

    private static <Data> JPanel createTableWithToolbarPanel(DataSource<Data> dataSource, DataByIdTableModel<Data> tableModel) {
        JPanel actionToolbarPanel = new JPanel();
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{new RunPauseAction(dataSource), new ClearAction(dataSource, tableModel)});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(ID, (ActionGroup)actionGroup, false);
        actionToolbarPanel.setLayout(new BorderLayout());
        actionToolbarPanel.add(toolbar.getComponent());
        TableView<String> table = tableModel.createTable();
        JBScrollPane scrollPane = new JBScrollPane();
        scrollPane.setViewportView((Component)table);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)actionToolbarPanel, "West");
        mainPanel.add((Component)scrollPane, "Center");
        return mainPanel;
    }

    private static <Data> void scheduleRefresh(DataSource<Data> dataSource, ToolWindow toolWindow, DataByIdTableModel<Data> ... tableModels) {
        long refreshRateMs = 500L;
        Runnable refreshRunnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
            if (dataSource.isActive() && toolWindow.isVisible()) {
                List currentData = dataSource.getCurrentData();
                Arrays.stream(tableModels).forEach(model -> model.refresh(currentData));
            }
        });
        ScheduledFuture<?> refreshTask = JobScheduler.getScheduler().scheduleWithFixedDelay(refreshRunnable, 0L, refreshRateMs, TimeUnit.MILLISECONDS);
        Disposer.register((Disposable)toolWindow.getContentManager(), () -> refreshTask.cancel(false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/tracing/ui/InternalTracingToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBeAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ClearAction
    extends AnAction
    implements DumbAware {
        private final DataSource<?> mySource;
        private final DataByIdTableModel<?> myModel;

        private ClearAction(DataSource<?> dataSource, DataByIdTableModel<?> tableModel) {
            this.mySource = dataSource;
            this.myModel = tableModel;
            this.getTemplatePresentation().setIcon(AllIcons.Actions.GC);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            this.mySource.clear();
            this.myModel.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/tracing/ui/InternalTracingToolWindowFactory$ClearAction", "actionPerformed"));
        }
    }

    private static class RunPauseAction
    extends AnAction
    implements DumbAware {
        private final DataSource<?> myDataSource;

        private RunPauseAction(DataSource<?> dataSource) {
            this.myDataSource = dataSource;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RunPauseAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setIcon(this.getCurrentIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RunPauseAction.$$$reportNull$$$0(1);
            }
            if (this.myDataSource.isActive()) {
                this.myDataSource.stop();
            } else {
                this.myDataSource.resume();
            }
        }

        private Icon getCurrentIcon() {
            return this.myDataSource.isActive() ? AllIcons.Actions.Pause : AllIcons.Actions.Resume;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/performancePlugin/tracing/ui/InternalTracingToolWindowFactory$RunPauseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

