/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.awt.Component;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class EnterCommand
extends KeyCodeTypeCommand {
    public static final String PREFIX = "%pressKey";
    @NotNull
    private final Project myProject;
    private String actionID;

    public EnterCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            EnterCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EnterCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    public Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String input = this.getText().substring(PREFIX.length()).trim();
        switch (StringUtil.toUpperCase((String)input)) {
            case "ENTER": {
                this.actionID = "EditorEnter";
                break;
            }
            case "BACKSPACE": {
                this.actionID = "EditorBackSpace";
                break;
            }
            case "TAB": {
                this.actionID = "EditorTab";
                break;
            }
            case "ESCAPE": {
                this.actionID = "EditorEscape";
                break;
            }
            default: {
                actionCallback.reject("Unknown special character. Please use: ENTER, BACKSPACE, ESCAPE or TAB");
                return Promises.toPromise((ActionCallback)actionCallback);
            }
        }
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        if (editor != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> EnterCommand.executeAction(editor, this.actionID), "", null, editor.getDocument());
                actionCallback.setDone();
            });
        } else {
            actionCallback.reject("Editor is not opened");
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String actionId) {
        if (editor == null) {
            EnterCommand.$$$reportNull$$$0(2);
        }
        if (actionId == null) {
            EnterCommand.$$$reportNull$$$0(3);
        }
        AnAction action = ActionManagerEx.getInstanceEx().getAction(actionId);
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)EnterCommand.createEditorContext(editor));
        action.actionPerformed(event);
    }

    private static DataContext createEditorContext(@NotNull Editor editor) {
        if (editor == null) {
            EnterCommand.$$$reportNull$$$0(4);
        }
        Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        Map map = ContainerUtil.newHashMap((Pair)Pair.create((Object)CommonDataKeys.HOST_EDITOR.getName(), (Object)hostEditor), (Pair[])new Pair[]{Pair.createNonNull((Object)CommonDataKeys.EDITOR.getName(), (Object)editor)});
        DataContext parent = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
        return SimpleDataContext.getSimpleContext((Map)map, (DataContext)parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/EnterCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditorContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

