/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import com.jetbrains.performancePlugin.ui.FinishScriptDialog;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class ProjectIndexingComponent
implements DumbService.DumbModeListener {
    public static final String PROFILE_INDEXING_COMPONENT = "performancePlugin.isProfileIndexing";
    public static final String PROFILE_WITH_ASYNC = "performancePlugin.isProfileIndexingWithAsync";
    @NotNull
    private final Project project;

    ProjectIndexingComponent(@NotNull Project project) {
        if (project == null) {
            ProjectIndexingComponent.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    public void enteredDumbMode() {
        try {
            if (this.isProfilingEnabled()) {
                if (!this.profileWithAsync()) {
                    YourKitProfilerHandler.getInstance().startProfiling(this.project.getName(), new ArrayList<String>());
                } else {
                    AsyncProfilerHandler.getInstance().startProfiling(this.project.getName(), new ArrayList<String>());
                }
            }
        }
        catch (Exception e) {
            new ActionCallbackProfilerStopper().reject(e.getMessage());
        }
    }

    public void exitDumbMode() {
        if (this.isProfilingEnabled()) {
            PropertiesComponent.getInstance((Project)this.project).setValue(PROFILE_INDEXING_COMPONENT, false);
            PropertiesComponent.getInstance((Project)this.project).setValue(PROFILE_WITH_ASYNC, false);
            if (ProfilersController.getInstance().isProfilingStarted()) {
                try {
                    ProfilersController.getInstance().getCurrentProfilerHandler().stopProfiling(new ArrayList<String>());
                    ProfilersController.getInstance().setStoppedByScript(true);
                }
                catch (Exception e) {
                    new ActionCallbackProfilerStopper().setRejected();
                }
                ApplicationManager.getApplication().invokeLater(() -> new FinishScriptDialog(this.project).show());
            }
        }
    }

    private boolean isProfilingEnabled() {
        return PropertiesComponent.getInstance((Project)this.project).getBoolean(PROFILE_INDEXING_COMPONENT);
    }

    private boolean profileWithAsync() {
        return PropertiesComponent.getInstance((Project)this.project).getBoolean(PROFILE_WITH_ASYNC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/performancePlugin/ProjectIndexingComponent", "<init>"));
    }
}

