/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.jetbrains.performancePlugin.CommandProvider;
import com.jetbrains.performancePlugin.CreateCommand;
import com.jetbrains.performancePlugin.RunCallbackHandler;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PlaybackRunnerExtended
extends PlaybackRunner
implements Disposable {
    public static final String NOTIFICATION_GROUP = "PerformancePlugin";
    private Project myProject;
    private final NotNullLazyValue<Map<String, CreateCommand>> myExtendedCommands;

    public PlaybackRunnerExtended(String script, PlaybackRunner.StatusCallback callback, @NotNull Project project) {
        if (project == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(0);
        }
        super(script, callback, false, false, true);
        this.myExtendedCommands = new NotNullLazyValue<Map<String, CreateCommand>>(){

            @NotNull
            protected Map<String, CreateCommand> compute() {
                THashMap map = new THashMap();
                for (Pair<String, CreateCommand> pair : CommandProvider.getAllCommands(PlaybackRunnerExtended.this.myProject)) {
                    if (map.containsKey(pair.first)) {
                        throw new IllegalStateException("Command with name " + (String)pair.first + " is already registered");
                    }
                    map.putIfAbsent(pair.first, pair.second);
                }
                THashMap tHashMap = map;
                if (tHashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/performancePlugin/PlaybackRunnerExtended$1", "compute"));
            }
        };
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void dispose() {
        super.dispose();
        this.myProject = null;
    }

    @NotNull
    protected PlaybackCommand createCommand(@NotNull String _command, int line, @NotNull File scriptDir) {
        if (_command == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(1);
        }
        if (scriptDir == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(2);
        }
        String command = _command.replaceAll("[\r\n]+$", "");
        String[] cmdline = command.split("\\s+");
        PlaybackCommand playbackCommand = null;
        if (cmdline.length > 0) {
            String commandName = cmdline[0];
            CreateCommand createCommand = (CreateCommand)((Map)this.myExtendedCommands.getValue()).get(commandName);
            if (createCommand != null && (playbackCommand = createCommand.invoke(command, line)) instanceof AbstractCommand) {
                ((AbstractCommand)playbackCommand).setScriptDir(scriptDir);
            }
        }
        if (playbackCommand == null) {
            playbackCommand = super.createCommand(command, line, scriptDir);
        }
        PlaybackCommand playbackCommand2 = playbackCommand;
        if (playbackCommand2 == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(3);
        }
        return playbackCommand2;
    }

    public ActionCallback run() {
        ActionCallback callback = super.run();
        RunCallbackHandler.applyPatchesToCommandCallback(this.myProject, callback);
        return callback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/PlaybackRunnerExtended";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/PlaybackRunnerExtended";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCommand";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

