/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import a.d.la;
import java.math.BigInteger;

public class RSAEncoder {
    private final BigInteger b;
    private final BigInteger g;
    private final int a;
    private final int d;
    private int e = 0;
    private final BigInteger f;
    private final boolean c;
    private static final long h = la.a(-1943763880730380322L, -4195377008643367190L, null).a(200052475186474L);

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus, int alphabetSize, boolean addDashes) {
        this.b = privateExponent;
        this.g = privateModulus;
        this.c = addDashes;
        int n2 = privateModulus.bitLength();
        this.f = new BigInteger(String.valueOf(alphabetSize));
        int n3 = (int)Math.ceil((double)n2 / Math.log(alphabetSize) * Math.log(2.0));
        if (n3 % 5 != 0) {
            n3 = (n3 / 5 + 1) * 5;
        }
        this.d = n3;
        this.a = n2 / 8 - 1;
    }

    public String encode(byte[] data) {
        byte[] byArray;
        long l2 = h ^ 0x5F9D3AB12B3DL;
        long l3 = l2 ^ 0x57C0D90880EDL;
        int n2 = (int)(l3 >>> 32);
        int n3 = (int)(l3 << 32 >>> 48);
        int n4 = (int)(l3 << 48 >>> 48);
        int n5 = data.length % this.a;
        if (n5 == 0) {
            byArray = data;
        } else {
            byArray = new byte[data.length + this.a - n5];
            System.arraycopy(data, 0, byArray, this.a - n5, data.length);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < byArray.length; i10 += this.a) {
            this.a(byArray, stringBuilder, i10, n2, (short)n3, (short)n4, this.a);
        }
        return stringBuilder.toString();
    }

    private void a(byte[] byArray, StringBuilder stringBuilder, int n2, int n3, short s2, short s3, int n4) {
        long l2 = ((long)n3 << 32 | (long)s2 << 48 >>> 32 | (long)s3 << 48 >>> 48) ^ h;
        if (n4 == 0) {
            return;
        }
        byte[] byArray2 = new byte[this.a];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        if (bigInteger.compareTo(this.g) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.b, this.g);
        this.a(stringBuilder, this.b(bigInteger2));
    }

    private void a(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i10 = 0; i10 < charSequence.length(); ++i10) {
            this.a(stringBuilder);
            stringBuilder.append(charSequence.charAt(i10));
        }
    }

    private CharSequence b(BigInteger bigInteger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < this.d; ++i10) {
            stringBuilder.append(RSAEncoder.a(bigInteger.mod(this.f)));
            bigInteger = bigInteger.divide(this.f);
        }
        return new ReverseCharSequence(stringBuilder);
    }

    private void a(StringBuilder stringBuilder) {
        if (this.e > 0 && this.e % 5 == 0) {
            if (this.e % 30 == 0) {
                stringBuilder.append('\n');
            } else if (this.c) {
                stringBuilder.append('-');
            }
        }
        ++this.e;
    }

    private static char a(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        char c10 = n2 < 10 ? (char)(48 + n2) : (n2 < 36 ? (char)(65 + n2 - 10) : (n2 < 62 ? (char)(97 + n2 - 36) : (char)(33 + n2 - 62)));
        return c10;
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence a;

        public ReverseCharSequence(CharSequence sequence) {
            this.a = sequence;
        }

        public int length() {
            return this.a.length();
        }

        public char charAt(int index) {
            return this.a.charAt(this.a.length() - index - 1);
        }

        public CharSequence subSequence(int start2, int end) {
            int n2 = this.a.length();
            return new ReverseCharSequence(this.a.subSequence(n2 - end, n2 - start2));
        }
    }
}

