/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlUtil;
import java.util.List;

public class XmlMatchUtil {
    private XmlMatchUtil() {
    }

    public static boolean isWhiteSpace(PsiElement element) {
        return element instanceof PsiWhiteSpace || element instanceof XmlText && element.getFirstChild() == element.getLastChild() && element.getFirstChild() instanceof PsiWhiteSpace;
    }

    public static List<PsiElement> getElementsToMatch(XmlTagChild[] elements) {
        SmartList smartList = new SmartList();
        for (XmlTagChild xmlTagChild : elements) {
            if (xmlTagChild instanceof XmlText) {
                for (PsiElement psiElement : xmlTagChild.getChildren()) {
                    if (XmlUtil.isXmlToken((PsiElement)psiElement, (IElementType)XmlTokenType.XML_DATA_CHARACTERS)) {
                        smartList.add(psiElement);
                        continue;
                    }
                    if (!(psiElement instanceof XmlComment)) continue;
                    smartList.add(psiElement);
                }
                continue;
            }
            smartList.add(xmlTagChild);
        }
        return smartList;
    }
}

