/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import a.d.la;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.EdgeCreationPolicyAdapter;
import com.intellij.openapi.graph.impl.builder.GraphBuilderEventHelper;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    private static final Logger e;
    private final Graph2D o;
    private final Graph2DView f;
    private final Project d;
    private final GraphDataMaps<N, E> m;
    private final GraphUpdateModel a;
    private final GraphDataModel<N, E> h;
    private final GraphPresentationModel<N, E> l;
    private final MergingUpdateQueue k;
    private Overview n;
    private boolean i;
    private boolean j;
    private final EditMode c;
    private final HierarchyManager b;
    private final List<CustomGraphUpdater> g;
    private boolean q;
    private GraphBuilderEventHelper p;
    private static final long r;

    public GraphBuilderImpl(Project project, Graph2D graph, Graph2DView view, GraphDataModel<N, E> graphDataModel, GraphPresentationModel<N, E> graphPresentationModel) {
        long l2 = r ^ 0x69A9D72E33C1L;
        this.g = new ArrayList<CustomGraphUpdater>();
        this.q = false;
        this.d = project;
        this.o = graph;
        this.f = view;
        this.m = new GraphDataMaps(this.o);
        this.b = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.h = graphDataModel;
        this.l = graphPresentationModel;
        this.a = new GraphUpdateModel((Graph)graph);
        this.f.setGraph2D(this.getGraph());
        this.c = this.createEditMode();
        this.k = new MergingUpdateQueue("YFiles", 100, true, this.f.getJComponent());
        this.f.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.g();
        this.p = new GraphBuilderEventHelper(this.c, this);
        Disposer.register((Disposable)this, this.h);
        Disposer.register((Disposable)this, this.l);
        Disposer.register((Disposable)this, (Disposable)this.k);
    }

    public final void initialize() {
        this.b();
        this.i = true;
        this.updateGraph();
    }

    public void updateGraph() {
        try {
            this.updateDataModel();
            this.updateView();
        }
        catch (ProcessCanceledException processCanceledException) {
            this.queueUpdate();
        }
    }

    public void updateDataModel() {
        if (!this.a()) {
            this.initialize();
        }
        this.buildModel();
        GraphImplUtil.updateDraggedNodesInfo(this);
        this.b((Graph)this.getGraph());
        this.a((Graph)this.getGraph());
    }

    private void a(Graph graph) {
        Set set = this.getDataMaps().getEdgeObjectDataMap().keySet();
        for (Edge edge : set.toArray(new Edge[set.size()])) {
            if (this.isEdgeWasUpdated(edge)) continue;
            this.getDataMaps().removeEdge(edge);
        }
        for (Edge edge : graph.getEdgeArray()) {
            if (this.isEdgeWasUpdated(edge) || !graph.contains(edge)) continue;
            graph.removeEdge(edge);
        }
    }

    private void a(Graph graph, Edge edge) {
        this.getDataMaps().removeEdge(edge);
        if (graph.contains(edge)) {
            graph.removeEdge(edge);
        }
    }

    private void b(Graph graph) {
        for (Node node : graph.getNodeArray()) {
            if (!this.isNodeWasUpdated(node) && !this.a(node)) {
                this.getDataMaps().removeNode(node);
                graph.removeNode(node);
            }
            if (!this.getHierarchyManager().isFolderNode(node)) continue;
            this.b(this.getHierarchyManager().getInnerGraph(node));
            this.a(this.getHierarchyManager().getInnerGraph(node));
        }
    }

    private void b() {
        this.d();
        this.getGraphPresentationModel().customizeSettings(this.getView(), this.c);
    }

    private void d() {
        Graph2DView graph2DView = this.getView();
        this.c.allowResizeNodes(false);
        this.c.allowNodeCreation(false);
        this.c.showNodeTips(true);
        this.c.showEdgeTips(true);
        this.c.allowEdgeCreation(true);
        this.c.allowMoveLabels(false);
        this.c.allowMovePorts(false);
        this.c.allowMoveSelection(true);
        graph2DView.setAntialiasedPainting(false);
        graph2DView.setFitContentOnResize(true);
        graph2DView.setGridVisible(false);
        graph2DView.setGridResolution(20.0);
        graph2DView.setGridColor(Color.LIGHT_GRAY);
        graph2DView.setGridType(Graph2DView.GRID_POINTS);
        graph2DView.addViewMode((ViewMode)this.c);
    }

    public Overview getOverview() {
        if (this.n == null) {
            this.n = GraphManager.getGraphManager().createOverview(this.getView());
        }
        return this.n;
    }

    protected EditMode createEditMode() {
        GraphEditModeFactory graphEditModeFactory = (GraphEditModeFactory)ServiceManager.getService((Project)this.getProject(), GraphEditModeFactory.class);
        EditMode editMode = graphEditModeFactory.createEditMode(this);
        editMode.setPopupMode((ViewMode)graphEditModeFactory.createPopupMode(this));
        editMode.setCreateEdgeMode(new EdgeCreationPolicyAdapter(this.getGraphPresentationModel().getEdgeCreationPolicy(), this));
        CellEditorMode cellEditorMode = graphEditModeFactory.createCellEditorMode(this);
        editMode.assignNodeLabel(false);
        editMode.setEditNodeMode((ViewMode)cellEditorMode);
        return editMode;
    }

    public void updateView() {
        this.updateRealizers(false);
        this.f();
        this.c();
        this.e();
        for (CustomGraphUpdater customGraphUpdater : this.g) {
            customGraphUpdater.update(this.getGraph(), this.getView());
        }
        this.getGraph().updateViews();
    }

    public void updateRealizers(boolean updateAllNodes) {
        for (Node node : GraphImplUtil.getNodes((Graph)this.getGraph())) {
            if (!GraphImplUtil.isGroupNode(this.getDataMaps(), node) && (updateAllNodes || this.isNodeWasCreated(node))) {
                this.getGraph().setRealizer(node, this.getGraphPresentationModel().getNodeRealizer(this.getNodeObject(node)));
            }
            GraphViewUtil.setRenderedNodeSizes((Graph2D)this.getGraph(), (Graph2DView)this.getView(), (Node)node);
        }
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (this.isEdgeWasCreated(edge)) {
                this.getGraph().setRealizer(edge, this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge)));
                continue;
            }
            this.getGraph().setRealizer(edge, this.getGraph().getRealizer(edge));
        }
    }

    private List<Edge> i() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (!this.isEdgeWasCreated(edge)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    private List<Node> h() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.getGraph().getNodeArray()) {
            if (this.a(node) || !this.isNodeWasCreated(node)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private void f() {
        for (Edge edge : this.getGraph().getEdgeArray()) {
            EdgeLabel[] edgeLabelArray;
            EdgeRealizer edgeRealizer = this.getGraph().getRealizer(edge);
            GraphBuilderImpl.a(edgeRealizer);
            for (EdgeLabel edgeLabel : edgeLabelArray = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge))) {
                edgeRealizer.addLabel(edgeLabel);
            }
        }
    }

    private static void a(EdgeRealizer edgeRealizer) {
        for (int i10 = 0; i10 < edgeRealizer.labelCount(); ++i10) {
            edgeRealizer.removeLabel(edgeRealizer.getLabel(i10));
        }
        edgeRealizer.setLabelText("");
    }

    private void e() {
        if (this.getGraph().getNodeArray().length > 0) {
            GraphUtil.doLayout((GraphBuilder)this);
            GraphViewUtil.updateWorldRect((Graph2DView)this.getView());
            this.getGraph().updateViews();
        }
    }

    public final boolean isUpdating() {
        return this.j;
    }

    public final synchronized void queueUpdate() {
        long l2 = r ^ 0x251B0D848265L;
        if (this.isUpdating()) {
            return;
        }
        final Cursor cursor = this.f.getJComponent().getCursor();
        this.f.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
        this.j = true;
        this.k.queue(new Update("Update"){

            public void run() {
                GraphBuilderImpl.this.updateGraph();
                GraphBuilderImpl.this.j = false;
                GraphBuilderImpl.this.f.getJComponent().setCursor(cursor);
            }
        });
    }

    public GraphDataModel<N, E> getGraphDataModel() {
        return this.h;
    }

    @NotNull
    public String getNodeName(Node node) {
        String string = GraphImplUtil.getNodeName(this.getDataMaps(), node);
        if (string == null) {
            GraphBuilderImpl.a(0);
        }
        return string;
    }

    @Nullable
    public N getNodeObject(Node node) {
        return GraphImplUtil.getNodeObject(this.getDataMaps(), node);
    }

    @Nullable
    public E getEdgeObject(Edge edge) {
        return GraphImplUtil.getEdgeObject(this.getDataMaps(), edge);
    }

    public void buildModel() {
        this.getGraphUpdateModel().clearUpdateModel();
        this.createDataModel();
    }

    public void createDataModel() {
        GraphDataModel<N, E> graphDataModel = this.getGraphDataModel();
        Collection collection = graphDataModel.getNodes();
        for (Object e10 : collection) {
            this.addNode(graphDataModel.getNodeName(e10), e10);
        }
        for (Object e10 : graphDataModel.getEdges()) {
            this.addEdge(graphDataModel.getSourceNode(e10), graphDataModel.getTargetNode(e10), graphDataModel.getEdgeName(e10), e10);
        }
    }

    private void c() {
        NodeList nodeList;
        Object object3;
        Node node;
        NodesGroup nodesGroup2;
        Object object22;
        Collection<N> collection = this.getNodeObjects();
        GraphManager graphManager = GraphManager.getGraphManager();
        HashMap hashMap = new HashMap();
        for (Object object22 : collection) {
            nodesGroup2 = this.getGraphDataModel().getGroup(object22);
            if (nodesGroup2 == null) {
                Graph graph;
                node = this.getNode(object22);
                if (node == null || this.getHierarchyManager().isRootGraph(node.getGraph()) || (object3 = this.getHierarchyManager().getParentNode(node)) == null) continue;
                if (this.getHierarchyManager().isFolderNode(object3)) {
                    graph = node.getGraph();
                    nodeList = graphManager.createNodeList();
                    for (Node node2 : graph.getNodeArray()) {
                        if (this.a(node2)) continue;
                        nodeList.add((Object)node2);
                    }
                    this.getHierarchyManager().unfoldSubgraph(graph, nodeList);
                    continue;
                }
                if (!this.getHierarchyManager().isGroupNode(object3)) continue;
                graph = graphManager.createNodeList();
                graph.add((Object)node);
                this.getHierarchyManager().ungroupSubgraph((NodeList)graph);
                continue;
            }
            if (hashMap.get(nodesGroup2) == null) {
                hashMap.put(nodesGroup2, new ArrayList());
            }
            ((ArrayList)hashMap.get(nodesGroup2)).add(object22);
        }
        ArrayList arrayList = new ArrayList();
        for (NodesGroup nodesGroup2 : hashMap.keySet()) {
            boolean bl2;
            node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.b, nodesGroup2, this.getDataMaps());
            this.getGraphUpdateModel().setNodeWasViewed(node);
            object3 = GraphImplUtil.getGroup(this.getDataMaps(), node);
            boolean bl3 = bl2 = object3 != null ? object3.isClosed() : nodesGroup2.isClosed();
            if (bl2 && this.getHierarchyManager().isGroupNode(node)) {
                arrayList.add(node);
            }
            nodeList = graphManager.createNodeList();
            for (Object e10 : (ArrayList)hashMap.get(nodesGroup2)) {
                nodeList.add((Object)this.getNode(e10));
            }
            if (nodeList.size() <= 0 || !this.b.isGroupNode(node)) continue;
            this.b.groupSubgraph(nodeList, node);
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            nodesGroup2 = (Node)object22.next();
            try {
                this.b.closeGroup((Node)nodesGroup2);
                node = this.getGraph().getRealizer((Node)nodesGroup2);
                if (!(node instanceof GroupNodeRealizer)) continue;
                ((GroupNodeRealizer)node).setGroupClosed(true);
                object3 = this.b.getInnerGraph((Node)nodesGroup2);
                if (!(object3 instanceof Graph2D)) continue;
                this.e();
            }
            catch (Throwable throwable) {
                e.error(throwable);
            }
        }
        for (Object object3 : this.getGraph().getNodeArray()) {
            if (this.isNodeWasUpdated((Node)object3) || !this.a((Node)object3)) continue;
            this.getGraph().removeNode(object3);
        }
    }

    private boolean a(Node node) {
        return this.b.isFolderNode(node) || this.b.isGroupNode(node);
    }

    public void addNode(N nodeObject) {
        String string = this.getGraphDataModel().getNodeName(nodeObject);
        this.addNode(string == null ? nodeObject.toString() : string, nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject) {
        if (name == null) {
            GraphBuilderImpl.a(1);
        }
        this.addNode(name, nodeObject, nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject, Object ... equalityObjects) {
        Node node;
        if (name == null) {
            GraphBuilderImpl.a(2);
        }
        if ((node = GraphImplUtil.getExistedNode(this.getDataMaps(), name, equalityObjects)) != null) {
            if (!this.getGraphUpdateModel().isNodeWasCreated(node)) {
                this.getGraphUpdateModel().setNodeWasViewed(node);
                GraphImplUtil.setNodeName(this.getDataMaps(), node, name);
            }
        } else {
            node = GraphImplUtil.createNode((Graph)this.getGraph(), this.b(nodeObject), this.getDataMaps(), name, equalityObjects);
            this.getGraphUpdateModel().setNodeWasCreated(node);
        }
        GraphImplUtil.setNodeObject(this.getDataMaps(), node, nodeObject);
    }

    @Nullable
    private Graph b(N n2) {
        NodesGroup nodesGroup = this.getGraphDataModel().getGroup(n2);
        if (nodesGroup != null) {
            Node node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), nodesGroup, this.getDataMaps());
            if (this.getHierarchyManager().isFolderNode(node)) {
                return this.getHierarchyManager().getInnerGraph(node);
            }
        }
        return null;
    }

    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(3);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(4);
        }
        return this.addEdge(nodeObject1, nodeObject2, "", edgeObject);
    }

    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, @NotNull String name, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(5);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(6);
        }
        if (name == null) {
            GraphBuilderImpl.a(7);
        }
        return this.a(nodeObject1, nodeObject2, name, edgeObject, edgeObject);
    }

    private Edge a(@NotNull N n2, @NotNull N n3, @NotNull String string, E e10, Object ... objectArray) {
        if (n2 == null) {
            GraphBuilderImpl.a(8);
        }
        if (n3 == null) {
            GraphBuilderImpl.a(9);
        }
        if (string == null) {
            GraphBuilderImpl.a(10);
        }
        Node node = this.a(n2);
        Node node2 = this.a(n3);
        return this.a(node, node2, string, e10, objectArray);
    }

    private Edge a(@NotNull Node node, @NotNull Node node2, @NotNull String string, E e10, Object ... objectArray) {
        Edge edge;
        if (node == null) {
            GraphBuilderImpl.a(11);
        }
        if (node2 == null) {
            GraphBuilderImpl.a(12);
        }
        if (string == null) {
            GraphBuilderImpl.a(13);
        }
        if ((edge = GraphImplUtil.getExistedEdge(this.getDataMaps(), node, node2, string, objectArray)) != null) {
            if (!this.getGraphUpdateModel().isEdgeWasCreated(edge)) {
                this.getGraphUpdateModel().setEdgeWasViewed(edge);
            }
        } else {
            edge = GraphImplUtil.createEdge(this.getDataMaps(), node, node2, string, objectArray);
            this.getGraphUpdateModel().setEdgeWasCreated(edge);
        }
        GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, e10);
        return edge;
    }

    private Node a(N n2) {
        long l2 = r ^ 0x1723EC7D3E71L;
        Node node = this.getNode(n2);
        if (node == null) {
            this.addNode(n2);
            node = this.getNode(n2);
        }
        if (node == null) {
            e.error("null node for " + n2 + " in " + this.h);
        }
        return node;
    }

    public void dispose() {
        this.k.cancelAllUpdates();
        if (this.q) {
            return;
        }
        this.m.dispose();
        this.q = true;
    }

    @Nullable
    public String getNodeName(N nodeObject) {
        Node node = this.getNode(nodeObject);
        return node == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node);
    }

    @Nullable
    public String getEdgeName(E edgeObject) {
        Edge edge = this.getEdge(edgeObject);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(N nodeObject) {
        return GraphImplUtil.getNode(this.getDataMaps(), nodeObject);
    }

    @Nullable
    public Edge getEdge(E edgeObject) {
        return GraphImplUtil.getEdge(this.getDataMaps(), edgeObject);
    }

    public boolean isNodeWasCreated(Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasCreated(node);
    }

    public boolean isEdgeWasCreated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasCreated(edge);
    }

    public boolean isNodeWasUpdated(Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasUpdated(node);
    }

    public boolean isEdgeWasUpdated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasUpdated(edge);
    }

    public final Graph2D getGraph() {
        return this.o;
    }

    public Graph2DView getView() {
        return this.f;
    }

    public Project getProject() {
        return this.d;
    }

    public GraphUpdateModel getGraphUpdateModel() {
        return this.a;
    }

    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        return this.l;
    }

    public double getZoom() {
        return this.getView().getZoom();
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, true);
    }

    public void setZoom(double zoom, boolean fireEvents) {
        if (fireEvents) {
            this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        }
        double d10 = Math.min(Math.max(zoom, 0.1), 20.0);
        Graph2DView graph2DView = this.getView();
        graph2DView.setZoom(d10);
        graph2DView.updateView();
        if (fireEvents) {
            this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
        }
    }

    public void fitContent() {
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        Graph2DView graph2DView = this.getView();
        graph2DView.fitContent();
        graph2DView.updateView();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
    }

    protected void fireEvent(@NotNull GraphBuilderEvent event, boolean before) {
        if (event == null) {
            GraphBuilderImpl.a(14);
        }
        this.p.fireEvent(event, before);
    }

    private boolean a() {
        return this.i;
    }

    private void g() {
        GraphViewUtil.addDataProvider((Graph2DView)this.getView(), string -> {
            if (string.equals(DeleteProvider.GRAPH_DELETE_PROVIDER_KEY)) {
                return this.getGraphPresentationModel().getDeleteProvider();
            }
            if (GraphDataKeys.GRAPH_BUILDER.is(string)) {
                return this;
            }
            return null;
        });
    }

    public HierarchyManager getHierarchyManager() {
        return this.b;
    }

    public void addCustomUpdater(CustomGraphUpdater updater) {
        this.g.add(updater);
    }

    public EditMode getEditMode() {
        return this.c;
    }

    public GraphDataMaps<N, E> getDataMaps() {
        return this.m;
    }

    public Collection<N> getNodeObjects() {
        return this.getDataMaps().getNodeObjectDataMap().values();
    }

    public Collection<E> getEdgeObjects() {
        return this.getDataMaps().getEdgeObjectDataMap().values();
    }

    public boolean removeNode(N n2) {
        Node node = this.getNode(n2);
        if (node != null) {
            this.getDataMaps().removeNode(node);
            node.getGraph().removeNode(node);
            return true;
        }
        return false;
    }

    public boolean removeEdge(E e10) {
        Edge edge = this.getEdge(e10);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    public void addGraphBuilderListener(GraphBuilderListener listener, Disposable parent) {
        this.p.dispatcher.addListener((EventListener)listener, parent);
    }

    public void removeGraphBuilderListener(GraphBuilderListener listener) {
        this.p.dispatcher.removeListener((EventListener)listener);
    }

    static {
        r = la.a(-5111115237049127240L, 5351824563653191886L, MethodHandles.lookup().lookupClass()).a(30263209561820L);
        e = Logger.getInstance(GraphBuilderImpl.class);
        YBundlesInitializer.init();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = r ^ 0x3ACEC2705069L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject1";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

