/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.util;

import a.d.la;
import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.DefaultDuplocatorState;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.dupLocator.MultilanguageDuplocatorSettings;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplocatorUtil {
    private static final long a = la.a(1970712527714949370L, 7131364323165223059L, MethodHandles.lookup().lookupClass()).a(70405588257322L);

    private DuplocatorUtil() {
    }

    public static boolean isIgnoredNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace || element instanceof PsiErrorElement || element instanceof PsiComment) {
            return true;
        }
        if (!(element instanceof LeafElement)) {
            return false;
        }
        if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)element.getText())) {
            return true;
        }
        EquivalenceDescriptorProvider equivalenceDescriptorProvider = EquivalenceDescriptorProvider.getInstance(element);
        if (equivalenceDescriptorProvider == null) {
            return false;
        }
        IElementType iElementType = ((LeafElement)element).getElementType();
        return equivalenceDescriptorProvider.getIgnoredTokens().contains(iElementType);
    }

    public static PsiElement getOnlyChild(PsiElement element, @NotNull NodeFilter filter) {
        FilteringNodeIterator filteringNodeIterator;
        PsiElement psiElement;
        if (filter == null) {
            DuplocatorUtil.a(0);
        }
        if ((psiElement = (filteringNodeIterator = new FilteringNodeIterator(new SiblingNodeIterator(element.getFirstChild()), filter)).current()) != null) {
            filteringNodeIterator.advance();
            if (!filteringNodeIterator.hasNext()) {
                return psiElement;
            }
        }
        return element;
    }

    public static boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
        if (element == null || elementToMatchWith == null) {
            return false;
        }
        if (element.getClass() == elementToMatchWith.getClass()) {
            return false;
        }
        return element.getFirstChild() == null && element.getTextLength() == 0 && !(element instanceof LeafElement);
    }

    @Contract(value="null, _, _ -> null;!null, _, _ -> !null;")
    @Nullable
    public static PsiElement skipNodeIfNecessary(PsiElement element, EquivalenceDescriptor descriptor, NodeFilter filter) {
        EquivalenceDescriptorProvider equivalenceDescriptorProvider;
        if (element == null) {
            return null;
        }
        if (descriptor == null && (equivalenceDescriptorProvider = EquivalenceDescriptorProvider.getInstance(element)) != null) {
            descriptor = equivalenceDescriptorProvider.buildDescriptor(element);
        }
        if (descriptor != null) {
            equivalenceDescriptorProvider = DuplocatorUtil.a(descriptor, filter);
            return equivalenceDescriptorProvider != null ? equivalenceDescriptorProvider : element;
        }
        return DuplocatorUtil.getOnlyChild(element, filter);
    }

    @Nullable
    private static PsiElement a(EquivalenceDescriptor equivalenceDescriptor, NodeFilter nodeFilter) {
        PsiElement[] psiElementArray;
        if (!equivalenceDescriptor.getConstants().isEmpty()) {
            return null;
        }
        List<SingleChildDescriptor> list2 = equivalenceDescriptor.getSingleChildDescriptors();
        List<MultiChildDescriptor> list3 = equivalenceDescriptor.getMultiChildDescriptors();
        List<PsiElement[]> list4 = equivalenceDescriptor.getCodeBlocks();
        if (list2.size() + list3.size() + list4.size() != 1) {
            return null;
        }
        if (!list2.isEmpty()) {
            SingleChildDescriptor singleChildDescriptor = list2.get(0);
            PsiElement psiElement = singleChildDescriptor.getElement();
            if (psiElement != null) {
                SingleChildDescriptor.MyType myType = singleChildDescriptor.getType();
                if (myType == SingleChildDescriptor.MyType.DEFAULT) {
                    return psiElement;
                }
                if (myType == SingleChildDescriptor.MyType.CHILDREN || myType == SingleChildDescriptor.MyType.CHILDREN_IN_ANY_ORDER) {
                    return DuplocatorUtil.getOnlyChild(psiElement, nodeFilter);
                }
            }
        } else if (!list3.isEmpty()) {
            MultiChildDescriptor multiChildDescriptor = list3.get(0);
            PsiElement[] psiElementArray2 = multiChildDescriptor.getElements();
            if (psiElementArray2.length == 1 && multiChildDescriptor.getType() != MultiChildDescriptor.MyType.OPTIONALLY) {
                return psiElementArray2[0];
            }
        } else if (!list4.isEmpty() && (psiElementArray = list4.get(0)) != null && psiElementArray.length == 1) {
            return psiElementArray[0];
        }
        return null;
    }

    public static boolean match(@NotNull EquivalenceDescriptor descriptor1, @NotNull EquivalenceDescriptor descriptor2, @NotNull AbstractMatchingVisitor g10, @NotNull Set<PsiElementRole> skippedRoles, @Nullable DuplicatesProfile profile) {
        PsiElement[] psiElementArray;
        Object object;
        int n2;
        if (descriptor1 == null) {
            DuplocatorUtil.a(1);
        }
        if (descriptor2 == null) {
            DuplocatorUtil.a(2);
        }
        if (g10 == null) {
            DuplocatorUtil.a(3);
        }
        if (skippedRoles == null) {
            DuplocatorUtil.a(4);
        }
        if (descriptor1.getSingleChildDescriptors().size() != descriptor2.getSingleChildDescriptors().size()) {
            return false;
        }
        if (descriptor1.getMultiChildDescriptors().size() != descriptor2.getMultiChildDescriptors().size()) {
            return false;
        }
        if (descriptor1.getCodeBlocks().size() != descriptor2.getCodeBlocks().size()) {
            return false;
        }
        if (descriptor1.getConstants().size() != descriptor2.getConstants().size()) {
            return false;
        }
        int n3 = descriptor1.getConstants().size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = descriptor1.getConstants().get(n2);
            if (Comparing.equal((Object)object, (Object)(psiElementArray = descriptor2.getConstants().get(n2)))) continue;
            return false;
        }
        n3 = descriptor1.getSingleChildDescriptors().size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = descriptor1.getSingleChildDescriptors().get(n2);
            if (DuplocatorUtil.a((SingleChildDescriptor)object, (SingleChildDescriptor)(psiElementArray = descriptor2.getSingleChildDescriptors().get(n2)), g10, skippedRoles, profile)) continue;
            return false;
        }
        n3 = descriptor1.getMultiChildDescriptors().size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = descriptor1.getMultiChildDescriptors().get(n2);
            if (DuplocatorUtil.a((MultiChildDescriptor)object, (MultiChildDescriptor)(psiElementArray = descriptor2.getMultiChildDescriptors().get(n2)), g10)) continue;
            return false;
        }
        n3 = descriptor1.getCodeBlocks().size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = descriptor1.getCodeBlocks().get(n2);
            if (g10.matchSequentially((PsiElement[])object, psiElementArray = descriptor2.getCodeBlocks().get(n2))) continue;
            return false;
        }
        return true;
    }

    private static boolean a(@NotNull SingleChildDescriptor singleChildDescriptor, @NotNull SingleChildDescriptor singleChildDescriptor2, @NotNull AbstractMatchingVisitor abstractMatchingVisitor, @NotNull Set<PsiElementRole> set, @Nullable DuplicatesProfile duplicatesProfile) {
        if (singleChildDescriptor == null) {
            DuplocatorUtil.a(5);
        }
        if (singleChildDescriptor2 == null) {
            DuplocatorUtil.a(6);
        }
        if (abstractMatchingVisitor == null) {
            DuplocatorUtil.a(7);
        }
        if (set == null) {
            DuplocatorUtil.a(8);
        }
        if (singleChildDescriptor.getType() != singleChildDescriptor2.getType()) {
            return false;
        }
        PsiElement psiElement = singleChildDescriptor.getElement();
        PsiElement psiElement2 = singleChildDescriptor2.getElement();
        if (duplicatesProfile != null) {
            PsiElementRole psiElementRole;
            PsiElementRole psiElementRole2 = psiElement != null ? duplicatesProfile.getRole(psiElement) : null;
            PsiElementRole psiElementRole3 = psiElementRole = psiElement2 != null ? duplicatesProfile.getRole(psiElement2) : null;
            if (psiElementRole2 == psiElementRole && set.contains((Object)psiElementRole2)) {
                return true;
            }
        }
        switch (singleChildDescriptor.getType()) {
            case DEFAULT: {
                return abstractMatchingVisitor.match(psiElement, psiElement2);
            }
            case OPTIONALLY_IN_PATTERN: 
            case OPTIONALLY: {
                return abstractMatchingVisitor.matchOptionally(psiElement, psiElement2);
            }
            case CHILDREN: {
                return abstractMatchingVisitor.matchSons(psiElement, psiElement2);
            }
            case CHILDREN_OPTIONALLY_IN_PATTERN: 
            case CHILDREN_OPTIONALLY: {
                return abstractMatchingVisitor.matchSonsOptionally(psiElement, psiElement2);
            }
            case CHILDREN_IN_ANY_ORDER: {
                return abstractMatchingVisitor.matchSonsInAnyOrder(psiElement, psiElement2);
            }
        }
        return false;
    }

    private static boolean a(@NotNull MultiChildDescriptor multiChildDescriptor, @NotNull MultiChildDescriptor multiChildDescriptor2, @NotNull AbstractMatchingVisitor abstractMatchingVisitor) {
        if (multiChildDescriptor == null) {
            DuplocatorUtil.a(9);
        }
        if (multiChildDescriptor2 == null) {
            DuplocatorUtil.a(10);
        }
        if (abstractMatchingVisitor == null) {
            DuplocatorUtil.a(11);
        }
        if (multiChildDescriptor.getType() != multiChildDescriptor2.getType()) {
            return false;
        }
        PsiElement[] psiElementArray = multiChildDescriptor.getElements();
        PsiElement[] psiElementArray2 = multiChildDescriptor2.getElements();
        switch (multiChildDescriptor.getType()) {
            case DEFAULT: {
                return abstractMatchingVisitor.matchSequentially(psiElementArray, psiElementArray2);
            }
            case OPTIONALLY_IN_PATTERN: 
            case OPTIONALLY: {
                return abstractMatchingVisitor.matchOptionally(psiElementArray, psiElementArray2);
            }
            case IN_ANY_ORDER: {
                return abstractMatchingVisitor.matchInAnyOrder(psiElementArray, psiElementArray2);
            }
        }
        return false;
    }

    @Nullable
    @Contract(value="null -> null")
    public static DuplocatorState getDuplocatorState(PsiFragment frag) {
        if (frag == null) {
            return null;
        }
        Language language = frag.getLanguage();
        if (language == null) {
            return null;
        }
        DuplicatesProfile duplicatesProfile = DuplicatesProfile.findProfileForLanguage(language);
        return duplicatesProfile != null ? duplicatesProfile.getDuplocatorState(language) : null;
    }

    @NotNull
    public static ExternalizableDuplocatorState registerAndGetState(@NotNull Language language) {
        MultilanguageDuplocatorSettings multilanguageDuplocatorSettings;
        ExternalizableDuplocatorState externalizableDuplocatorState;
        if (language == null) {
            DuplocatorUtil.a(12);
        }
        if ((externalizableDuplocatorState = (multilanguageDuplocatorSettings = MultilanguageDuplocatorSettings.getInstance()).getState(language)) == null) {
            externalizableDuplocatorState = new DefaultDuplocatorState();
            multilanguageDuplocatorSettings.registerState(language, externalizableDuplocatorState);
        }
        ExternalizableDuplocatorState externalizableDuplocatorState2 = externalizableDuplocatorState;
        if (externalizableDuplocatorState2 == null) {
            DuplocatorUtil.a(13);
        }
        return externalizableDuplocatorState2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x756EE5538414L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor2";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedRoles";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDescriptor1";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDescriptor2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/util/DuplocatorUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/util/DuplocatorUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "registerAndGetState";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyChild";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerAndGetState";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

