/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.Nullable;

public class DuplicatesModel {
    private final TreeSelectionModel e = new DefaultTreeSelectionModel();
    private final MyTreeModel f;
    private final EventDispatcher<Listener> c = EventDispatcher.create(Listener.class);
    private final Project b;
    private GroupNode d;
    private final int[] a = new int[]{-1, -1};

    public DuplicatesModel(DupInfo duplicates, Project project) {
        this.b = project;
        DuplicatesRoot duplicatesRoot = new DuplicatesRoot(duplicates, this);
        this.f = new MyTreeModel(duplicatesRoot);
        this.e.setSelectionMode(1);
        this.e.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e10) {
                DuplicatesModel.this.a();
            }
        });
        this.e.setSelectionPath(new TreePath(new Object[]{duplicatesRoot, duplicatesRoot.getChildAt(0)}));
    }

    @Nullable
    public CodeNode getRight() {
        if (this.d == null) {
            return null;
        }
        return this.d.getChildAt(this.a[1]);
    }

    @Nullable
    public CodeNode getLeft() {
        if (this.d == null) {
            return null;
        }
        return this.d.getChildAt(this.a[0]);
    }

    @Nullable
    private TreeNode b() {
        TreePath treePath = this.e.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (TreeNode)treePath.getLastPathComponent();
    }

    private void a() {
        TreeNode treeNode = this.b();
        GroupNode groupNode = null;
        if (treeNode != null) {
            if (treeNode instanceof GroupNode) {
                groupNode = (GroupNode)treeNode;
            } else {
                TreeNode treeNode2 = treeNode.getParent();
                if (treeNode2 instanceof GroupNode) {
                    groupNode = (GroupNode)treeNode2;
                }
            }
        }
        this.a(groupNode);
    }

    private void a(GroupNode groupNode) {
        if (Comparing.equal((Object)this.d, (Object)groupNode)) {
            return;
        }
        if (groupNode != null) {
            this.a(groupNode, 0, 1);
        } else {
            this.a(null, -1, -1);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.e;
    }

    public void addListener(Listener listener) {
        this.c.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.c.removeListener((EventListener)listener);
    }

    public TreeModel getTreeModel() {
        return this.f;
    }

    public Project getProject() {
        return this.b;
    }

    @Nullable
    public CodeNode getSelectedCodeNode() {
        TreeNode treeNode = this.b();
        return treeNode instanceof CodeNode ? (CodeNode)treeNode : null;
    }

    public DuplicatesRoot getRoot() {
        return this.f.getRoot();
    }

    public void setDiff(int diffIndex, CodeNode codeNode) {
        GroupNode groupNode = codeNode.getParent();
        int n2 = groupNode.getIndexOf(codeNode);
        if (Comparing.equal((Object)groupNode, (Object)this.d)) {
            if (n2 == this.a[diffIndex]) {
                return;
            }
            this.a[diffIndex] = n2;
            ((Listener)this.c.getMulticaster()).onSelectionChanged();
        } else if (diffIndex == 0) {
            this.a(groupNode, n2, 1);
        } else {
            this.a(groupNode, 0, n2);
        }
    }

    private void a(GroupNode groupNode, int n2, int n3) {
        if (Comparing.equal((Object)this.d, (Object)groupNode) && n2 == this.a[0] && n3 == this.a[1]) {
            return;
        }
        this.d = groupNode;
        this.a[0] = n2;
        this.a[1] = n3;
        ((Listener)this.c.getMulticaster()).onSelectionChanged();
    }

    private static class MyTreeModel
    extends DefaultTreeModel {
        MyTreeModel(DuplicatesRoot root) {
            super(root);
        }

        @Override
        public DuplicatesRoot getRoot() {
            return (DuplicatesRoot)super.getRoot();
        }
    }

    public static interface Listener
    extends EventListener {
        public void onSelectionChanged();
    }
}

