/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import a.d.la;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.coverage.actions.HideCoverageInfoAction;
import com.intellij.coverage.actions.ShowCoveringTestsAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Function;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageLineMarkerRenderer
implements ActiveGutterRenderer,
LineMarkerRendererWithErrorStripe {
    private static final int h = 8;
    private final TextAttributesKey f;
    private final String g;
    private final TreeMap<Integer, LineData> e;
    private final boolean a;
    private final Function<? super Integer, Integer> d;
    private final Function<? super Integer, Integer> j;
    private final CoverageSuitesBundle c;
    private final boolean i;
    private final int b;
    private static final long k = la.a(-6422454214213402125L, -9161676701302488359L, MethodHandles.lookup().lookupClass()).a(98104000913499L);

    protected CoverageLineMarkerRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, CoverageSuitesBundle coverageSuite, boolean subCoverageActive) {
        this.f = CoverageLineMarkerRenderer.getAttributesKey(lineNumber, lines);
        this.b = lineNumber;
        this.g = className;
        this.e = lines;
        this.a = coverageByTestApplicable;
        this.d = newToOldConverter;
        this.j = oldToNewConverter;
        this.c = coverageSuite;
        this.i = subCoverageActive;
    }

    private int a(@NotNull Editor editor, Point point) {
        if (editor == null) {
            CoverageLineMarkerRenderer.a(0);
        }
        if (this.b > -1) {
            return this.b;
        }
        return editor.xyToLogicalPosition((Point)point).line;
    }

    public void paint(Editor editor, Graphics g10, Rectangle r2) {
        TextAttributes textAttributes = editor.getColorsScheme().getAttributes(this.f);
        Color color = textAttributes.getBackgroundColor();
        if (color == null) {
            color = textAttributes.getForegroundColor();
        }
        if (color != null) {
            g10.setColor(color);
        }
        g10.fillRect(r2.x, r2.y, r2.width, r2.height);
        LineData lineData = this.getLineData(this.a(editor, new Point(0, r2.y)));
        if (lineData != null && lineData.isCoveredByOneTest()) {
            AllIcons.Gutter.Unique.paintIcon(editor.getComponent(), g10, r2.x, r2.y);
        }
    }

    public static CoverageLineMarkerRenderer getRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (coverageSuite == null) {
            CoverageLineMarkerRenderer.a(1);
        }
        return new CoverageLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, newToOldConverter, oldToNewConverter, coverageSuite, subCoverageActive);
    }

    public static TextAttributesKey getAttributesKey(int lineNumber, TreeMap<Integer, LineData> lines) {
        return CoverageLineMarkerRenderer.a(lines.get(lineNumber));
    }

    private static TextAttributesKey a(LineData lineData) {
        if (lineData != null) {
            switch (lineData.getStatus()) {
                case 2: {
                    return CodeInsightColors.LINE_FULL_COVERAGE;
                }
                case 1: {
                    return CodeInsightColors.LINE_PARTIAL_COVERAGE;
                }
            }
        }
        return CodeInsightColors.LINE_NONE_COVERAGE;
    }

    public boolean canDoAction(@NotNull MouseEvent e10) {
        Component component;
        if (e10 == null) {
            CoverageLineMarkerRenderer.a(2);
        }
        if ((component = e10.getComponent()) instanceof EditorGutterComponentEx) {
            EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)component;
            return e10.getX() > editorGutterComponentEx.getLineMarkerAreaOffset() && e10.getX() < editorGutterComponentEx.getIconAreaOffset();
        }
        return false;
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e10) {
        if (editor == null) {
            CoverageLineMarkerRenderer.a(3);
        }
        if (e10 == null) {
            CoverageLineMarkerRenderer.a(4);
        }
        e10.consume();
        JComponent jComponent = (JComponent)e10.getComponent();
        JRootPane jRootPane = jComponent.getRootPane();
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        Point point = SwingUtilities.convertPoint(jComponent, 8, e10.getY(), jLayeredPane);
        this.a(editor, point, this.a(editor, e10.getPoint()));
    }

    private void a(Editor editor, Point point, int n2) {
        EditorImpl editorImpl;
        Object object;
        Object object2;
        long l2 = k ^ 0x6522E549693FL;
        JPanel jPanel = new JPanel(new BorderLayout());
        final Disposable disposable = new Disposable(){

            public void dispose() {
            }
        };
        jPanel.add((Component)this.createActionsToolbar(editor, n2, disposable), "North");
        LineData lineData = this.getLineData(n2);
        if (lineData != null && lineData.getStatus() != 0 && !this.i) {
            object2 = EditorFactory.getInstance();
            object = object2.createDocument((CharSequence)this.a(editor, n2));
            object.setReadOnly(true);
            editorImpl = (EditorImpl)object2.createEditor(object, editor.getProject());
            jPanel.add((Component)EditorFragmentComponent.createEditorFragmentComponent((Editor)editorImpl, (int)0, (int)object.getLineCount(), (boolean)false, (boolean)false), "Center");
        } else {
            editorImpl = null;
        }
        object2 = new LightweightHint(jPanel){

            public void hide() {
                if (editorImpl != null) {
                    EditorFactory.getInstance().releaseEditor((Editor)editorImpl);
                }
                Disposer.dispose((Disposable)disposable);
                super.hide();
            }
        };
        object = HintManagerImpl.getHintPosition((LightweightHint)object2, (Editor)editor, (LogicalPosition)new LogicalPosition(n2, 0), (short)2);
        if (point != null) {
            object.x = point.x;
            object.y = point.y + Math.abs(object.y - point.y) % editor.getLineHeight();
        } else {
            Point point2 = editor.visualPositionToXY(editor.offsetToVisualPosition(0));
            EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)editor.getGutter();
            JLayeredPane jLayeredPane = editorGutterComponentEx.getRootPane().getLayeredPane();
            object.x = SwingUtilities.convertPoint((Component)editorGutterComponentEx, (int)8, (int)point2.y, (Component)jLayeredPane).x;
        }
        HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)object2, editor, (Point)object, 58, -1, false, new HintHint(editor, (Point)object));
    }

    private String a(Editor editor, int n2) {
        LineData lineData = this.getLineData(n2);
        Document document = editor.getDocument();
        Project project = editor.getProject();
        assert (project != null);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        assert (psiFile != null);
        int n3 = document.getLineStartOffset(n2);
        int n4 = document.getLineEndOffset(n2);
        return this.c.getCoverageEngine().generateBriefReport(editor, psiFile, n2, n3, n4, lineData);
    }

    protected JComponent createActionsToolbar(Editor editor, int lineNumber, Disposable parent) {
        AnAction anAction;
        long l2 = k ^ 0x4B8BBBE46D9BL;
        JComponent jComponent = editor.getComponent();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        GotoPreviousCoveredLineAction gotoPreviousCoveredLineAction = new GotoPreviousCoveredLineAction(this, editor, lineNumber);
        GotoNextCoveredLineAction gotoNextCoveredLineAction = new GotoNextCoveredLineAction(this, editor, lineNumber);
        defaultActionGroup.add((AnAction)gotoPreviousCoveredLineAction);
        defaultActionGroup.add((AnAction)gotoNextCoveredLineAction);
        gotoPreviousCoveredLineAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(38, 9)), jComponent);
        gotoNextCoveredLineAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 9)), jComponent);
        Disposer.register((Disposable)parent, () -> {
            gotoPreviousCoveredLineAction.unregisterCustomShortcutSet(jComponent);
            gotoNextCoveredLineAction.unregisterCustomShortcutSet(jComponent);
        });
        LineData lineData = this.getLineData(lineNumber);
        if (this.a) {
            defaultActionGroup.add((AnAction)new ShowCoveringTestsAction(this.g, lineData));
        }
        if ((anAction = ActionManager.getInstance().getAction("ByteCodeViewer")) != null) {
            defaultActionGroup.add(anAction);
        }
        defaultActionGroup.add((AnAction)new EditCoverageColorsAction(this, editor, lineNumber));
        defaultActionGroup.add((AnAction)new HideCoverageInfoAction());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)defaultActionGroup, true);
        JComponent jComponent2 = actionToolbar.getComponent();
        Color color = ((EditorEx)editor).getBackgroundColor();
        Color color2 = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        jComponent2.setBackground(color);
        jComponent2.setBorder((Border)new ColoredSideBorder(color2, color2, lineData == null || lineData.getStatus() == 0 || this.i ? color2 : null, color2, 1));
        actionToolbar.updateActionsImmediately();
        return jComponent2;
    }

    public void moveToLine(int lineNumber, Editor editor) {
        int n2 = editor.getDocument().getLineStartOffset(lineNumber);
        editor.getCaretModel().moveToOffset(n2);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        editor.getScrollingModel().runActionOnScrollingFinished(() -> this.a(editor, null, lineNumber));
    }

    @Nullable
    public LineData getLineData(int lineNumber) {
        return this.e != null ? this.e.get(this.d != null ? (Integer)this.d.fun((Object)lineNumber) : lineNumber) : null;
    }

    @Override
    public Color getErrorStripeColor(Editor editor) {
        return editor.getColorsScheme().getAttributes(this.f).getErrorStripeColor();
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.LEFT;
        if (position == null) {
            CoverageLineMarkerRenderer.a(5);
        }
        return position;
    }

    @NotNull
    public String getAccessibleName() {
        long l2 = k ^ 0x3714E9BC21L;
        String string = CoverageBundle.message("marker.code.coverage", new Object[0]);
        if (string == null) {
            CoverageLineMarkerRenderer.a(6);
        }
        return string;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x71A12F79E9EDL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentLineNumber";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditCoverageColorsAction
    extends AnAction {
        private final Editor b;
        private final int a;
        final /* synthetic */ CoverageLineMarkerRenderer this$0;
        private static final long c = la.a(7205047189696429200L, 6986367114462764589L, MethodHandles.lookup().lookupClass()).a(1068446285166L);

        private EditCoverageColorsAction(CoverageLineMarkerRenderer coverageLineMarkerRenderer, Editor editor, int lineNumber) {
            long l2 = c ^ 0x536FCF16AC99L;
            this.this$0 = coverageLineMarkerRenderer;
            super(CoverageBundle.message("coverage.edit.colors.action.name", new Object[0]), CoverageBundle.message("coverage.edit.colors.description", new Object[0]), AllIcons.General.Settings);
            this.b = editor;
            this.a = lineNumber;
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                EditCoverageColorsAction.a(0);
            }
            e10.getPresentation().setVisible(this.this$0.getLineData(this.a) != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e10) {
            long l2 = c ^ 0x11452533F195L;
            if (e10 == null) {
                EditCoverageColorsAction.a(1);
            }
            final GeneralColorsPage generalColorsPage = new GeneralColorsPage();
            final String string = "Editor | " + ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]) + " | " + generalColorsPage.getDisplayName();
            ColorAndFontOptions colorAndFontOptions = new ColorAndFontOptions(){

                protected List<ColorAndFontPanelFactory> createPanelFactories() {
                    ColorAndFontPanelFactory colorAndFontPanelFactory = new ColorAndFontPanelFactory(){
                        private static final long a = la.a(312611460431028396L, -4461198799014885995L, MethodHandles.lookup().lookupClass()).a(223740703506785L);

                        @NotNull
                        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                            if (options == null) {
                                1.a(0);
                            }
                            SimpleEditorPreview simpleEditorPreview = new SimpleEditorPreview(options, (ColorSettingsPage)generalColorsPage);
                            NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create((PreviewPanel)simpleEditorPreview, (String)generalColorsPage.getDisplayName(), (ColorAndFontOptions)options, null, (ColorSettingsPage)generalColorsPage);
                            if (newColorAndFontPanel == null) {
                                1.a(1);
                            }
                            return newColorAndFontPanel;
                        }

                        @NotNull
                        public String getPanelDisplayName() {
                            String string = string;
                            if (string == null) {
                                1.a(2);
                            }
                            return string;
                        }

                        private static /* synthetic */ void a(int n2) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n3;
                            String string;
                            long l2 = a ^ 0x6B5D1A893060L;
                            switch (n2) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    n3 = 3;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    n3 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n3];
                            switch (n2) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "options";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction$1$1";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "createPanel";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getPanelDisplayName";
                                    break;
                                }
                            }
                            switch (n2) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "createPanel";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n2) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    };
                    return Collections.singletonList(colorAndFontPanelFactory);
                }
            };
            Configurable[] configurableArray = colorAndFontOptions.buildConfigurables();
            try {
                Configurable[] configurableArray2 = colorAndFontOptions.findPage(string);
                SearchableConfigurable searchableConfigurable = colorAndFontOptions.findSubConfigurable(GeneralColorsPage.class);
                if (searchableConfigurable != null && configurableArray2 != null) {
                    LineData lineData = this.this$0.getLineData(this.a);
                    ShowSettingsUtil.getInstance().editConfigurable(this.b.getProject(), (Configurable)searchableConfigurable, () -> EditCoverageColorsAction.a((NewColorAndFontPanel)configurableArray2, lineData));
                }
            }
            finally {
                for (Configurable configurable : configurableArray) {
                    configurable.disposeUIResources();
                }
                colorAndFontOptions.disposeUIResources();
            }
        }

        private static /* synthetic */ void a(NewColorAndFontPanel newColorAndFontPanel, LineData lineData) {
            newColorAndFontPanel.selectOptionByType(CoverageLineMarkerRenderer.a(lineData).getExternalName());
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x5766CA35E401L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class BaseGotoCoveredLineAction
    extends AnAction {
        private final Editor a;
        private final int b;
        private static final long c = la.a(3258887192278349457L, -8344087256413916230L, MethodHandles.lookup().lookupClass()).a(248426912806053L);

        BaseGotoCoveredLineAction(Editor editor, int lineNumber) {
            this.a = editor;
            this.b = lineNumber;
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            Integer n2;
            if (e10 == null) {
                BaseGotoCoveredLineAction.a(0);
            }
            if ((n2 = this.a()) != null) {
                CoverageLineMarkerRenderer.this.moveToLine(n2, this.a);
            }
        }

        protected abstract int next(int var1, int var2);

        @Nullable
        private Integer a() {
            Integer n2;
            block3: {
                int n3;
                ArrayList arrayList = new ArrayList(CoverageLineMarkerRenderer.this.e.keySet());
                Collections.sort(arrayList);
                int n4 = arrayList.size();
                LineData lineData = CoverageLineMarkerRenderer.this.getLineData(this.b);
                int n5 = lineData != null ? lineData.getStatus() : 0;
                int n6 = arrayList.indexOf(CoverageLineMarkerRenderer.this.d != null ? (Integer)CoverageLineMarkerRenderer.this.d.fun((Object)this.b) : this.b);
                if (n6 < 0) {
                    return null;
                }
                while (true) {
                    int n7;
                    Integer n8;
                    if ((n8 = (Integer)arrayList.get(n7 = this.next(n6, n4))) == this.b) {
                        return null;
                    }
                    LineData lineData2 = CoverageLineMarkerRenderer.this.getLineData(n8);
                    n6 = n7;
                    if (lineData2 == null || lineData2.getStatus() == n5) continue;
                    n2 = (Integer)arrayList.get(n6);
                    if (CoverageLineMarkerRenderer.this.j == null) break block3;
                    n3 = (Integer)CoverageLineMarkerRenderer.this.j.fun((Object)n2);
                    if (n3 != 0) break;
                }
                return n3;
            }
            return n2;
        }

        @Nullable
        protected String getNextChange() {
            LineData lineData;
            long l2 = c ^ 0xFBF0A809891L;
            Integer n2 = this.a();
            if (n2 != null && (lineData = CoverageLineMarkerRenderer.this.getLineData(n2)) != null) {
                switch (lineData.getStatus()) {
                    case 0: {
                        return CoverageBundle.message("coverage.next.change.uncovered", new Object[0]);
                    }
                    case 1: {
                        return CoverageBundle.message("coverage.next.change.partial.covered", new Object[0]);
                    }
                    case 2: {
                        return CoverageBundle.message("coverage.next.change.fully.covered", new Object[0]);
                    }
                }
            }
            return null;
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                BaseGotoCoveredLineAction.a(1);
            }
            e10.getPresentation().setEnabled(this.a() != null);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = c ^ 0x7B0710D7536AL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$BaseGotoCoveredLineAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GotoNextCoveredLineAction
    extends BaseGotoCoveredLineAction {
        final /* synthetic */ CoverageLineMarkerRenderer this$0;
        private static final long d = la.a(-8112103398456015927L, -2002269319118804544L, MethodHandles.lookup().lookupClass()).a(206635120205028L);

        GotoNextCoveredLineAction(CoverageLineMarkerRenderer coverageLineMarkerRenderer, Editor editor, int lineNumber) {
            long l2 = d ^ 0x35D0EDDC44A4L;
            this.this$0 = coverageLineMarkerRenderer;
            super(editor, lineNumber);
            this.copyFrom(ActionManager.getInstance().getAction("NextOccurence"));
            this.getTemplatePresentation().setText(CoverageBundle.message("coverage.next.mark", new Object[0]));
        }

        @Override
        protected int next(int idx, int size) {
            if (idx == size - 1) {
                return 0;
            }
            return idx + 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e10) {
            long l2 = d ^ 0x6A4A5CF6EB82L;
            if (e10 == null) {
                GotoNextCoveredLineAction.b(0);
            }
            super.update(e10);
            String string = this.getNextChange();
            if (string != null) {
                e10.getPresentation().setText(CoverageBundle.message("coverage.next.place", string));
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = d ^ 0x33CF8D646B92L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageLineMarkerRenderer$GotoNextCoveredLineAction", "update"));
        }
    }

    private class GotoPreviousCoveredLineAction
    extends BaseGotoCoveredLineAction {
        final /* synthetic */ CoverageLineMarkerRenderer this$0;
        private static final long d = la.a(-2611172471082393063L, 4498633169854050791L, MethodHandles.lookup().lookupClass()).a(14566202123792L);

        GotoPreviousCoveredLineAction(CoverageLineMarkerRenderer coverageLineMarkerRenderer, Editor editor, int lineNumber) {
            long l2 = d ^ 0x51EF556BE9EFL;
            this.this$0 = coverageLineMarkerRenderer;
            super(editor, lineNumber);
            ActionUtil.copyFrom((AnAction)this, (String)"PreviousOccurence");
            this.getTemplatePresentation().setText(CoverageBundle.message("coverage.previous.mark", new Object[0]));
        }

        @Override
        protected int next(int idx, int size) {
            if (idx <= 0) {
                return size - 1;
            }
            return idx - 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e10) {
            long l2 = d ^ 0x40DA6B4D0EA7L;
            if (e10 == null) {
                GotoPreviousCoveredLineAction.b(0);
            }
            super.update(e10);
            String string = this.getNextChange();
            if (string != null) {
                e10.getPresentation().setText(CoverageBundle.message("coverage.previous.place", string));
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = d ^ 0x3F93A43C0B72L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageLineMarkerRenderer$GotoPreviousCoveredLineAction", "update"));
        }
    }
}

