/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.fixes.RemoveElementAction;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssNegativeValueInspection
extends CssBaseInspection {
    @NonNls
    private static final String MARGIN_PROPERTY_NAME = "margin";
    @NonNls
    private static final String PADDING_PROPERTY_NAME = "padding";
    @NonNls
    private static final String LETTER_SPACING_PROPERTY_NAME = "letter-spacing";
    @NonNls
    private static final String WORD_SPACING_PROPERTY_NAME = "word-spacing";
    @NonNls
    private static final String TEXT_INDENT_PROPERTY_NAME = "text-indent";
    @NonNls
    private static final String TOP_PROPERTY_NAME = "top";
    @NonNls
    private static final String RIGHT_PROPERTY_NAME = "right";
    @NonNls
    private static final String BOTTOM_PROPERTY_NAME = "bottom";
    @NonNls
    private static final String LEFT_PROPERTY_NAME = "left";
    @NonNls
    private static final String BACKGROUND_POSITION_PROPERTY_NAME = "background-position";
    @NonNls
    private static final String BACKGROUND_PROPERTY_NAME = "background";
    @NonNls
    private static final String VERTICAL_ALIGN = "vertical-align";
    @NonNls
    private static final String BOX_SHADOW_PROPERTY_NAME = "box-shadow";
    @NonNls
    private static final String Z_INDEX = "z-index";
    @NonNls
    private static final String OUTLINE_OFFSET_PROPERTY_NAME = "outline-offset";
    @NonNls
    private static final String TEXT_SHADOW_PROPERTY_NAME = "text-shadow";
    @NonNls
    private static final String COUNTER_INCREMENT_PROPERTY_NAME = "counter-increment";
    @NonNls
    private static final String COUNTER_RESET_PROPERTY_NAME = "counter-reset";
    @NonNls
    private static final String ORDER_PROPERTY_NAME = "order";

    private static boolean isNegativeAllowed(@NotNull String propertyName, PsiElement element) {
        if (propertyName == null) {
            CssNegativeValueInspection.$$$reportNull$$$0(0);
        }
        if (BOX_SHADOW_PROPERTY_NAME.equals(propertyName)) {
            CssTerm term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class);
            if (term == null) {
                return false;
            }
            PsiElement parent = term.getParent();
            if (!(parent instanceof CssTermList)) {
                return false;
            }
            CssTermList termList = (CssTermList)parent;
            int index = 0;
            for (PsiElement child = termList.getFirstChild(); child != null && child != term; child = child.getNextSibling()) {
                CssTermType termType;
                if (!(child instanceof CssTerm) || (termType = ((CssTerm)child).getTermType()) != CssTermTypes.NUMBER && termType != CssTermTypes.NEGATIVE_NUMBER && termType != CssTermTypes.LENGTH && termType != CssTermTypes.NEGATIVE_LENGTH) continue;
                ++index;
            }
            return index != 2;
        }
        return propertyName.contains(MARGIN_PROPERTY_NAME) || propertyName.contains(PADDING_PROPERTY_NAME) || LETTER_SPACING_PROPERTY_NAME.equals(propertyName) || WORD_SPACING_PROPERTY_NAME.equals(propertyName) || TEXT_INDENT_PROPERTY_NAME.equals(propertyName) || TOP_PROPERTY_NAME.equals(propertyName) || RIGHT_PROPERTY_NAME.equals(propertyName) || BOTTOM_PROPERTY_NAME.equals(propertyName) || BACKGROUND_POSITION_PROPERTY_NAME.equals(propertyName) || BACKGROUND_PROPERTY_NAME.equals(propertyName) || LEFT_PROPERTY_NAME.equals(propertyName) || VERTICAL_ALIGN.equals(propertyName) || Z_INDEX.equals(propertyName) || OUTLINE_OFFSET_PROPERTY_NAME.equals(propertyName) || TEXT_SHADOW_PROPERTY_NAME.equals(propertyName) || COUNTER_INCREMENT_PROPERTY_NAME.equals(propertyName) || COUNTER_RESET_PROPERTY_NAME.equals(propertyName) || ORDER_PROPERTY_NAME.equals(propertyName);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CssNegativeValueInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssNegativeValueInspection.$$$reportNull$$$0(2);
        }
        return new CssElementVisitor(){

            public void visitCssString(CssString _string) {
                CssNegativeValueInspection.processElement((PsiElement)_string, holder);
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof CssTokenImpl) {
                    CssNegativeValueInspection.processElement(element, holder);
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/CssNegativeValueInspection$1", "visitElement"));
            }
        };
    }

    private static boolean isUnknownProperty(@NotNull PsiElement element) {
        PsiReference[] references;
        if (element == null) {
            CssNegativeValueInspection.$$$reportNull$$$0(3);
        }
        for (PsiReference reference : references = element.getFirstChild().getReferences()) {
            PsiElement psiElement = reference.resolve();
            if (psiElement != null) continue;
            return true;
        }
        return false;
    }

    private static void processElement(@NotNull PsiElement element, @NotNull ProblemsHolder holder) {
        CssDescriptorOwner parent;
        if (element == null) {
            CssNegativeValueInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            CssNegativeValueInspection.$$$reportNull$$$0(5);
        }
        ASTNode node = element.getNode();
        assert (node != null);
        if (CssElementTypes.CSS_MINUS == node.getElementType() && (parent = (CssDescriptorOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{CssDeclaration.class, CssFunction.class})) instanceof CssDeclaration && !((CssDeclaration)parent).isCustomProperty()) {
            CssDeclaration declaration = (CssDeclaration)parent;
            CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)declaration);
            if (descriptorProvider == null || !descriptorProvider.providesClassicCss()) {
                return;
            }
            String propertyName = declaration.getPropertyName();
            CssPropertyDescriptor propertyDescriptor = descriptorProvider.getPropertyDescriptor(propertyName, (PsiElement)declaration);
            if (propertyDescriptor != null) {
                propertyName = propertyDescriptor.toCanonicalName(propertyName);
            }
            if (!(CssNegativeValueInspection.isNegativeAllowed(propertyName, element) || CssNegativeValueInspection.isUnknownProperty((PsiElement)declaration) || CssPropertyUtil.isVendorSpecificElement(propertyName))) {
                PsiElement sibling = element.getNextSibling();
                if (sibling instanceof PsiWhiteSpace) {
                    sibling = sibling.getNextSibling();
                }
                if (sibling != null && sibling.getNode().getElementType() == CssElementTypes.CSS_NUMBER_TERM) {
                    ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor(element, sibling, CssBundle.message((String)"css.inspections.negative.value.text", (Object[])new Object[]{propertyName}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, holder.isOnTheFly(), new LocalQuickFix[]{new RemoveElementAction(element.getText())});
                    holder.registerProblem(descriptor);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssNegativeValueInspection";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssNegativeValueInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNegativeAllowed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownProperty";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

