/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssMediaGroupAwareDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper;
import com.intellij.psi.css.impl.descriptor.visitor.CssParameterInfoValueDescriptorsVisitor;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssInspectionFilter;
import com.intellij.psi.css.parameterinfo.CssParameterInfoValueDescriptorComparator;
import com.intellij.psi.css.resolve.CssValueReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class CssInspectionsUtil {
    public static void checkForTotalUnresolved(@NotNull PsiElement psiElement, ProblemsHolder holder, String message) {
        if (psiElement == null) {
            CssInspectionsUtil.$$$reportNull$$$0(0);
        }
        CssInspectionsUtil.checkForTotalUnresolved(psiElement, psiElement, holder, message);
    }

    public static void checkForTotalUnresolved(@NotNull PsiElement psiElement, @NotNull PsiElement highlightingElement, ProblemsHolder holder, String message) {
        PsiReference[] references;
        if (psiElement == null) {
            CssInspectionsUtil.$$$reportNull$$$0(1);
        }
        if (highlightingElement == null) {
            CssInspectionsUtil.$$$reportNull$$$0(2);
        }
        boolean hasProblem = (references = psiElement.getReferences()).length > 0;
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                if (((PsiPolyVariantReference)reference).multiResolve(false).length <= 0) continue;
                hasProblem = false;
                continue;
            }
            if (reference.resolve() == null) continue;
            hasProblem = false;
        }
        if (hasProblem) {
            holder.registerProblem(highlightingElement, message, new LocalQuickFix[0]);
        }
    }

    public static void checkForProperlyResolving(PsiElement psiElement, ProblemsHolder holder, String message) {
        CssInspectionsUtil.checkForProperlyResolving(psiElement, psiElement, holder, message);
    }

    public static void checkForProperlyResolving(PsiElement psiElement, PsiElement highlightingElement, ProblemsHolder holder, String message) {
        PsiReference[] references = psiElement.getReferences();
        boolean hasProblem = false;
        Set<VirtualFile> importedFiles = null;
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] resolveResults = ((PsiPolyVariantReference)reference).multiResolve(false);
                hasProblem = resolveResults.length > 0;
                for (ResolveResult resolveResult : resolveResults) {
                    if (!resolveResult.isValidResult()) continue;
                    hasProblem = false;
                }
                continue;
            }
            PsiElement resolveResult = reference.resolve();
            if (resolveResult == null) continue;
            hasProblem = true;
            PsiFile file = resolveResult.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            if (importedFiles == null) {
                importedFiles = CssUtil.getImportedFiles(file, psiElement, false);
            }
            if (virtualFile == null || !importedFiles.contains(virtualFile)) continue;
            hasProblem = false;
        }
        if (hasProblem) {
            holder.registerProblem(highlightingElement, message, new LocalQuickFix[0]);
        }
    }

    public static boolean isPureCssPropertyName(@Nullable PsiElement propertyNameElement) {
        if (propertyNameElement == null || !propertyNameElement.isValid()) {
            return false;
        }
        for (PsiElement prevSibling = propertyNameElement.getPrevSibling(); prevSibling != null && !(prevSibling instanceof PsiWhiteSpace) && prevSibling.getNode().getElementType() != CssElementTypes.CSS_COLON; prevSibling = prevSibling.getPrevSibling()) {
            if (prevSibling.getLanguage().is((Language)CSSLanguage.INSTANCE)) continue;
            return false;
        }
        for (PsiElement nextSibling = propertyNameElement.getNextSibling(); nextSibling != null && !(nextSibling instanceof PsiWhiteSpace) && nextSibling.getNode().getElementType() != CssElementTypes.CSS_COLON; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling.getLanguage().is((Language)CSSLanguage.INSTANCE)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> filterDescriptorsByContextAndCheck(@NotNull Collection<T> descriptors, @NotNull PsiElement nameIdentifier, @NotNull ProblemsHolder holder) {
        Collection filteredByContextDescriptors;
        if (descriptors == null) {
            CssInspectionsUtil.$$$reportNull$$$0(3);
        }
        if (nameIdentifier == null) {
            CssInspectionsUtil.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(5);
        }
        if ((filteredByContextDescriptors = CssDescriptorsUtil.filterDescriptorsByContext(descriptors, (PsiElement)nameIdentifier)).isEmpty()) {
            HashMap name2AtRuleTypes = Maps.newHashMap();
            for (CssElementDescriptor cssElementDescriptor : descriptors) {
                Object[] allowedInRules = cssElementDescriptor.getAllowedContextTypes();
                String presentableText = cssElementDescriptor.getElementTypeName() + " <code>" + cssElementDescriptor.getPresentableName() + "</code>";
                if (!name2AtRuleTypes.containsKey(presentableText)) {
                    name2AtRuleTypes.put(presentableText, Sets.newHashSet((Object[])allowedInRules));
                    continue;
                }
                ((Set)name2AtRuleTypes.get(presentableText)).addAll(Sets.newHashSet((Object[])allowedInRules));
            }
            for (Map.Entry entry : name2AtRuleTypes.entrySet()) {
                TreeSet rules = new TreeSet(CssContextType.COMPARATOR);
                rules.addAll((Collection)entry.getValue());
                String errorMessage = rules.size() > 0 && !rules.contains(CssContextType.ANY) ? CssBundle.message((String)"css.inspections.wrong.context", (Object[])new Object[]{entry.getKey(), StringUtil.join(rules, (String)", ")}) : CssBundle.message((String)"css.inspections.element.not.allowed.here", (Object[])new Object[]{entry.getKey()});
                holder.registerProblem(nameIdentifier, errorMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
        Collection collection = filteredByContextDescriptors;
        if (collection == null) {
            CssInspectionsUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public static <T extends CssMediaGroupAwareDescriptor> Collection<T> filterDescriptorsByMediaTypeAndCheck(@NotNull Collection<T> descriptors, @NotNull PsiElement nameIdentifier, @NotNull ProblemsHolder holder) {
        Collection filteredByMediaTypeDescriptors;
        if (descriptors == null) {
            CssInspectionsUtil.$$$reportNull$$$0(7);
        }
        if (nameIdentifier == null) {
            CssInspectionsUtil.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(9);
        }
        if ((filteredByMediaTypeDescriptors = CssDescriptorsUtil.filterDescriptorsByMediaType(descriptors, (PsiElement)nameIdentifier)).isEmpty()) {
            HashMap name2MediaGroups = Maps.newHashMap();
            for (CssMediaGroupAwareDescriptor cssMediaGroupAwareDescriptor : descriptors) {
                Object[] allowedMediaGroups = cssMediaGroupAwareDescriptor.getMediaGroups();
                String presentableText = cssMediaGroupAwareDescriptor.getElementTypeName() + " <code>" + cssMediaGroupAwareDescriptor.getPresentableName() + "</code>";
                if (!name2MediaGroups.containsKey(presentableText)) {
                    name2MediaGroups.put(presentableText, Sets.newHashSet((Object[])allowedMediaGroups));
                    continue;
                }
                ((Set)name2MediaGroups.get(presentableText)).addAll(Sets.newHashSet((Object[])allowedMediaGroups));
            }
            for (Map.Entry entry : name2MediaGroups.entrySet()) {
                TreeSet groups = new TreeSet(CssMediaGroup.COMPARATOR);
                groups.addAll((Collection)entry.getValue());
                String groupsList = StringUtil.toLowerCase((String)StringUtil.join(groups, (String)", "));
                String errorMessage = groups.size() > 0 && !groups.contains(CssMediaGroup.ALL) ? CssBundle.message((String)"css.inspections.wrong.media", (Object[])new Object[]{entry.getKey(), groupsList}) : CssBundle.message((String)"css.inspections.element.not.allowed.here", (Object[])new Object[]{entry.getKey()});
                holder.registerProblem(nameIdentifier, errorMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
        Collection collection = filteredByMediaTypeDescriptors;
        if (collection == null) {
            CssInspectionsUtil.$$$reportNull$$$0(10);
        }
        return collection;
    }

    public static void checkDescriptorValue(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @PropertyKey(resourceBundle="messages.CssBundle") @NotNull String errorMessageKey) {
        if (descriptors == null) {
            CssInspectionsUtil.$$$reportNull$$$0(11);
        }
        if (valueOwner == null) {
            CssInspectionsUtil.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(13);
        }
        if (errorMessageKey == null) {
            CssInspectionsUtil.$$$reportNull$$$0(14);
        }
        CssInspectionsUtil.checkDescriptorValue(descriptors, valueOwner, holder, errorMessageKey, CssInvalidValueRangeProvider.INSTANCE);
    }

    public static void checkDescriptorValue(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @PropertyKey(resourceBundle="messages.CssBundle") @NotNull String errorMessageKey, @NotNull CssInvalidValueRangeProvider invalidValueRangeProvider) {
        if (descriptors == null) {
            CssInspectionsUtil.$$$reportNull$$$0(15);
        }
        if (valueOwner == null) {
            CssInspectionsUtil.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(17);
        }
        if (errorMessageKey == null) {
            CssInspectionsUtil.$$$reportNull$$$0(18);
        }
        if (invalidValueRangeProvider == null) {
            CssInspectionsUtil.$$$reportNull$$$0(19);
        }
        CssInspectionsUtil.checkDescriptorValue(descriptors, valueOwner, holder, errorMessageKey, invalidValueRangeProvider, true, false, false);
    }

    public static void checkDescriptorValue(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @PropertyKey(resourceBundle="messages.CssBundle") @NotNull String errorMessageKey, @NotNull CssInvalidValueRangeProvider invalidValueRangeProvider, boolean ignoreEmptyValue, boolean ignoreToggleValue, boolean ignoreVarValue) {
        PsiElement lastMatchedElement;
        CssTerm[] firstTerm;
        boolean emptyValue;
        CssInspectionFilter inspectionFilter;
        if (descriptors == null) {
            CssInspectionsUtil.$$$reportNull$$$0(20);
        }
        if (valueOwner == null) {
            CssInspectionsUtil.$$$reportNull$$$0(21);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(22);
        }
        if (errorMessageKey == null) {
            CssInspectionsUtil.$$$reportNull$$$0(23);
        }
        if (invalidValueRangeProvider == null) {
            CssInspectionsUtil.$$$reportNull$$$0(24);
        }
        if (descriptors.isEmpty()) {
            return;
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)valueOwner, OuterLanguageElement.class) != null) {
            return;
        }
        CssTermList value = valueOwner.getValue();
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)valueOwner);
        if (language != null && (inspectionFilter = (CssInspectionFilter)CssInspectionFilter.INSTANCE.forLanguage(language)) != null && !inspectionFilter.isValueShouldBeValidatedWithCssScheme(value)) {
            return;
        }
        CssTerm[] terms = value != null ? value.getTerms() : CssTerm.TERMS_EMPTY_ARRAY;
        boolean bl = emptyValue = terms.length == 0;
        if (ignoreEmptyValue && emptyValue) {
            return;
        }
        if (terms.length == 1 && ignoreToggleValue && (firstTerm = (CssTerm[])ArrayUtil.getFirstElement((Object[])terms)) != null && firstTerm.getTermType() == CssTermTypes.TOGGLE) {
            return;
        }
        for (CssTerm term : terms) {
            if (!ignoreVarValue || term.getTermType() != CssTermTypes.VAR) continue;
            return;
        }
        if (value != null) {
            final Ref containsResolvedValueReference = Ref.create((Object)false);
            value.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element.getNode().getElementType() == CssElementTypes.CSS_IDENT) {
                        for (PsiReference reference : element.getReferences()) {
                            if (!(reference instanceof CssValueReference) || reference.resolve() == null) continue;
                            containsResolvedValueReference.set((Object)true);
                            return;
                        }
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/CssInspectionsUtil$1", "visitElement"));
                }
            });
            if (((Boolean)containsResolvedValueReference.get()).booleanValue()) {
                return;
            }
        }
        PsiElement stopElement = CssPsiUtil.getLastDeepestTerm((PsiElement)value);
        TreeSet<CssValueMatchData> notMatchedData = new TreeSet<CssValueMatchData>((o11, o21) -> Comparing.compare((Object)o11.getDescriptor(), (Object)o21.getDescriptor(), (Comparator)new CssParameterInfoValueDescriptorComparator()));
        TreeSet<CssValueMatchData> matchedDataWithRedundantParameters = new TreeSet<CssValueMatchData>((o1, o2) -> Comparing.compare((Object)o1.getDescriptor(), (Object)o2.getDescriptor(), (Comparator)new CssParameterInfoValueDescriptorComparator()));
        for (CssValueOwnerDescriptor descriptor : CssDescriptorsUtil.sortDescriptors(descriptors)) {
            CssValueMatchData matchData;
            CssValueDescriptor valueDescriptor = descriptor.getValueDescriptor();
            CssValueMatchData cssValueMatchData = matchData = value != null ? value.matchWithValueDescriptor(valueDescriptor) : new CssValueDescriptorMapper(null).mapValue(valueDescriptor);
            if (matchData.isMatched()) {
                if (emptyValue) {
                    if (valueDescriptor.getMinOccur() <= 0) {
                        return;
                    }
                    if (valueDescriptor instanceof CssGroupValue && CssValueDescriptorMapper.getAllRequired(((CssGroupValue)valueDescriptor).getChildren()).isEmpty()) {
                        return;
                    }
                }
                if ((lastMatchedElement = matchData.getLastMatchedElement()) != null) {
                    if (stopElement == lastMatchedElement) {
                        return;
                    }
                    PsiElement deepestLastMatchedElement = PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.getDeepestLast((PsiElement)lastMatchedElement), (Class[])new Class[]{CssTerm.class});
                    if (deepestLastMatchedElement != null && deepestLastMatchedElement == stopElement) {
                        return;
                    }
                }
                matchedDataWithRedundantParameters.add(matchData);
                continue;
            }
            notMatchedData.add(matchData);
        }
        TextRange valueTextRange = valueOwner.getTrimmedValueTextRange().shiftRight(-valueOwner.getTextRange().getStartOffset());
        if (!notMatchedData.isEmpty()) {
            for (CssValueMatchData notMatched : notMatchedData) {
                CssValueMatchData deepestNotMatchedData = notMatched.findDeepestNotMatchedData();
                assert (deepestNotMatchedData != null);
                String message = CssInspectionsUtil.buildInvalidValueErrorMessage(notMatched, deepestNotMatchedData.getDescriptor(), errorMessageKey, holder.isOnTheFly());
                holder.registerProblem((PsiElement)valueOwner, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, invalidValueRangeProvider.calculateInvalidRange(valueOwner, notMatched.getLastMatchedElement(), valueTextRange), new LocalQuickFix[0]);
            }
        } else {
            for (CssValueMatchData matchData : matchedDataWithRedundantParameters) {
                String message = CssInspectionsUtil.buildInvalidValueErrorMessage(matchData, null, errorMessageKey, holder.isOnTheFly());
                lastMatchedElement = matchData.getLastMatchedElement();
                holder.registerProblem((PsiElement)valueOwner, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, invalidValueRangeProvider.calculateInvalidRange(valueOwner, lastMatchedElement, valueTextRange), new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    private static String buildInvalidValueErrorMessage(@NotNull CssValueMatchData matchData, @Nullable CssValueDescriptor highlightingDescriptor, @PropertyKey(resourceBundle="messages.CssBundle") @NotNull String errorMessageKey, boolean onTheFly) {
        if (matchData == null) {
            CssInspectionsUtil.$$$reportNull$$$0(25);
        }
        if (errorMessageKey == null) {
            CssInspectionsUtil.$$$reportNull$$$0(26);
        }
        CssParameterInfoValueDescriptorsVisitor messageBuilder = new CssParameterInfoValueDescriptorsVisitor(highlightingDescriptor, true, false);
        CssValueDescriptor parentDescriptor = matchData.getDescriptor();
        parentDescriptor.accept((CssValueDescriptorVisitor)messageBuilder);
        int highlightingStart = messageBuilder.getHighlightingStart();
        int highlightingEnd = messageBuilder.getHighlightingEnd();
        StringBuilder parameterInfo = new StringBuilder(messageBuilder.getParameterInfo());
        if (highlightingStart > -1 && highlightingEnd > -1 && onTheFly) {
            parameterInfo.insert(highlightingEnd, "</span>").insert(highlightingStart, "<span style='font-weight: bold; color: rgb(" + JBColor.RED.getRed() + "," + JBColor.RED.getGreen() + "," + JBColor.RED.getBlue() + ");'>");
        }
        String message = CssBundle.message((String)errorMessageKey, (Object[])new Object[]{parentDescriptor.getPresentableName(), parameterInfo});
        String string = onTheFly ? StringUtil.escapeXmlEntities((String)XmlStringUtil.wrapInHtml((CharSequence)message)) : message;
        if (string == null) {
            CssInspectionsUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    public static void checkUnclosedComment(@NotNull PsiComment comment, @NotNull AnnotationHolder holder) {
        String commentText;
        if (comment == null) {
            CssInspectionsUtil.$$$reportNull$$$0(28);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(29);
        }
        if (comment.getTokenType() == CssElementTypes.CSS_COMMENT && !(commentText = comment.getText()).endsWith("*/")) {
            int offset = comment.getTextRange().getEndOffset();
            holder.newAnnotation(HighlightSeverity.ERROR, CssBundle.message((String)"css.unclosed.comment", (Object[])new Object[0])).range(TextRange.create((int)offset, (int)offset)).afterEndOfLine().create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingElement";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: 
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssInspectionsUtil";
                break;
            }
            case 12: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueOwner";
                break;
            }
            case 14: 
            case 18: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageKey";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidValueRangeProvider";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchData";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssInspectionsUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByContextAndCheck";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByMediaTypeAndCheck";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInvalidValueErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkForTotalUnresolved";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByContextAndCheck";
                break;
            }
            case 6: 
            case 10: 
            case 27: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByMediaTypeAndCheck";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkDescriptorValue";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildInvalidValueErrorMessage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkUnclosedComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CssInvalidValueRangeProvider {
        public static final CssInvalidValueRangeProvider INSTANCE = new CssInvalidValueRangeProvider();

        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                CssInvalidValueRangeProvider.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                CssInvalidValueRangeProvider.$$$reportNull$$$0(1);
            }
            TextRange valueOwnerTextRange = valueOwner.getTextRange();
            return defaultValue.isEmpty() ? valueOwnerTextRange.shiftRight(-valueOwnerTextRange.getStartOffset()) : defaultValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/CssInspectionsUtil$CssInvalidValueRangeProvider";
            objectArray[2] = "calculateInvalidRange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

