/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSupportsCondition;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermImpl;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.parsing.CssMathParser;
import com.intellij.psi.css.impl.util.CssStylesheetElementTypeBase;
import com.intellij.psi.css.impl.util.completion.TimeUserLookup;
import com.intellij.psi.css.impl.util.editor.CssFormattingElementVisitor;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        PsiFile psiFile = element.getContainingFile();
        CssCodeStyleSettings customSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        PsiElement rootElement = psiFile instanceof XmlFile ? element : psiFile;
        final int[] maxPropertyName = new int[]{0};
        if (customSettings.VALUE_ALIGNMENT == 2 || customSettings.VALUE_ALIGNMENT == 1) {
            rootElement.acceptChildren((PsiElementVisitor)new CssElementVisitor(){

                public void visitCssDeclaration(CssDeclaration declaration) {
                    super.visitCssDeclaration(declaration);
                    maxPropertyName[0] = Math.max(maxPropertyName[0], declaration.getPropertyName().length());
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    element.acceptChildren((PsiElementVisitor)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$1", "visitElement"));
                }
            });
        }
        CssFormattingExtension extension = this.createExtension(settings);
        CssRootBlock root = extension.createRootBlock(rootElement.getNode(), extension);
        LanguageFileType fileType = element.getLanguage().getAssociatedFileType();
        if (fileType == null) {
            fileType = psiFile.getFileType();
        }
        return new DocumentBasedFormattingModel((Block)root, psiFile.getProject(), settings, (FileType)fileType, psiFile);
    }

    protected CssFormattingExtension createExtension(CodeStyleSettings settings) {
        return new CssFormattingExtension(settings.getCommonSettings((Language)CSSLanguage.INSTANCE), (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class));
    }

    public static class CssFormattingExtension {
        private final CommonCodeStyleSettings myCommonSettings;
        protected final CssCodeStyleSettings myCustomSettings;

        public CssFormattingExtension(CommonCodeStyleSettings commonSettings, CssCodeStyleSettings customSettings) {
            this.myCommonSettings = commonSettings;
            this.myCustomSettings = customSettings;
        }

        public boolean isComment(IElementType elementType) {
            return CssElementTypes.COMMENTS.contains(elementType);
        }

        public boolean addLeaf(CssTokenImpl token) {
            return false;
        }

        public boolean isLineComment(IElementType elementType) {
            return false;
        }

        public boolean addSubBlocks(PsiElement element, List<Block> result) {
            return false;
        }

        public Indent getCommentIndent(IElementType commentType, IElementType parentType) {
            if (!(parentType instanceof IFileElementType) && !(parentType instanceof CssStylesheetElementTypeBase)) {
                if (this.isLineComment(commentType) && parentType == CssElementTypes.CSS_DECLARATION) {
                    return Indent.getContinuationIndent();
                }
                if (parentType != CssElementTypes.CSS_IMPORT_LIST && parentType != CssElementTypes.CSS_RULESET_LIST) {
                    return Indent.getNormalIndent();
                }
            }
            return Indent.getNoneIndent();
        }

        public Indent getTokenIndent(CssTokenImpl token) {
            if (token.getElementType() == CssElementTypes.CSS_RBRACE && this.myCustomSettings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }

        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, Alignment childAlignment, List<Block> result) {
            return false;
        }

        public CssRootBlock createRootBlock(ASTNode _node, CssFormattingExtension extension) {
            return new CssRootBlock(_node, extension);
        }

        public CssRulesetBlock createRulesetBlock(ASTNode _node, Indent indent, CssFormattingExtension extension, Alignment alignment) {
            return new CssRulesetBlock(_node, indent, extension, alignment);
        }

        public CssPropertyBlock createPropertyBlock(ASTNode _node, Indent indent, CssFormattingExtension extension, @Nullable Alignment alignment, @Nullable Alignment childAlignment) {
            return new CssPropertyBlock(_node, indent, extension, alignment, childAlignment);
        }

        public CssPropertyBlock createPropertyBlock(ASTNode _node, CssFormattingExtension extension, @Nullable Alignment alignment, Alignment childAlignment) {
            Indent indent;
            Indent indent2 = indent = PsiTreeUtil.getParentOfType((PsiElement)_node.getPsi(), CssBlock.class) == null ? Indent.getNoneIndent() : Indent.getNormalIndent();
            if (_node.getTreeParent().getElementType() == CssElementTypes.CSS_MEDIA && _node.getElementType() == CssElementTypes.CSS_IMPORT) {
                indent = Indent.getNormalIndent();
            }
            return this.createPropertyBlock(_node, indent, extension, alignment, childAlignment);
        }

        public CssSelectorBlock createSelectorBlock(ASTNode node, CssFormattingExtension extension) {
            return new CssSelectorBlock(node, Indent.getNoneIndent(), extension);
        }

        public CssFormatterBlock createMediaBlock(ASTNode node, Indent indent, CssFormattingExtension extension) {
            return new CssMediaBlock(node, indent, extension);
        }

        public CssFormatterBlock createSupportsBlock(ASTNode node, Indent indent, CssFormattingExtension extension) {
            return new CssSupportsBlock(node, indent, extension);
        }

        public CssTermListBlock createTermListBlock(ASTNode _node, Indent indent, Alignment alignment, boolean shouldIndentContent) {
            return new CssTermListBlock(_node, indent, this, alignment, shouldIndentContent);
        }
    }

    protected static class LeafBlock
    implements ASTBlock {
        private static final ArrayList<Block> EMPTY_SUB_BLOCKS = new ArrayList();
        private final ASTNode myNode;
        private final Indent myIndent;

        public LeafBlock(ASTNode node, Indent indent) {
            this.myNode = node;
            this.myIndent = indent;
        }

        public ASTNode getNode() {
            return this.myNode;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myNode.getTextRange();
            if (textRange == null) {
                LeafBlock.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        @NotNull
        public List<Block> getSubBlocks() {
            ArrayList<Block> arrayList = EMPTY_SUB_BLOCKS;
            if (arrayList == null) {
                LeafBlock.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public Wrap getWrap() {
            return null;
        }

        public Indent getIndent() {
            return this.myIndent;
        }

        public Alignment getAlignment() {
            return null;
        }

        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                LeafBlock.$$$reportNull$$$0(2);
            }
            return null;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(this.getIndent(), null);
        }

        public boolean isIncomplete() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$LeafBlock";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$LeafBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class CssFormatterBlock
    implements ASTBlock {
        protected final ASTNode myNode;
        private final Alignment myAlignment;
        protected final Alignment myChildAlignment;
        final Indent myIndent;
        protected List<Block> mySubBlocks;
        public final IElementType myType;
        protected final CssFormattingExtension myExtension;

        protected CssFormatterBlock(ASTNode _node, Indent indent, CssFormattingExtension extension, @Nullable Alignment alignment, @Nullable Alignment childAlignment) {
            this.myNode = _node;
            this.myIndent = indent;
            this.myExtension = extension;
            this.myType = this.myNode.getElementType();
            this.myAlignment = alignment;
            this.myChildAlignment = childAlignment;
        }

        protected CssFormatterBlock(ASTNode _node, @Nullable Indent indent, CssFormattingExtension extension) {
            this(_node, indent, extension, null, null);
        }

        protected CssCodeStyleSettings getCustomSettings() {
            return this.myExtension.myCustomSettings;
        }

        protected int getKeepBlankLines() {
            return ((CssFormattingExtension)this.myExtension).myCommonSettings.KEEP_BLANK_LINES_IN_CODE;
        }

        public String toString() {
            return this.myNode != null ? this.myNode.getText() : super.toString();
        }

        public boolean shouldIndentContent() {
            return false;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myNode.getTextRange();
            if (textRange == null) {
                CssFormatterBlock.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        @NotNull
        public ASTNode getNode() {
            ASTNode aSTNode = this.myNode;
            if (aSTNode == null) {
                CssFormatterBlock.$$$reportNull$$$0(1);
            }
            return aSTNode;
        }

        @NotNull
        public List<Block> getSubBlocks() {
            if (this.mySubBlocks == null) {
                this.mySubBlocks = new ArrayList<Block>(0);
                Alignment alignment = this.getCustomSettings().VALUE_ALIGNMENT == 2 || this.getCustomSettings().VALUE_ALIGNMENT == 1 ? Alignment.createAlignment((boolean)true) : null;
                this.myNode.getPsi().acceptChildren((PsiElementVisitor)new CssFormattingElementVisitor(this.mySubBlocks, this.getCustomSettings(), this.myExtension, alignment, this.myChildAlignment, this.myType, this.shouldIndentContent()));
            }
            List<Block> list = this.mySubBlocks;
            if (list == null) {
                CssFormatterBlock.$$$reportNull$$$0(2);
            }
            return list;
        }

        protected Spacing getSpacingBeforeLBrace() {
            CssCodeStyleSettings settings = this.getCustomSettings();
            int linefeeds = settings.BRACE_PLACEMENT == 1 ? 1 : 0;
            int spaces = settings.SPACE_BEFORE_OPENING_BRACE ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)linefeeds, (boolean)false, (int)0);
        }

        @Nullable
        public Wrap getWrap() {
            return null;
        }

        @Nullable
        public Indent getIndent() {
            return this.myIndent;
        }

        @Nullable
        public Alignment getAlignment() {
            return this.myAlignment;
        }

        public boolean isIncomplete() {
            return false;
        }

        public boolean isLeaf() {
            return this.myNode instanceof LeafElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssFormatterBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class CssRootBlock
    extends CssFormatterBlock {
        public CssRootBlock(ASTNode _node, CssFormattingExtension extension) {
            super(_node, null, extension);
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssRootBlock.$$$reportNull$$$0(0);
            }
            if (child1 == null) {
                return null;
            }
            if (child1 instanceof ASTBlock && child2 instanceof ASTBlock) {
                ASTNode node1 = ((ASTBlock)child1).getNode();
                ASTNode node2 = ((ASTBlock)child2).getNode();
                IElementType type1 = node1.getElementType();
                IElementType type2 = node2.getElementType();
                ASTNode parentNode = node1.getTreeParent();
                if (type1 == CssElementTypes.CSS_BAD_AT_RULE) {
                    return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines());
                }
                IElementType parentType = null;
                if (parentNode != null) {
                    parentType = parentNode.getElementType();
                }
                if (parentType == CssElementTypes.CSS_NAMESPACE) {
                    if (type2 == CssElementTypes.CSS_NAMESPACE_SYM) {
                        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.getKeepBlankLines());
                    }
                    if (type1 == CssElementTypes.CSS_IDENT || type2 == CssElementTypes.CSS_IDENT || type2 == CssElementTypes.CSS_STRING) {
                        return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
                    }
                    if (type2 == CssElementTypes.CSS_SEMICOLON) {
                        return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                    }
                }
                if (this.myExtension.isLineComment(type1)) {
                    return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.getKeepBlankLines());
                }
                if (!(child1 instanceof CssRulesetBlock) && this.myExtension.isComment(type2) && node2.getText().indexOf(10) == -1) {
                    return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines());
                }
            }
            if (child1 instanceof CssPropertyBlock || child1 instanceof CssSimpleBlock) {
                return Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            int minLineFeeds = this.getCustomSettings().BLANK_LINES_BETWEEN_BLOCKS + 1;
            return Spacing.createSpacing((int)2, (int)2, (int)minLineFeeds, (boolean)true, (int)this.getKeepBlankLines());
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            Block prevBlock;
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex != 0 && subBlocks.size() >= newChildIndex && (prevBlock = subBlocks.get(newChildIndex - 1)) instanceof CssRulesetBlock) {
                return new ChildAttributes(Indent.getNoneIndent(), prevBlock.getAlignment());
            }
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssRootBlock", "getSpacing"));
        }
    }

    static class NamespaceListBlock
    extends ImportListBlock {
        NamespaceListBlock(ASTNode _node, CssFormattingExtension extension) {
            super(_node, extension);
        }
    }

    static class ImportListBlock
    extends CssFormatterBlock {
        ImportListBlock(ASTNode _node, CssFormattingExtension extension) {
            super(_node, Indent.getNoneIndent(), extension);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                ImportListBlock.$$$reportNull$$$0(0);
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            if (formatterBlock2.myType == CssElementTypes.CSS_SEMICOLON) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)false, (int)1);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$ImportListBlock", "getSpacing"));
        }
    }

    public static class CssTermListBlock
    extends CssPropertyBlock {
        private final boolean myShouldIndentContent;

        public CssTermListBlock(ASTNode _node, Indent indent, CssFormattingExtension extension, Alignment alignment, boolean shouldIndentContent) {
            super(_node, indent, extension, alignment, null);
            this.myShouldIndentContent = shouldIndentContent;
        }

        @Override
        public boolean shouldIndentContent() {
            return this.myShouldIndentContent;
        }

        @Override
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssTermListBlock.$$$reportNull$$$0(0);
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock = (CssFormatterBlock)child1;
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            if (formatterBlock.myType == CssElementTypes.CSS_COLON || formatterBlock2.myType == CssElementTypes.CSS_COLON || formatterBlock.myType == CssElementTypes.CSS_EQ || formatterBlock2.myType == CssElementTypes.CSS_EQ || formatterBlock.myType == CssElementTypes.CSS_PERIOD || formatterBlock2.myType == CssElementTypes.CSS_PERIOD) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_SLASH || formatterBlock2.myType == CssElementTypes.CSS_SLASH || formatterBlock.myNode instanceof OuterLanguageElement || formatterBlock2.myNode instanceof OuterLanguageElement) {
                return Spacing.getReadOnlySpacing();
            }
            return super.getSpacing(child1, child2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssTermListBlock", "getSpacing"));
        }
    }

    public static class CssMediaBlock
    extends CssRulesetBlock {
        CssMediaBlock(ASTNode _node, Indent indent, CssFormattingExtension extension) {
            super(_node, indent, extension, null);
        }

        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_MEDIA_SYM;
        }

        @Override
        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssMediaBlock.$$$reportNull$$$0(0);
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock block1 = (CssFormatterBlock)child1;
            CssFormatterBlock block2 = (CssFormatterBlock)child2;
            IElementType type1 = block1.myType;
            IElementType type2 = block2.myType;
            if (type2 == CssElementTypes.CSS_LBRACE) {
                return this.getSpacingBeforeLBrace();
            }
            if (type1 == this.getAtKeywordElementType()) {
                return type2 == CssElementTypes.CSS_DECLARATION || block2 instanceof CssRulesetBlock ? Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)this.getKeepBlankLines()) : Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (type1 == CssElementTypes.CSS_COMMA && type2 == CssElementTypes.CSS_IDENT) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (type1 == CssElementTypes.CSS_LBRACE) {
                return Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (type2 == CssElementTypes.CSS_RBRACE) {
                return Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (type2 == CssElementTypes.CSS_DECLARATION && type1 == CssElementTypes.CSS_SEMICOLON) {
                return Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (this.myExtension.isComment(type1)) {
                return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)false, (int)0);
            }
            if (type1 == CssElementTypes.CSS_RULESET || type1 == CssElementTypes.CSS_PAGE) {
                int minLineFeeds = this.getCustomSettings().BLANK_LINES_AROUND_NESTED_SELECTOR + 1;
                return Spacing.createSpacing((int)2, (int)2, (int)minLineFeeds, (boolean)true, (int)this.getKeepBlankLines());
            }
            return null;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            Block prevBlock;
            if (newChildIndex != 0 && (prevBlock = this.getSubBlocks().get(newChildIndex - 1)) instanceof CssRulesetBlock) {
                return new ChildAttributes(Indent.getNormalIndent(), prevBlock.getAlignment());
            }
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssMediaBlock", "getSpacing"));
        }
    }

    static class CssPageBlock
    extends CssMediaBlock {
        CssPageBlock(ASTNode _node, Indent indent, CssFormattingExtension extension) {
            super(_node, indent, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_PAGE_SYM;
        }

        @Override
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssPageBlock.$$$reportNull$$$0(0);
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock = (CssFormatterBlock)child1;
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            if (formatterBlock.myType == CssElementTypes.CSS_COLON && formatterBlock2.myType == CssElementTypes.CSS_IDENT) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            return super.getSpacing(child1, child2);
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssPageBlock", "getSpacing"));
        }
    }

    static class CssSupportsBlock
    extends CssMediaBlock {
        CssSupportsBlock(ASTNode _node, Indent indent, CssFormattingExtension extension) {
            super(_node, indent, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_SUPPORTS_SYM;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            PsiElement elementBefore;
            Block prevSubBlock;
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex - 1 < subBlocks.size() && (prevSubBlock = subBlocks.get(newChildIndex - 1)) instanceof CssFormatterBlock && (elementBefore = ((CssFormatterBlock)prevSubBlock).myNode.getPsi()) != null && elementBefore.getParent() instanceof CssSupportsCondition) {
                return new ChildAttributes(Indent.getNoneIndent(), null);
            }
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                CssSupportsBlock.$$$reportNull$$$0(0);
            }
            return childAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSupportsBlock", "getChildAttributes"));
        }
    }

    static class CssViewPortBlock
    extends CssMediaBlock {
        CssViewPortBlock(ASTNode _node, Indent indent, CssFormattingExtension extension) {
            super(_node, indent, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_VIEWPORT_SYM;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
    }

    static class CssFontFaceBlock
    extends CssMediaBlock {
        CssFontFaceBlock(ASTNode _node, Indent indent, CssFormattingExtension extension) {
            super(_node, indent, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_FONTFACE_SYM;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
    }

    static class CssBadAtRuleBlock
    extends CssMediaBlock {
        CssBadAtRuleBlock(ASTNode _node, Indent indent, CssFormattingExtension extension) {
            super(_node, indent, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_ATKEYWORD;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
    }

    public static class CssRulesetBlock
    extends CssFormatterBlock {
        public CssRulesetBlock(ASTNode _node, Indent indent, CssFormattingExtension extension, @Nullable Alignment alignment) {
            super(_node, indent, extension, alignment, null);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssRulesetBlock.$$$reportNull$$$0(0);
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock block1 = (CssFormatterBlock)child1;
            CssFormatterBlock block2 = (CssFormatterBlock)child2;
            IElementType type1 = block1.myType;
            IElementType type2 = block2.myType;
            if (type2 == CssElementTypes.CSS_COLON) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if ((CssRulesetBlock.isRulesetWithSelector(block1.myNode) && type2 != CssElementTypes.CSS_RBRACE && type2 != CssElementTypes.CSS_SEMICOLON && type2 != null || CssRulesetBlock.isRulesetWithSelector(block2.myNode) && type1 != null && type1 != CssElementTypes.CSS_LBRACE && !(block1 instanceof CssSelectorBlock)) && CssRulesetBlock.isRulesetWithSelector(this.getNode())) {
                return Spacing.createSpacing((int)1, (int)1, (int)(this.getCustomSettings().BLANK_LINES_AROUND_NESTED_SELECTOR + 1), (boolean)true, (int)this.getKeepBlankLines());
            }
            if (type2 == CssElementTypes.CSS_RULESET || type1 == CssElementTypes.CSS_RULESET) {
                return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (block1 instanceof CssPropertyBlock && (block2.getNode() instanceof OuterLanguageElement || type2 == CssElementTypes.CSS_SEMICOLON)) {
                PsiElement psi = block1.getNode().getPsi();
                ASTNode node2 = block2.getNode();
                CssCodeStyleSettings settings = this.getCustomSettings();
                if (psi instanceof CssDeclaration) {
                    CssTermList value = ((CssDeclaration)psi).getValue();
                    if (value == null || value.getTextLength() == 0) {
                        int minSpaces = node2 instanceof OuterLanguageElement && node2.getTextLength() > 0 ? 1 : 0;
                        return settings.SPACE_AFTER_COLON ? Spacing.createSpacing((int)minSpaces, (int)1, (int)0, (boolean)false, (int)0) : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                    }
                    return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                }
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (type2 == CssElementTypes.CSS_SEMICOLON || type2 == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (!(block1 instanceof CssRulesetBlock) && this.myExtension.isComment(type2) && block2.myNode.getText().indexOf(10) == -1) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (this.myExtension.isLineComment(type1)) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (type1 == CssElementTypes.CSS_LBRACE || type1 == CssElementTypes.CSS_SEMICOLON || this.myExtension.isComment(type1) || type2 == CssElementTypes.CSS_RBRACE) {
                return this.getCustomSettings().KEEP_SINGLE_LINE_BLOCKS ? Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines()) : Spacing.createSpacing((int)0, (int)1, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (block1 instanceof CssPropertyBlock && block2 instanceof CssPropertyBlock) {
                return this.getCustomSettings().KEEP_SINGLE_LINE_BLOCKS ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines()) : Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (type1 == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            if (type2 == CssElementTypes.CSS_LBRACE) {
                return this.getSpacingBeforeLBrace();
            }
            if (type2 == XmlTokenType.XML_COMMENT_CHARACTERS || type2 == XmlTokenType.XML_COMMENT_START) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (type1 == CssElementTypes.CSS_LPAREN || type2 == CssElementTypes.CSS_LPAREN || type2 == CssElementTypes.CSS_RPAREN || (block1 instanceof CssSimpleBlock || block1 instanceof CssSelectorBlock) && block2.getNode() instanceof OuterLanguageElement) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (child1 instanceof CssBadAtRuleBlock && child2 instanceof CssRulesetBlock || child1 instanceof CssRulesetBlock && child2 instanceof CssBadAtRuleBlock || child1 instanceof CssBadAtRuleBlock && type2 == CssElementTypes.CSS_DECLARATION) {
                return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)false, (int)this.getKeepBlankLines());
            }
            if (child1 instanceof CssRulesetBlock || child2 instanceof CssRulesetBlock) {
                return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }

        private static boolean isRulesetWithSelector(@NotNull ASTNode node) {
            if (node == null) {
                CssRulesetBlock.$$$reportNull$$$0(1);
            }
            if (node.getElementType() != CssElementTypes.CSS_RULESET) {
                return false;
            }
            ASTNode child = node.getFirstChildNode();
            return child != null && child.getElementType() == CssElementTypes.CSS_SELECTOR_LIST;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            Block prevSubBlock;
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex - 1 < subBlocks.size() && (prevSubBlock = subBlocks.get(newChildIndex - 1)) instanceof CssFormatterBlock && ((CssFormatterBlock)prevSubBlock).myNode.getElementType() == CssElementTypes.CSS_COMMA) {
                return new ChildAttributes(Indent.getNoneIndent(), null);
            }
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }

        @Override
        public boolean shouldIndentContent() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssRulesetBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSpacing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRulesetWithSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CssPropertyBlock
    extends CssFormatterBlock {
        public CssPropertyBlock(ASTNode _node, Indent indent, CssFormattingExtension extension, @Nullable Alignment alignment, @Nullable Alignment childAlignment) {
            super(_node, indent, extension, alignment, childAlignment);
        }

        @Override
        public boolean shouldIndentContent() {
            return true;
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssPropertyBlock.$$$reportNull$$$0(0);
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock = (CssFormatterBlock)child1;
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            CssCodeStyleSettings settings = this.getCustomSettings();
            if (settings.VALUE_ALIGNMENT == 1 && formatterBlock2.myType == CssElementTypes.CSS_COLON) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (this.myExtension.isLineComment(formatterBlock.myType)) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.getKeepBlankLines());
            }
            if (formatterBlock.myType == CssElementTypes.CSS_LPAREN || formatterBlock2.myType == CssElementTypes.CSS_RPAREN) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)0);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_LPAREN && this.getNode().getElementType() == CssElementTypes.CSS_IMPORT) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            String textOfFormatterBlock2 = StringUtil.toLowerCase((String)formatterBlock2.myNode.getText());
            if (formatterBlock.myType == CssElementTypes.CSS_MINUS || formatterBlock.myType == CssElementTypes.CSS_ASTERISK || formatterBlock.myType == CssElementTypes.CSS_PLUS && formatterBlock2.myType == CssElementTypes.CSS_NUMBER || formatterBlock.myType == CssElementTypes.CSS_IDENT && formatterBlock2.myType == CssElementTypes.CSS_PLUS || formatterBlock.myType == CssElementTypes.CSS_PLUS && formatterBlock2.myType == CssElementTypes.CSS_IDENT || formatterBlock2.myType == CssElementTypes.CSS_COLON || formatterBlock2.myType == CssElementTypes.CSS_SEMICOLON || formatterBlock2.myType == CssElementTypes.CSS_PERCENT || (formatterBlock.myType == CssElementTypes.CSS_NUMBER || formatterBlock.myType == XmlTokenType.XML_COMMENT_START) && formatterBlock2.myType == CssElementTypes.CSS_IDENT && (CssTermImpl.getTypeBySuffix(textOfFormatterBlock2) != CssTermType.UNKNOWN || "n".equals(textOfFormatterBlock2) || "x".equals(textOfFormatterBlock2) || TimeUserLookup.isTimeSuffix(textOfFormatterBlock2))) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_LPAREN) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_COLON) {
                return settings.SPACE_AFTER_COLON ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0) : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssPropertyBlock", "getSpacing"));
        }
    }

    public static class CssSelectorBlock
    extends CssFormatterBlock {
        public CssSelectorBlock(ASTNode _node, Indent indent, CssFormattingExtension extension) {
            super(_node, indent, extension);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssSelectorBlock.$$$reportNull$$$0(0);
            }
            if (child2 instanceof CssFormatterBlock && ((CssFormatterBlock)child2).myType == CssElementTypes.CSS_PERCENT) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }

        @Override
        public String toString() {
            return this.myNode.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSelectorBlock", "getSpacing"));
        }
    }

    public static class CssOperationBlock
    extends CssFormatterBlock {
        public CssOperationBlock(ASTNode _node, CssFormattingExtension extension) {
            super(_node, Indent.getNoneIndent(), extension);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssOperationBlock.$$$reportNull$$$0(0);
            }
            if (this.myNode.getElementType() == CssElementTypes.CSS_BINARY_OPERATION && (child1 instanceof CssFormatterBlock && CssMathParser.OPERATORS.contains(((CssFormatterBlock)child1).myType) || child2 instanceof CssFormatterBlock && CssMathParser.OPERATORS.contains(((CssFormatterBlock)child2).myType))) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssOperationBlock", "getSpacing"));
        }
    }

    protected static class CssSimpleBlock
    extends CssFormatterBlock {
        public CssSimpleBlock(ASTNode _node, Indent indent, CssFormattingExtension extension) {
            this(_node, indent, extension, null);
        }

        public CssSimpleBlock(ASTNode _node, Indent indent, CssFormattingExtension extension, @Nullable Alignment alignment) {
            super(_node, indent, extension, alignment, null);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CssSimpleBlock.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        @NotNull
        public List<Block> getSubBlocks() {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CssSimpleBlock.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }

        @Override
        public String toString() {
            return this.myNode.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSimpleBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSimpleBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

