/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CssBlockImpl
extends LazyParseablePsiElement
implements CssBlock {
    private static final TObjectHashingStrategy<CssDeclaration> ourStrategy = new TObjectHashingStrategy<CssDeclaration>(){

        public int computeHashCode(CssDeclaration object) {
            return object.equalityHashCode();
        }

        public boolean equals(CssDeclaration o1, CssDeclaration o2) {
            return o1.isEqualTo((Object)o2);
        }
    };

    CssBlockImpl(CharSequence text) {
        this(text, (IElementType)CssElementTypes.CSS_DECLARATION_BLOCK);
    }

    CssBlockImpl(CharSequence text, IElementType type) {
        super(type, text);
    }

    public CssDeclaration @NotNull [] getDeclarations() {
        CssDeclaration[] cssDeclarationArray = (CssDeclaration[])this.getChildrenAsPsiElements((IElementType)CssElementTypes.CSS_DECLARATION, CssDeclaration.ARRAY_FACTORY);
        if (cssDeclarationArray == null) {
            CssBlockImpl.$$$reportNull$$$0(0);
        }
        return cssDeclarationArray;
    }

    public boolean isEqualTo(Object object) {
        if (!(object instanceof CssBlockImpl)) {
            return false;
        }
        CssBlockImpl block = (CssBlockImpl)((Object)object);
        THashSet<CssDeclaration> set1 = CssBlockImpl.getDeclarationsHashSet(this);
        THashSet<CssDeclaration> set2 = CssBlockImpl.getDeclarationsHashSet(block);
        return set1.equals(set2);
    }

    @Nullable
    public PsiElement getLBrace() {
        ASTNode node;
        PsiElement firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)this);
        if (firstChild instanceof PsiWhiteSpace) {
            firstChild = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild);
        }
        if (firstChild != null && (node = firstChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_LBRACE) {
            return firstChild;
        }
        return null;
    }

    @Nullable
    public PsiElement getRBrace() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RBRACE) {
            return lastChild;
        }
        return null;
    }

    private static THashSet<CssDeclaration> getDeclarationsHashSet(CssBlockImpl block) {
        return new THashSet((Collection)ContainerUtil.newArrayList((Object[])block.getDeclarations()), ourStrategy);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssBlockImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssBlock((CssBlock)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public CssDeclaration addDeclaration(@NotNull String name, @NotNull String value, @Nullable CssDeclaration declarationAnchor) throws IncorrectOperationException {
        IElementType type;
        ASTNode astNode;
        if (name == null) {
            CssBlockImpl.$$$reportNull$$$0(2);
        }
        if (value == null) {
            CssBlockImpl.$$$reportNull$$$0(3);
        }
        CssDeclaration anchor = declarationAnchor;
        assert (anchor == null || anchor.getParent() == this);
        Project project = this.getProject();
        CssElementFactory factory = CssElementFactory.getInstance((Project)project);
        CssDeclaration cssDeclaration = factory.createProperty(name, value, CssPsiUtil.getStylesheetLanguage((PsiElement)this));
        PsiElement semicolon2 = cssDeclaration.getNextSibling();
        if (semicolon2 != null && semicolon2.getNode().getElementType() != CssElementTypes.CSS_SEMICOLON) {
            semicolon2 = null;
        }
        if (anchor != null) {
            anchor = CssUtil.appendStatementWithSemicolonIfNeeded(project, (PsiElement)anchor);
        }
        PsiElement nextSibling = anchor != null ? PsiTreeUtil.nextVisibleLeaf((PsiElement)anchor) : null;
        PsiElement _anchor = nextSibling == null ? this.getFirstVisibleChild() : nextSibling;
        ASTNode aSTNode = astNode = _anchor != null ? _anchor.getNode() : null;
        if (astNode != null && (type = astNode.getElementType()) != CssElementTypes.CSS_SEMICOLON && anchor != null) {
            _anchor = anchor;
        }
        if (anchor != null && _anchor != null) {
            nextSibling = PsiTreeUtil.nextLeaf((PsiElement)_anchor);
            boolean containsNewLine = false;
            while (nextSibling != null && !containsNewLine) {
                boolean isComment = nextSibling instanceof PsiComment;
                boolean isWhiteSpace = nextSibling instanceof PsiWhiteSpace;
                if (!isComment && !isWhiteSpace) break;
                containsNewLine = StringUtil.containsChar((String)nextSibling.getText(), (char)'\n');
                if (containsNewLine && !isComment) continue;
                _anchor = nextSibling;
                nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
            }
        }
        return (CssDeclaration)(semicolon2 != null ? this.addRangeAfter((PsiElement)cssDeclaration, semicolon2, _anchor) : this.addAfter((PsiElement)cssDeclaration, _anchor));
    }

    @Nullable
    private PsiElement getFirstVisibleChild() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null) {
            return StringUtil.isEmptyOrSpaces((String)firstChild.getText()) ? PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild) : firstChild;
        }
        return null;
    }

    public void removeDeclaration(@NotNull CssDeclaration declaration) throws IncorrectOperationException {
        PsiElement nextSibling;
        if (declaration == null) {
            CssBlockImpl.$$$reportNull$$$0(4);
        }
        if ((nextSibling = declaration.getNextSibling()) != null) {
            ASTNode astNode1;
            PsiElement nextNextSibling;
            ASTNode astNode = nextSibling.getNode();
            if (!(astNode == null || astNode.getElementType() != CssElementTypes.CSS_WHITE_SPACE && astNode.getElementType() != CssElementTypes.CSS_SEMICOLON || (nextNextSibling = nextSibling.getNextSibling()) == null || (astNode1 = nextNextSibling.getNode()) == null || CssElementTypes.CSS_SEMICOLON != astNode1.getElementType() && CssElementTypes.CSS_WHITE_SPACE != astNode1.getElementType())) {
                nextSibling = nextNextSibling;
            }
            if ((astNode = nextSibling.getNode()) != null && (astNode.getElementType() == CssElementTypes.CSS_SEMICOLON || astNode.getElementType() == CssElementTypes.CSS_WHITE_SPACE)) {
                this.deleteChildRange((PsiElement)declaration, nextSibling);
            } else {
                this.deleteChildRange((PsiElement)declaration, (PsiElement)declaration);
            }
        }
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName) {
        if (propertyName == null) {
            CssBlockImpl.$$$reportNull$$$0(5);
        }
        return this.findDeclaration(propertyName, true);
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName, boolean searchInShorthand) {
        if (propertyName == null) {
            CssBlockImpl.$$$reportNull$$$0(6);
        }
        return CssPsiUtil.findDeclaration((CssBlock)this, (String)propertyName, (boolean)searchInShorthand);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssBlockImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssBlockImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeDeclaration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

