/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssStyles
implements ComponentWithActions,
Disposable {
    private CssResolver myResolver;
    private TreeTable myTreeTable;
    private XmlTag myCurrentTag;
    private static final String myCurrentStylesheet = null;
    private final JComponent myComponent;
    private final ActionGroup myActionGroup;

    public CssStyles(@NotNull CssResolver resolver) {
        if (resolver == null) {
            CssStyles.$$$reportNull$$$0(0);
        }
        this.myResolver = resolver;
        this.myComponent = this.init();
        this.myActionGroup = this.initActions();
    }

    public ActionGroup getToolbarActions() {
        return this.myActionGroup;
    }

    public JComponent getSearchComponent() {
        return null;
    }

    public String getToolbarPlace() {
        return "unknown";
    }

    public JComponent getToolbarContextComponent() {
        return null;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            CssStyles.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    public boolean isContentBuiltIn() {
        return false;
    }

    @NotNull
    private ActionGroup initActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(CssBundle.message((String)"css.browser.actions.navigate.to.tag", (Object[])new Object[0]), CssBundle.message((String)"css.browser.actions.navigate.to.tag.description", (Object[])new Object[0]), AllIcons.Actions.Preview){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CssStyles.this.myCurrentTag != null && CssStyles.this.myCurrentTag.isValid() && CssStyles.this.myCurrentTag instanceof Navigatable) {
                    ((Navigatable)CssStyles.this.myCurrentTag).navigate(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/browse/CssStyles$1", "actionPerformed"));
            }
        });
        group.addSeparator();
        group.add(new AnAction(CssBundle.message((String)"css.browser.actions.expand.styles", (Object[])new Object[0]), CssBundle.message((String)"css.browser.actions.expand.styles", (Object[])new Object[0]), AllIcons.Actions.Expandall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                TreeUtil.expandAll((JTree)CssStyles.this.myTreeTable.getTree());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/browse/CssStyles$2", "actionPerformed"));
            }
        });
        group.add(new AnAction(CssBundle.message((String)"css.browser.actions.collapse.styles", (Object[])new Object[0]), CssBundle.message((String)"css.browser.actions.collapse.styles", (Object[])new Object[0]), AllIcons.Actions.Collapseall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                TreeUtil.collapseAll((JTree)CssStyles.this.myTreeTable.getTree(), (int)0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/browse/CssStyles$3", "actionPerformed"));
            }
        });
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            CssStyles.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    private JComponent init() {
        this.myTreeTable = new TreeTable((TreeTableModel)new ListTreeTableModel((TreeNode)new DefaultMutableTreeNode(), ColumnInfo.EMPTY_ARRAY));
        this.myTreeTable.setTableHeader(null);
        return ScrollPaneFactory.createScrollPane((Component)this.myTreeTable, (int)20, (int)31);
    }

    private void updateCombobox() {
        if (this.myCurrentTag != null && this.myCurrentTag.isValid()) {
            Object[] stylesheets = this.myResolver.resolveStyleSheetNames((XmlFile)this.myCurrentTag.getContainingFile());
            ArrayList<String> stylesheetList = new ArrayList<String>();
            stylesheetList.add("default");
            ContainerUtil.addAll(stylesheetList, (Object[])stylesheets);
        }
    }

    public void dispose() {
        this.myTreeTable = null;
        this.myResolver = null;
        this.myCurrentTag = null;
    }

    public void addListSelectionListener(@NotNull ListSelectionListener listener) {
        if (listener == null) {
            CssStyles.$$$reportNull$$$0(3);
        }
        if (this.myTreeTable != null) {
            this.myTreeTable.getSelectionModel().addListSelectionListener(listener);
        }
    }

    public void removeListSelectionListener(@NotNull ListSelectionListener listener) {
        if (listener == null) {
            CssStyles.$$$reportNull$$$0(4);
        }
        if (this.myTreeTable != null) {
            this.myTreeTable.getSelectionModel().removeListSelectionListener(listener);
        }
    }

    public void setTag(@NotNull XmlTag tag) {
        if (tag == null) {
            CssStyles.$$$reportNull$$$0(5);
        }
        if (!tag.isValid()) {
            return;
        }
        this.myCurrentTag = tag;
        this.updateCombobox();
        this.myTreeTable.setModel(this.buildModel(tag, myCurrentStylesheet));
        this.myTreeTable.setRootVisible(false);
        TreeTableTree tree = this.myTreeTable.getTree();
        tree.setShowsRootHandles(true);
        tree.setCellRenderer((TreeCellRenderer)new StylesNameRenderer());
        TableColumnModel columnModel = this.myTreeTable.getColumnModel();
        TableColumn c = columnModel.getColumn(0);
        c.setWidth(200);
        c.setMaxWidth(200);
        c.setMinWidth(200);
    }

    private TreeTableModel buildModel(@NotNull XmlTag tag, @Nullable String stylesheet) {
        if (tag == null) {
            CssStyles.$$$reportNull$$$0(6);
        }
        CssDeclaration[] declarations = this.myResolver.resolve(tag, (PsiFile[])new XmlFile[]{(XmlFile)tag.getContainingFile()}, stylesheet);
        LinkedHashMap<String, ArrayList<CssDeclaration>> name2decls = new LinkedHashMap<String, ArrayList<CssDeclaration>>();
        for (CssDeclaration decl : declarations) {
            String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)decl);
            ArrayList<CssDeclaration> decls = (ArrayList<CssDeclaration>)name2decls.get(propertyName);
            if (decls == null) {
                decls = new ArrayList<CssDeclaration>();
                name2decls.put(propertyName, decls);
            }
            decls.add(decl);
        }
        CssDeclaration[] unusedDeclarations = CssUtil.getCssDeclarationsDefinedForTag(tag);
        for (int i = 0; i < unusedDeclarations.length; ++i) {
            CssDeclaration declaration = unusedDeclarations[i];
            String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)declaration);
            ArrayList<CssDeclaration> list = (ArrayList<CssDeclaration>)name2decls.get(propertyName);
            if (list == null) {
                list = new ArrayList<CssDeclaration>();
                name2decls.put(propertyName, list);
            }
            list.add(declaration);
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (String name : name2decls.keySet()) {
            List decls = (List)name2decls.get(name);
            if (decls == null) continue;
            CssDeclaration applied = (CssDeclaration)decls.get(0);
            DefaultMutableTreeNode declNode = new DefaultMutableTreeNode(applied);
            if (decls.size() > 1) {
                for (int i = 1; i < decls.size(); ++i) {
                    CssDeclaration ignored = (CssDeclaration)decls.get(i);
                    if (applied == ignored) continue;
                    declNode.add(new DefaultMutableTreeNode(decls.get(i)));
                }
            }
            root.add(declNode);
        }
        return new ListTreeTableModel((TreeNode)root, CssStyles.getColumnInfos());
    }

    private static ColumnInfo[] getColumnInfos() {
        return new ColumnInfo[]{new ColumnInfo(CssBundle.message((String)"column.info.name", (Object[])new Object[0])){

            public Object valueOf(Object o) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                Object userObject = node.getUserObject();
                if (userObject instanceof CssDeclaration) {
                    CssDeclaration declaration = (CssDeclaration)userObject;
                    return declaration.isValid() ? CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)declaration) : null;
                }
                return null;
            }

            public Class getColumnClass() {
                return TreeTableModel.class;
            }
        }, new ColumnInfo(CssBundle.message((String)"column.info.value", (Object[])new Object[0])){

            public Object valueOf(Object o) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                Object userObject = node.getUserObject();
                if (userObject instanceof CssDeclaration) {
                    CssTermList value = ((CssDeclaration)userObject).getValue();
                    return value != null ? value.getText() : null;
                }
                return null;
            }
        }};
    }

    @Nullable
    public CssDeclaration getSelectedItem() {
        return this.getDeclarationAt(this.myTreeTable.getSelectedRow());
    }

    @Nullable
    public CssDeclaration getDeclarationAt(int firstIndex) {
        Object o;
        TreePath path = this.myTreeTable.getTree().getPathForRow(firstIndex);
        if (path != null && (o = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            return (CssDeclaration)((DefaultMutableTreeNode)o).getUserObject();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/browse/CssStyles";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/browse/CssStyles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListSelectionListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeListSelectionListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTag";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StylesNameRenderer
    extends DefaultTreeCellRenderer {
        private boolean myStrikeout;

        private StylesNameRenderer() {
        }

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object o;
            if (tree == null) {
                StylesNameRenderer.$$$reportNull$$$0(0);
            }
            Component result = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.myStrikeout = false;
            if (value instanceof DefaultMutableTreeNode && (o = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof CssDeclaration) {
                TreeNode parent = node.getParent();
                if (!selected && parent instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)parent).getUserObject() != null) {
                    this.myStrikeout = true;
                }
                this.setText(CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)((CssDeclaration)o)));
            }
            this.setIcon(null);
            Component component = result;
            if (component == null) {
                StylesNameRenderer.$$$reportNull$$$0(1);
            }
            return component;
        }

        @Override
        public void paint(@NotNull Graphics g) {
            if (g == null) {
                StylesNameRenderer.$$$reportNull$$$0(2);
            }
            super.paint(g);
            if (this.myStrikeout) {
                Dimension size = this.getSize();
                Dimension prefSize = this.getPreferredSize();
                int width = Math.min(size.width, prefSize.width);
                int iconWidth = 0;
                Icon icon = this.getIcon();
                if (icon != null) {
                    iconWidth = icon.getIconWidth();
                    iconWidth += this.getIconTextGap();
                }
                g.setColor(this.getForeground());
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)iconWidth, (double)(size.height / 2), (double)width, (double)(size.height / 2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/browse/CssStyles$StylesNameRenderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/browse/CssStyles$StylesNameRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTreeCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTreeCellRendererComponent";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

