/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.images;

import com.intellij.css.util.CssImageUtil;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.css.util.CssUriUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.intellij.images.index.ImageInfoIndex;
import org.intellij.images.util.ImageInfo;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssUpdateBackgroundImageSizeIntention
extends CssBaseElementAtCaretIntentionAction {
    private static final String EMPTY_STRING = "";
    private static final Logger LOG = Logger.getInstance(CssUpdateBackgroundImageSizeIntention.class);

    public void invoke(@NotNull Project project, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(1);
        }
        boolean allSizesAreEqual = true;
        ImageInfoReader.Info lastAddedInfo = null;
        final LinkedHashMap<CssUri, ImageInfoReader.Info> uri2size = new LinkedHashMap<CssUri, ImageInfoReader.Info>();
        final CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class, (boolean)false);
        if (block != null) {
            Collection imageUris = CssImageUtil.findBackgroundImageUris((PsiElement)element);
            if (imageUris.isEmpty()) {
                imageUris = CssImageUtil.findBackgroundImageUrlsInBlock((CssBlock)block);
            }
            for (CssUri imageUri : imageUris) {
                ImageInfoReader.Info info = CssUpdateBackgroundImageSizeIntention.getImageInfo(project, (VirtualFile)ContainerUtil.getFirstItem((Collection)CssImageUtil.getImageFiles((CssElement)imageUri)));
                if (info == null && CssUriUtil.isDataUri((PsiElement)imageUri)) {
                    info = CssUpdateBackgroundImageSizeIntention.calculateImageInfoInBackground(project, URLUtil.getBytesFromDataUri((String)imageUri.getValue()));
                }
                if (info == null || info.width <= 0 || info.height <= 0) continue;
                uri2size.put(imageUri, info);
                allSizesAreEqual &= lastAddedInfo == null || lastAddedInfo.equals((Object)info);
                lastAddedInfo = info;
            }
        }
        if (uri2size.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"css.intentions.update.background.image.size.error", (Object[])new Object[0]), (String)EMPTY_STRING, null);
            return;
        }
        if (allSizesAreEqual || ApplicationManager.getApplication().isUnitTestMode()) {
            Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(uri2size.entrySet());
            assert (item != null);
            CssUpdateBackgroundImageSizeIntention.updateSize(block, (CssUri)item.getKey(), editor, (ImageInfoReader.Info)item.getValue());
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, new ArrayList(uri2size.keySet()), (Pass)new Pass<CssUri>(){

                public void pass(@NotNull CssUri e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CssUpdateBackgroundImageSizeIntention.updateSize(block, e, editor, (ImageInfoReader.Info)uri2size.get(e));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/actions/images/CssUpdateBackgroundImageSizeIntention$1", "pass"));
                }
            }, string -> {
                String value = string.getValue();
                String result = CssUriUtil.isDataUri((PsiElement)string) && value.length() > 30 ? value.substring(30) + "..." : value;
                ImageInfoReader.Info info = (ImageInfoReader.Info)uri2size.get(string);
                return info != null ? String.format("%s (%dx%d)", result, info.width, info.height) : result;
            }, (String)CssBundle.message((String)"dialog.title.images", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class, (boolean)false);
        if (block != null) {
            Collection imageUris = CssImageUtil.findBackgroundImageUris((PsiElement)element);
            if (imageUris.isEmpty()) {
                imageUris = CssImageUtil.findBackgroundImageUrlsInBlock((CssBlock)block);
            }
            for (CssUri imageUri : imageUris) {
                Collection files = CssImageUtil.getImageFiles((CssElement)imageUri);
                if (files.size() != 1 && !CssUriUtil.isDataUri((PsiElement)imageUri)) continue;
                this.setText(CssBundle.message((String)(block.findDeclaration("height") != null || block.findDeclaration("width") != null ? "css.intentions.update.background.image.size" : "css.intentions.insert.background.image.size"), (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static ImageInfoReader.Info calculateImageInfoInBackground(@NotNull Project project, byte @Nullable [] imageBytes) {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(4);
        }
        if (imageBytes == null) {
            return null;
        }
        try {
            return (ImageInfoReader.Info)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ImageInfoReader.getInfo((byte[])imageBytes), CssBundle.message((String)"progress.title.calculating.image.size", (Object[])new Object[0]), true, project);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static ImageInfoReader.Info getImageInfo(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(5);
        }
        if (file == null) {
            return null;
        }
        ImageInfo imageInfo = ImageInfoIndex.getInfo((VirtualFile)file, (Project)project);
        if (imageInfo != null) {
            return new ImageInfoReader.Info(imageInfo.width, imageInfo.height, 0, FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SvgFileType.INSTANCE));
        }
        try {
            return CssUpdateBackgroundImageSizeIntention.calculateImageInfoInBackground(project, file.contentsToByteArray());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void updateSize(CssBlock block, CssUri imageUri, Editor editor, ImageInfoReader.Info size) {
        WriteCommandAction.writeCommandAction((Project)block.getProject(), (PsiFile[])new PsiFile[]{imageUri.getContainingFile()}).run(() -> {
            if (size.width <= 0 || size.height <= 0) {
                CommonRefactoringUtil.showErrorHint((Project)block.getProject(), (Editor)editor, (String)CssBundle.message((String)"css.intentions.update.background.image.calculate.size.error", (Object[])new Object[0]), (String)EMPTY_STRING, null);
                return;
            }
            CssDeclaration anchor = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)imageUri, CssDeclaration.class);
            CssBlock newBlock = CssUpdateBackgroundImageSizeIntention.updateOrInsertSize("height", size.height + "px", block, anchor);
            LOG.assertTrue(newBlock != null, (Object)AttachmentFactory.createAttachment((Document)editor.getDocument()));
            CssUpdateBackgroundImageSizeIntention.updateOrInsertSize("width", size.width + "px", newBlock, anchor);
        });
    }

    @Nullable
    private static CssBlock updateOrInsertSize(String propertyName, String newValue, CssBlock block, CssDeclaration anchor) {
        CssDeclaration property = block.findDeclaration(propertyName, false);
        if (property == null) {
            CssDeclaration declaration = block.addDeclaration(propertyName, newValue, anchor);
            return (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)declaration, CssBlock.class);
        }
        property.setValue(newValue);
        return block;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.intentions.update.background.image.size", (Object[])new Object[0]);
        if (string == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/images/CssUpdateBackgroundImageSizeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/images/CssUpdateBackgroundImageSizeIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateImageInfoInBackground";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImageInfo";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

